/*$Id: d_res.cc,v 15.15 1999/10/22 06:36:22 al Exp $ -*- C++ -*-
 * functions for resistor.
 * x = amps, y.f0 = volts, ev = y.f1 = ohms
 */
#include "d_res.h"
/*--------------------------------------------------------------------------*/
void DEV_RESISTANCE::precalc()
{
  if (value() == 0. && !has_common()){
    error(bPICKY, long_label() + ": short circuit\n");
  }
  y0.f0 = LINEAR;
  y0.f1 = (value() != 0.) ? value() : OPT::shortckt;
  y1 = y0;
  m0.c1 = 1./y0.f1;
  m0.c0 = 0.;
  assert(loss == 0.);
  set_constant(!has_tr_eval());
  set_converged(!has_tr_eval());
}
/*--------------------------------------------------------------------------*/
void DEV_RESISTANCE::dc_begin()
{
  if (!has_tr_eval()){
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value() || y0.f1 == OPT::shortckt);
    assert(conchk(m0.c1, 1./y0.f1, OPT::abstol));
    assert(m0.c0 == 0.);
    assert(loss == 0.);
  }
}
/*--------------------------------------------------------------------------*/
bool DEV_RESISTANCE::do_tr()
{
  {if (has_tr_eval()){
    m0.x = volts_limited(n[OUT1],n[OUT2]);
    y0.x = m0.c0 + m0.c1 * m0.x;
    tr_eval();
    assert(y0.f0 != LINEAR);
    if (y0.f1 == 0.){
      untested();
      error(bPICKY, long_label() + ": short circuit\n");
      y0.f1 = OPT::shortckt;
    }
    store_values();
    q_load();
    m0.c1 = 1./y0.f1;
    m0.c0 = y0.x - y0.f0 / y0.f1;
  }else{
    assert(y0.f0 == LINEAR);
    assert(y0.f1 == value() || y0.f1 == OPT::shortckt);
    assert(conchk(m0.c1, 1./y0.f1, OPT::abstol));
    assert(m0.c0 == 0.);
    assert(y1 == y0);
    assert(converged());
  }}
  return converged();
}
/*--------------------------------------------------------------------------*/
void DEV_RESISTANCE::do_ac()
{
  {if (has_ac_eval()){
    ac_eval();
    if (ev == 0.){
      error(bPICKY, long_label() + ": short circuit\n");
      ev = OPT::shortckt;
    }
    acg = 1. / ev;
  }else{
    assert(ev == y0.f1);
    assert(has_tr_eval() || ev == value());
  }}
  assert(acg == 1./ev);
  ac_load_passive();
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
