/*$Id: bm_sffm.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * SPICE compatible SFFM
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_SFFM::EVAL_BM_SFFM(int c);
//		EVAL_BM_SFFM::EVAL_BM_SFFM(const EVAL_BM_SFFM&);
//	void	EVAL_BM_SFFM::parse(CS& cmd);
// 	void	EVAL_BM_SFFM::print(int)const;
//	void	EVAL_BM_SFFM::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_offset	(0);
const double _default_amplitude	(1);
const double _default_carrier	(NOT_INPUT);
const double _default_modindex	(NOT_INPUT);
const double _default_signal	(NOT_INPUT);
/*--------------------------------------------------------------------------*/
EVAL_BM_SFFM::EVAL_BM_SFFM(int c)
  :EVAL_BM_ACTION_BASE(c),
   _offset(_default_offset),
   _amplitude(_default_amplitude),
   _carrier(_default_carrier),
   _modindex(_default_modindex),
   _signal(_default_signal),
   _end(NOT_VALID)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_SFFM::EVAL_BM_SFFM(const EVAL_BM_SFFM& p)
  :EVAL_BM_ACTION_BASE(p),
   _offset(p._offset),
   _amplitude(p._amplitude),
   _carrier(p._carrier),
   _modindex(p._modindex),
   _signal(p._signal),
   _end(NOT_VALID)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SFFM::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    double* i;
    for (i = &_offset;  i < &_end;  ++i){
      double value=NOT_VALID;
      cmd >> value;
      {if (cmd.stuck()){
	break;
      }else{
	untested();
      }}
      *i = value;
    }
    assert(i <= &_end);
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("Offset",	&_offset);
    cmd.get("Amplitude",&_amplitude);
    cmd.get("Carrier",	&_carrier);
    cmd.get("Modindex",	&_modindex);
    cmd.get("Signal",	&_signal);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SFFM::print(OMSTREAM where)const
{
  where << "  " << name()
	<< "  offset="	 << _offset
	<< "  amplitude="<< _amplitude
	<< "  carrier="	 << _carrier
	<< "  modindex=" << _modindex
	<< "  signal="	 << _signal;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_SFFM::tr_eval(COMPONENT* d)const
{
  double time = SIM::time0;
  double mod = (_modindex * sin(kPIx2*_signal*time));
  double ev = _offset + _amplitude * sin(kPIx2*_carrier*time + mod);
  tr_finish_tdv(d, ev);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
