/*$Id: bm_exp.cc,v 15.19 1999/11/03 18:07:50 al Exp $ -*- C++ -*-
 * SPICE compatible EXP
 */
#include "ap.h"
#include "bm.h"
/*--------------------------------------------------------------------------*/
//		EVAL_BM_EXP::EVAL_BM_EXP(int c);
//		EVAL_BM_EXP::EVAL_BM_EXP(const EVAL_BM_EXP&);
//	void	EVAL_BM_EXP::parse(CS& cmd);
// 	void	EVAL_BM_EXP::print(int)const;
//	void	EVAL_BM_EXP::tr_eval(COMPONENT* d)const;
/*--------------------------------------------------------------------------*/
const double _default_iv    (NOT_INPUT);
const double _default_pv    (NOT_INPUT);
const double _default_td1   (0);
const double _default_tau1  (0);
const double _default_td2   (0);
const double _default_tau2  (0);
const double _default_period(BIGBIG);
/*--------------------------------------------------------------------------*/
EVAL_BM_EXP::EVAL_BM_EXP(int c)
  :EVAL_BM_ACTION_BASE(c),
   _iv(_default_iv),
   _pv(_default_pv),
   _td1(_default_td1),
   _tau1(_default_tau1),
   _td2(_default_td2),
   _tau2(_default_tau2),
   _period(_default_period),
   _end(NOT_VALID)
{
}
/*--------------------------------------------------------------------------*/
EVAL_BM_EXP::EVAL_BM_EXP(const EVAL_BM_EXP& p)
  :EVAL_BM_ACTION_BASE(p),
   _iv(p._iv),
   _pv(p._pv),
   _td1(p._td1),
   _tau1(p._tau1),
   _td2(p._td2),
   _tau2(p._tau2),
   _period(p._period),
   _end(NOT_VALID)
{
  untested();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_EXP::parse(CS& cmd)
{
  cmd.stuck();
  do{
    int paren = cmd.skiplparen();
    double* i;
    for (i = &_iv;  i < &_end;  ++i){
      double value=NOT_VALID;
      cmd >> value;
      if (cmd.stuck()){
	break;
      }
      *i = value;
    }
    assert(i <= &_end);
    paren -= cmd.skiprparen();
    if (paren != 0){
      untested();
      cmd.warn(bWARNING, "need )");
    }
    cmd.get("IV",	&_iv);
    cmd.get("PV",	&_pv);
    cmd.get("TD1",	&_td1);
    cmd.get("TAU1",	&_tau1);
    cmd.get("TD2",	&_td2);
    cmd.get("TAU2",	&_tau2);
    cmd.get("PERiod",	&_period);
    parse_base(cmd);
  }while (cmd.more() && !cmd.stuck());
  parse_base_finish();
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_EXP::print(OMSTREAM where)const
{
  where << "  " << name()
	<< "  iv="	<< _iv
	<< "  pv="	<< _pv
	<< "  td1="	<< _td1
	<< "  tau1="	<< _tau1
	<< "  td2="	<< _td2
	<< "  tau2="	<< _tau2
	<< "  period="	<< _period;
  print_base(where);
}
/*--------------------------------------------------------------------------*/
void EVAL_BM_EXP::tr_eval(COMPONENT* d)const
{
  double ev = _iv;
  for (double time = SIM::time0;  time >= 0;  time -= _period){
    if (time > _td1){
      ev += (_pv - _iv) * (1. - Exp(-(time-_td1)/_tau1));
    }
    if (time > _td2){
      ev += (_iv - _pv) * (1. - Exp(-(time-_td2)/_tau2));
    }
  }
  tr_finish_tdv(d, ev);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
