/****************************************************************************
**
** genparse.c
**
** Michael S. Borella 
**
** A command-line parser generator
**
****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <time.h>
#include <malloc.h>
#include "genparse.h"
#include "parse_cl.h"
#include "error.h"

char *includes[MAX_INCLUDES];
char global_callback[TOKEN_SIZE];
char *mandatory = NULL;
char *yyfilename;
clarg_t arg_array[MAX_FLAGS]; /* This is not efficient - make it a list? */
struct arg_t *my_args;

extern char version[];
extern FILE *yyin;

/*---------------------------------------------------------------------------
 * 
 * main()
 *
 *-------------------------------------------------------------------------*/

int main(int argc, char *argv[])
{
  FILE *ifp, *ofp;
  char *h_file;
  void print_header(FILE *, char *, char *);
  void print_funcbegin(FILE *, clarg_t *, char *);
  void print_flags(FILE *, clarg_t *);
  void print_funcend(FILE *); 
  void print_usage(FILE *, clarg_t *);
  int yyparse(void);
  void dump_args(void);
  int get_current_flag(void);
  char *create_header_file(char *, clarg_t *);
  void create_callbacks(char *,  clarg_t *);
  void print_free_args(FILE *, clarg_t *);


  /*
   * Announce who we are
   */

  printf("genparse v%s\n", version);

  /*
   * Check for a file name on the command line.  Here's what we do: First
   * check for no arguments at all, and use stdin if that is the case. Then 
   * try to open the last argument.  If that fails, we assume it is an option
   * and that no file name is given, and we'll use stdin
   */
  
  global_callback[0] = '\0';
  if (argc == 1)
    {
      yyin = stdin;
    }
  else
    {
      yyfilename = argv[argc-1];
      if (yyfilename[0] == '-')
	{
	  my_args = parse_cl(argc, argv);
	}
      else
	{
	  ifp = fopen(yyfilename, "r");
	  if (ifp == NULL) 
	    yyin = stdin;
	  else
	    yyin = ifp;
	  my_args = parse_cl(argc-1, (char **) argv);
	}
    } /* else */

  yyparse();

  /*
   * Dump out all of the parameter details
   */

  if (DEBUG) 
    dump_args();
  
  /*
   * Now that we've successfully parsed the input file, let's create
   * the output file.  Let the user know...
   */

  printf("read %d flags...", get_current_flag()+1); 

  /*
   * Create header file for including
   */

  h_file = strdup(create_header_file(my_args->o, arg_array));

  /*
   * Open output file
   */

  ofp = fopen(my_args->o, "w");
  if (ofp == NULL)
    ftlerr("can't create %s", my_args->o);

  /*
   * Print all of the sections.  This is not efficient but we're dealing
   * with small amounts of data so who cares?
   */

  print_header(ofp, my_args->o, h_file);
  print_usage(ofp, arg_array);
  print_free_args(ofp, arg_array);
  print_funcbegin(ofp, arg_array, my_args->o);
  print_flags(ofp, arg_array);
  print_funcend(ofp);

  /*
   * Do the callback functions
   */

  create_callbacks(my_args->o, arg_array);

  /*
   * That's it.  Stop
   */
  
  printf("done\n");
  fclose (ofp);
  exit(0);
  
}
