;;;; From: Bill Newman <wnewman@netcom.com>
;;;; Subject: apparent bug in BLOCK/RETURN-FROM compilation

;;; The compiler fails on the following.  Defining any of the features
;;; SIMPLE1, SIMPLE2, or SIMPLE3 simplifies the function enough that
;;; CMUCL is able to compile it.

;;; The assertion failure is very similar to that produced by bug08.lisp.

(defun bar (x)
  (if (or #-simple1 (fixnump x)
          (block tricky-bit-found
            (let ((hunting-ground (cdr x)))
              (flet ((possibly-tricky (element)
                       (dolist (ee element)
                         (when (tricky? ee)
                           (return-from tricky-bit-found ee)))))
                (declare (inline possibly-tricky))
                (dolist (z hunting-ground)
                  (etypecase z
                    #-simple2 (fixnum (possibly-tricky z))
                    #-simple3 (list (dolist (i z)
                                      (possibly-tricky i)))))))))
      12
      13))
