/* #Specification: pppwatch / principle
	To handle dedicated ppp connection (24/24 7/7), the utility
	pppwatch is called. It receives minimally two arguments.
	The first is the path of a control file and the others are the command
	and argument of a command used to establish a PPP link. Normally
	pppwatch is called this way

	#
	pppwatch /var/run/ppprestart.config netconf --connect config --fore
	#

	The control file is created by pppwatch. It execute the command
	until this file is erased (by anyone or linuxconf). For example
	to terminate a PPP connection, you would do

	#
	rm /var/run/ppprestart.config
	netconf --disconnect config
	#

	But netconf does it for you. pppwatch is very simple and could
	be written as a script. For efficiency (use much less memory), it is
	written in C++. Here is a sample script showing what it does
	#
	#!/bin/sh
	if [ $# = 0 ] ; then
		echo pppwatch control_file ppp connection command and args
	else
		ctrl=$1
		shift
		touch $ctrl
		while [ -f $ctrl ]
		do
			$*
		done
	fi
	#

	Note that the pppwatch utility is called directly by linuxconf
	but the effective path may be overriden by the admin. The above
	script might be use as a start to customise this process, if needed.
*/

#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <signal.h>
#include <unistd.h>

int main (int argc, char *argv[])
{
	int ret = -1;
	if (argc < 3){
		fprintf (stderr,"pppwatch control_file command ...\n");
	}else{
		const char *control = argv[1];
		FILE *fout = fopen (control,"w");
		if (fout == NULL){
			fprintf (stderr,"Can't create control file %s (%s)\n"
					,control,strerror(errno));
		}else{
			fclose (fout);
			ret = 0;
			signal (SIGCHLD,SIG_IGN);
			if (fork()==0){
				while (1){
					// Make sure the control file is still there
					struct stat st;
					if (stat(control,&st)==-1) break;
					pid_t pid = fork();
					if (pid == 0){
						execv (argv[2],(char **)argv+2);
						_exit (-1);
					}else if (pid == -1){
						break;
					}else{
						while (1){
							int status;
							pid_t p = wait (&status);
							if (p == pid || p == -1) break;
						}
					}
				}
				_exit (0);
			}
		}
	}
	return ret;
}

