
#include <std.h>

#include <list/colors.h>

#include "captris.h"
#include "acquire.h"

char Captris::board[BOARD_HEIGHT][BOARD_WIDTH + 1] = {
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"|               |",
	"+---------------+",
};

/* penta[TYPE][ROTATION][LINE][CHAR]*/
char Captris::penta[NUM_TYPES][4][4][5] = {
	{
	 {"OOO ",
	  "  O ",
	  "    ",
	  "    "},

	 {" O  ",
	  " O  ",
	  "OO  ",
	  "    "},


	 {"O   ",
	  "OOO ",
	  "    ",
	  "    "},

	 {"OO  ",
	  "O   ",
	  "O   ",
	  "    "},
	 },
	{
	 {"OOO ",
	  "O   ",
	  "    ",
	  "    "},

	 {"OO  ",
	  " O  ",
	  " O  ",
	  "    "},

	 {"  O ",
	  "OOO ",
	  "    ",
	  "    "},

	 {"O   ",
	  "O   ",
	  "OO  ",
	  "    "},
	 },
	{
	 {"OO  ",
	  "OO  ",
	  "    ",
	  "    "},

	 {"OO  ",
	  "OO  ",
	  "    ",
	  "    "},

	 {"OO  ",
	  "OO  ",
	  "    ",
	  "    "},

	 {"OO  ",
	  "OO  ",
	  "    ",
	  "    "},
	 },
	{
	 {"O   ",
	  "O   ",
	  "O   ",
	  "O   "},

	 {"OOOO",
	  "    ",
	  "    ",
	  "    "},

	 {"O   ",
	  "O   ",
	  "O   ",
	  "O   "},

	 {"OOOO",
	  "    ",
	  "    ",
	  "    "},
	 },
	{
	 {"O   ",
	  "OO  ",
	  " O  ",
	  "    "},

	 {" OO ",
	  "OO  ",
	  "    ",
	  "    "},

	 {"O   ",
	  "OO  ",
	  " O  ",
	  "    "},

	 {" OO ",
	  "OO  ",
	  "    ",
	  "    "},
	 },
	{
	 {" O  ",
	  "OO  ",
	  "O   ",
	  "    "},

	 {"OO  ",
	  " OO ",
	  "    ",
	  "    "},

	 {" O  ",
	  "OO  ",
	  "O   ",
	  "    "},

	 {"OO  ",
	  " OO ",
	  "    ",
	  "    "},
	 },
	{
	 {"OOO ",
	  " O  ",
	  "    ",
	  "    "},

	 {" O  ",
	  "OO  ",
	  " O  ",
	  "    "},

	 {" O  ",
	  "OOO ",
	  "    ",
	  "    "},

	 {"O   ",
	  "OO  ",
	  "O   ",
	  "    "},
	 },
};

Captris::Captris(pkgAcquireInterface * myOwner)
{
	Owner = myOwner;

	score = 0;
	level = 1;
	advance_us = 700000;
}

Captris::~Captris()
{
}

int Captris::collision(int type, int rot, int x, int y)
{
	int i, j;

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			if (y + j >= 0 && penta[type][rot][j][i] != ' ' && board[y + j][x + i] != ' ')
				return TRUE;
	return FALSE;
}

void Captris::add_to_board(int type, int rot, int x, int y)
{
	int i, j;
	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			if (y + 4 >= 0 && penta[type][rot][j][i] != ' ')
				board[y + j][x + i] = penta[type][rot][j][i];
}

void Captris::clear_board()
{
	int j;

	for (j = 1; j < BOARD_HEIGHT - 1; j++)
		strcpy(board[j], "|               |");
}

void Captris::check_lines()
{
	int j, j2;
	int count = 0;
	static long lastscore = 0;

	for (j = BOARD_HEIGHT - 1; j > -1; j--)
	{
		if (!strcmp(board[j], "|OOOOOOOOOOOOOOO|"))
		{
			count++;
			for (j2 = j - 1; j2 > -1; j2--)
				strcpy(board[j2 + 1], board[j2]);
			/* reconsider this line */
			j++;
		}
	}

	if (!count)
		return;

	if (count == 1)
		score += 100;
	else if (count == 2)
		score += 500;
	else
		score += 5000;

	if (score - lastscore > 2000)
	{
		level++;
		(int) advance_us /= 0.70;
		lastscore = score;
	}

}

int Captris::advance_y(int wait)
{
	static long last_advance = 0;
	struct timeval tv;
	struct timezone tz;

	if (wait < 2)
		wait = 2;

	gettimeofday(&tv, &tz);
	if (abs((1000000 * tv.tv_sec + tv.tv_usec) - last_advance) > (advance_us / wait - 1))
	{
		last_advance = 1000000 * tv.tv_sec + tv.tv_usec;
		return TRUE;
	};
	return FALSE;
}

void Captris::generate_new_penta()
{
	do
	{
		ntype = rand() % NUM_TYPES;
		nrot = rand() % 4;
	}
	while (collision(ntype, nrot, BOARD_WIDTH / 2 - 1, 0));
}

void Captris::init_draw()
{
	int j;

	wattrset(Owner->extra->body(), Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);

	for (j = 0; j < BOARD_HEIGHT + 1; j++)
		mvwaddstr(Owner->extra->body(), j + 1, 1, board[j]);

	text_draw();
}

void Captris::text_draw()
{
	wattrset(Owner->extra->body(), Pair(COLOR_WHITE, COLOR_BLUE));

	mvwaddstr(Owner->extra->body(), 3, BOARD_WIDTH + 3, "score: ");
	mvwaddstr(Owner->extra->body(), 6, BOARD_WIDTH + 3, "level: ");
	mvwaddstr(Owner->extra->body(), 9, BOARD_WIDTH + 3, "next : ");
}

void Captris::draw()
{
	int i, j;
	static char strscore[20];

	wattrset(Owner->extra->body(), Pair(COLOR_GREEN, COLOR_BLUE) | A_BOLD);

	for (j = 0; j < BOARD_HEIGHT + 1; j++)
		mvwaddstr(Owner->extra->body(), j, 1, board[j]);

	wattrset(Owner->extra->body(), Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD);

	for (i = 0; i < 4; i++)
		for (j = 0; j < 4; j++)
			if (j + cy >= 0 && penta[ctype][crot][j][i] != ' ')
				mvwaddch(Owner->extra->body(), j + cy, i + cx + 1, penta[ctype][crot][j][i]);

	text_draw();

	wattrset(Owner->extra->body(), Pair(COLOR_MAGENTA, COLOR_BLUE) | A_BOLD);

	snprintf(strscore, 20, "%lu", score);
	mvwaddstr(Owner->extra->body(), 3, BOARD_WIDTH + 10, strscore);
	snprintf(strscore, 20, "%lu", level);
	mvwaddstr(Owner->extra->body(), 6, BOARD_WIDTH + 10, strscore);

	wattrset(Owner->extra->body(), Pair(COLOR_YELLOW, COLOR_BLUE) | A_BOLD);

	for (j = 0; j < 4; j++)
		mvwaddstr(Owner->extra->body(), j + 9, BOARD_WIDTH + 10, penta[ntype][nrot][j]);

	Owner->extra->Refresh();
}

void Captris::initiate()
{
	paused = false;
	waitcount = 0;

	srand((unsigned int) time(NULL));

	init_draw();
	generate_new_penta();
	ctype = ntype;
	crot = nrot;
	generate_new_penta();
	cx = BOARD_WIDTH / 2 - 1;
	cy = -2;

	pulse();
}


void Captris::pulse()
{
	if (paused == true)
		return;

	if (advance_y(waitcount))
	{
		if (!collision(ctype, crot, cx, cy + 1))
			cy++;
		else
		{
			waitcount++;
			if (waitcount == 2)	//  || ch==KEY_DOWN)  errrrrrr
			{
				waitcount = 0;

				if (cy < 1)
				{
					paused = false;
					clear_board();
					draw();

					wattrset(Owner->extra->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

					mvwaddstr(Owner->extra->body(), 4, 4, "            ");
					mvwaddstr(Owner->extra->body(), 5, 4, " GAME OVER  ");
					mvwaddstr(Owner->extra->body(), 6, 4, " Space to   ");
					mvwaddstr(Owner->extra->body(), 7, 4, " play again ");
					mvwaddstr(Owner->extra->body(), 8, 4, "            ");
					Owner->extra->Refresh();
					return;
				}

				add_to_board(ctype, crot, cx, cy);
				draw();
				ctype = ntype;
				crot = nrot;
				cx = BOARD_WIDTH / 2 - 1;
				cy = -2;
				generate_new_penta();
				return;
			}
		}
	}

	check_lines();
	draw();
}

void Captris::handlekey(int ch)
{

	if (paused == true)
	{
		if (ch == ' ')
		{
			draw();
			paused = false;
		}
		return;
	}

	if (ch == 'p' || ch == 'P')
	{
		paused = true;

		wattrset(Owner->extra->body(), Pair(COLOR_WHITE, COLOR_BLUE) | A_BOLD);

		mvwaddstr(Owner->extra->body(), 4, 4, "          ");
		mvwaddstr(Owner->extra->body(), 5, 4, "  PAUSED  ");
		mvwaddstr(Owner->extra->body(), 6, 4, " Space to ");
		mvwaddstr(Owner->extra->body(), 7, 4, " unpause  ");
		mvwaddstr(Owner->extra->body(), 8, 4, "          ");
		Owner->extra->Refresh();
		return;
	}

	else if ((ch == ' ' || ch == KEY_UP || ch == '8') && !collision(ctype, (crot + 1) % 4, cx, cy))
		crot = (crot + 1) % 4;
	else if ((ch == KEY_DOWN || ch == '5') && !collision(ctype, crot, cx, cy + 1))
		cy++;
	else if ((ch == KEY_LEFT || ch == '7') && cx > 1 && !collision(ctype, crot, cx - 1, cy))
		cx--;
	else if ((ch == KEY_RIGHT || ch == '9') && (cy >= 0 || !collision(ctype, crot, cx + 1, 0)) && !collision(ctype, crot, cx + 1, cy))
		cx++;

	check_lines();
	draw();
}
