
#ifndef std_H
#define std_H

#include <config.h>

#include <iostream.h>
#include <string.h>
#include <list.h>

#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/time.h>
#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <assert.h>

#include <apt-pkg/configuration.h>
#include <apt-pkg/progress.h>
#include <apt-pkg/sourcelist.h>
#include <apt-pkg/depcache.h>
#include <apt-pkg/init.h>
#include <apt-pkg/pkgcachegen.h>
#include <apt-pkg/pkgrecords.h>
#include <apt-pkg/cachefile.h>
#include <apt-pkg/error.h>
#include <apt-pkg/acquire-item.h>
#include <apt-pkg/acquire-worker.h>
#include <apt-pkg/strutl.h>
#include <apt-pkg/dpkgpm.h>
#include <apt-pkg/algorithms.h>

#include <ncurses.h>

extern char const *internal_version;
extern char *search_pattern;

extern void capt_clean_exit(void);

#define DEBUGEXIT(x) { endwin(); fprintf(stderr, "Exit: \"%s\"\n", x); exit(0); }

#define myassert(truth, text) if ((truth) == false) {endwin(); fprintf(stderr, "Assertion failure: %s\n", text);}

#endif /* std_H */
