// vs_statusedit.h  -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Code to edit a string in the status line.

#ifndef VS_STATUSEDIT
#define VS_STATUSEDIT

#include "vs_tree.h"

class vs_statusedit:public vs_tree_status
{
  string prompt;
  string text;
public:
  vs_statusedit(vs_tree *_owner, string _prompt, string _text="")
    :vs_tree_status(_owner), prompt(_prompt), text(_text)
  {
    _owner->leaveok(false);
  }

  bool dispatch_char(chtype ch);
  void display();

  virtual void entered(string val)=0;
  // Called when the user presses Enter to confirm the text
};

#endif
