// pkg_item_with_subtree.h   (this is -*-c++-*-)
//
//  Copyright 1999 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  A package item with an associated subtree.  More useful than you might
// think ;-)

#ifndef PKG_ITEM_WITH_SUBTREE_H
#define PKG_ITEM_WITH_SUBTREE_H

#include "pkg_item.h"
#include "vs_subtree.h"

template<class child, class sorter>
class pkg_item_with_subtree:public vs_subtree<child, sorter>, public pkg_item
{
public:
  pkg_item_with_subtree<child,sorter>(pkgCache::PkgIterator _package, bool _expanded=false):vs_subtree<child, sorter>(_expanded), pkg_item(_package) {}

  virtual void display(vs_tree *win, int y)
  {
    vs_subtree<child, sorter>::display(win, y, get_package().Name());
  }

  bool dispatch_char(chtype ch)
  {
    if(pkg_item::dispatch_char(ch))
      return true;
    else
      return vs_subtree<child, sorter>::dispatch_char(ch);
  }
};

typedef pkg_item_with_subtree<vs_treeitem, tag_sort_policy> pkg_item_with_generic_subtree;
typedef pkg_item_with_subtree<pkg_tree_node, tag_sort_policy> pkg_item_with_pkgnode_subtree;

#endif
