// pkg_info_screen.h     -*-c++-*-
//
//  Copyright 2000 Daniel Burrows
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; see the file COPYING.  If not, write to
//  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//  Boston, MA 02111-1307, USA.
//
//  Gathers information about a package into one
// spot (pkg_grouppolicy_info_factory) and provides dedicated code to display
// it (pkg_info_screen)

#ifndef PKG_INFO_SCREEN_H
#define PKG_INFO_SCREEN_H

#include "pkg_grouppolicy.h"
#include "vs_tree.h"

#include <apt-pkg/cacheiterators.h>

class pkg_grouppolicy_info_factory:public pkg_grouppolicy_factory
{
public:
  pkg_grouppolicy *instantiate(pkg_subtree *root);
};

class pkg_info_screen:public vs_tree
{
  vscreen *prev;
public:
  pkg_info_screen(pkgCache::PkgIterator pkg);

  void dispatch_char(chtype ch);
};

#endif
