# library file sourced by apt-zip-*

VERSION=0.9

CONFFILE=/etc/apt/apt-zip.conf
METHODSDIR=/usr/share/apt-zip
SKIPMOUNT=no
APTGETEXTRAOPTS=""

KNOWNOPTIONS="TAR"

APTZIPTARFILE=debs-$(uname -n).tar
export APTZIPTARFILE

error()
{
    echo 2>&1 "$(basename $0): $*"
    exit 1
}

version_exit()
{
    echo "$(basename $0) version ${VERSION}"
    exit 0
}

usage()
{
cat <<EOF
Usage:
	$(basename $0) [options]

where options can be:
    --help          Print this help message
    --version       Print version and exit
    --method=<meth> Select fetch method \`meth' to be used on download host
    --medium=<dir>   Select removable medium at mountpoint \`dir' for the transfers
    --options=<st>  Selects comma-separated list of options
    --fix-broken    Call apt-get with this flag
    --skip-mount    Do not attempt to mount a device on the dir specified by --medium 
EOF
}

usage_exit()
{
    usage
    exit 0
}

syntax_error()
{
    echo 2>&1 "$(basename $0): $*"
    usage
    exit 1
}

check_method()
{
    # If we're in the source tree, use it
    if [ -d methods -a -r apt-zip.sgml ]
    then
	METHODSDIR=$(pwd)/methods
    fi

    FILTER=$METHODSDIR/$METHOD
    if [ ! -x $FILTER ]
    then
	error "No $METHOD method installed."
    fi
}

check_medium()
{
    [ -d $MEDIUM ] || error "$MEDIUM does not exist (no mountpoint)"
}

az_loadconf()
{
    if [ -r $CONFFILE ]
    then
	. $CONFFILE
    else
	METHOD=wget
	MEDIUM=/ZIP
	OPTIONS=
    fi
}

az_process_opts ()
{
    while [ $# -gt 0 ]
    do
	case $1 in
	--method=*)
	    METHOD=${1#--method=}
	    shift
	    ;;
	--method|-M)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    METHOD=$2
	    shift
	    shift
	    ;;
	--medium=*)
	    MEDIUM=${1#--medium=}
	    shift
	    ;;
	--medium|-m)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    MEDIUM=$2
	    shift
	    shift
	    ;;
	--options=*)
	    OPTIONS=${1#--options=}
	    shift
	    ;;
	--options|-o)
	    if [ $# -lt 2 ]; then syntax_error "$1 needs an argument"; fi
	    OPTIONS=$2
	    shift
	    shift
	    ;;
	--fix-broken|-f)
	    APTGETEXTRAOPTS="${APTGETEXTRAOPTS} $1"
	    shift
	    ;;
	--skip-mount)
	    SKIPMOUNT=yes
	    shift
	    ;;
	--version|-V)
	    version_exit
	    ;;
	--help|-h)
	    usage_exit
	    ;;
	-*)
	    syntax_error "Unknown option \`$1'"
	    ;;
	*)
	    syntax_error "No non-option arguments allowed"
	    ;;
	esac
    done
}

az_init()
{
    az_loadconf
    az_process_opts $*

    OPTIONS=$(echo "$OPTIONS" | tr ",a-z" " A-Z")
    for opt in $OPTIONS
    do
	# Warn if unknown option
	local opt_known=0
	for kopt in $KNOWNOPTIONS
	do
	    if [ $opt = $kopt ]
	    then
		opt_known=1
	    fi
	done
	[ $opt_known = 0 ] && echo >&2 "WARNING: Unknown option \`$opt'"

	# Export option
	eval export OPTION_${opt}=1
    done

    check_method
    check_medium

    if [ "$SKIPMOUNT" = no ]
    then
	# Maybe mount removable medium
	MNTENTRY=$(mount | egrep "^[^ ]+ on $MEDIUM type ")
	if [ "$MNTENTRY" ]
	then
	    WAS_MOUNTED=1
	    if mount | grep "$MEDIUM.*[(,]ro[,)]" >/dev/null
	    then
		error "$MEDIUM is mounted READ ONLY"
	    fi
	else
	    WAS_MOUNTED=0
	    echo "Mounting $MEDIUM"
	    local out=$(env LC_ALL=C mount $MEDIUM 2>&1)
	    if [ "$out" != "" ]
	    then
		if echo $out | grep "write-protected" >/dev/null
		then
		    error "$MEDIUM is write-protected"
		else
		    error $out
		fi
	    fi
	fi
    fi
}

az_umount()
{
    if [ "$SKIPMOUNT" = no ]
    then
	# Maybe umount removable medium
	if [ "$WAS_MOUNTED" = 0 ]
	then
	    echo "UnMounting $MEDIUM"
	    umount $MEDIUM
	fi
    fi
}

az_exit()
{
    az_umount
    exithook
}

#
# Init code
#
trap az_exit EXIT || error "error setting EXIT trap"
az_init $*
