package xslp.xml.parsers;

import java.io.*;
import java.util.*;
import com.sun.xml.tree.*;
import com.sun.xml.parser.*;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.SAXException;
import org.w3c.dom.Document;


/**
 * A DOMPackage Wrapper for Sun's Project X XML parser
 * @author Olivier Brand 
 * @author <A HREF="mailto:casa@sdv.fr">Michel Casabianca</A>
**/
public class ProjectXParser 
    implements com.kvisco.xml.parser.DOMPackage, 
    org.xml.sax.ErrorHandler 
{
    
    private boolean            validate=false;
    private PrintWriter        errorWriter= null;
    private Parser             parser=null;
    private XmlDocumentBuilder builder=null;

    /**
     * Constructor: initialize parser
     *
     */
    public ProjectXParser() {
	initParser();
    }

    /**
     * Parser initialization
     *
     */
    private void initParser() {
	    // instanciate parser (validating or not)
	    parser=(validate ? new ValidatingParser(): new Parser());
	    // sets the EntityResolver for the parser
	    SimpleCatalog catalog=new 
	        SimpleCatalog(System.getProperty("xml.catalog"));
	    parser.setEntityResolver(catalog);
	    // set the error handler (doesn't work with Sun xml TR1)
	    parser.setErrorHandler(this);
	    // set Locale for parser
	    String[] locales=new String[2];
	    locales[0]=System.getProperty("user.language");
	    locales[1]="en";
	    try {
	        Locale locale=parser.chooseLocale(locales);
	        parser.setLocale(locale);
	    } catch(Exception e) {}
	    // instanciate document builder
	    builder=new XmlDocumentBuilder();
	    builder.setParser(parser);
    } //-- initParser

    /**
     * Sets the DocumentType for the given Document.
     * @param document an instanceof com.sun.xml.tree.XmlDocument
     * @param systemId the System ID for the DOCTYPE Declaration
     **/
    public void setDocumentType(Document document, String systemId) {
	    ((XmlDocument)document).setSystemId(systemId);	
    } //-- setDocumentType

    /**
     * Turns the validation on/off for this DOMPackage
     * @param validate the boolean to determine whether or not to
     * validate Documents
     **/
    public void setValidation(boolean validate) {
	    if(this.validate==validate) return;
            this.validate = validate;
	    initParser();
    } //-- setValidation

    /**
     * Creates a new XML Document for use with the Project X parser
     * @return the new XML Document
     **/
    public Document createDocument() {
        return new XmlDocument();
    } //-- createDocument

    /**
     * Reads an XML Document from the given Reader
     * @param reader the Reader for reading the XML Document stream.
     * @param filename the filename used when reporting errors.
     * @param errorWriter the PrintWriter used to print error messages to.
     * @return the XML Document
     **/
    public Document readDocument
	    (Reader reader, String filename, PrintWriter errorWriter) 
    {
	    this.errorWriter=errorWriter;
        Document document = null;

	    // parse document
            try {
	        InputSource source=Resolver.createInputSource(new File(filename));
	        parser.parse(source);
    	        document=builder.getDocument();
            }    
	    // discard exceptions
            catch(Exception e) {}
            finally {return document;}
    } //-- readDocument

    /**
     * Handle Warnings
     *
     * @param exception exception thrown by the SAX parser
     * @exception exception to throw to stop parsing
     */
    public void warning(SAXParseException e) throws SAXException {
        errorWriter.println(message("warning",e));
	    errorWriter.flush();
    } //-- warning

    /**
     * Handle Errors
     *
     * @param exception exception thrown by the SAX parser
     * @exception exception to throw to stop parsing
     */
    public void error(SAXParseException e) throws SAXException {
        errorWriter.println(message("error",e));
	    errorWriter.flush();
    } //-- error

    /**
     * Handle Fatal Errors
     *
     * @param exception exception thrown by the SAX parser
     * @exception exception to throw to stop parsing
     */
    public void fatalError(SAXParseException e) throws SAXException {
        errorWriter.println(message("fatal error",e));
	    errorWriter.flush();
    } //-- fatalError

    /**
     * Builds error message
     *
     * @param header header of this message (warning, error, fatal error)
     * @param e SAXParseException thrown by the parser
     * @return the error message
     */
    private String message(String header,SAXParseException e) {
	    String message=header+" reading xml document: "+e.getSystemId()+
	        " ("+e.getLineNumber()+", "+e.getColumnNumber()+")"+
	        " - "+e.getMessage();
	    return message;
    } //-- message
    
} //-- ProjectXParser
