/*
 * Decompiled with CFR 0.152.
 */
package org.openxml.dom;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.openxml.dom.AttlistDecl;
import org.openxml.dom.DOMExceptionImpl;
import org.openxml.dom.DocumentImpl;
import org.openxml.dom.ElementDeclImpl;
import org.openxml.dom.EntityImpl;
import org.openxml.dom.NamedNodeMapImpl;
import org.openxml.dom.NodeImpl;
import org.openxml.dom.NotationImpl;
import org.openxml.dom.ParamEntity;
import org.openxml.dom.ext.DocumentTypeEx;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DocumentTypeImpl
extends DocumentImpl
implements DocumentType,
DocumentTypeEx {
    private NamedNodeMapImpl _entities;
    private NamedNodeMapImpl _notations;
    private String _systemId;
    private String _publicId;
    private boolean _standalone;
    private Hashtable _params;

    public DocumentTypeImpl(String string) {
        super(null);
        this._ownerDocument = this;
        this._standalone = true;
        this._systemId = string;
    }

    public DocumentTypeImpl(Document document, String string, boolean bl, String string2, String string3) {
        super(string);
        this._standalone = bl;
        this._systemId = string2;
        this._publicId = string3;
    }

    protected NodeImpl castNewChild(Node node) throws DOMException {
        if (node == null) {
            throw new DOMExceptionImpl(3, "Child reference is null.");
        }
        if (!(node instanceof NodeImpl)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        if (!(node instanceof EntityImpl || node instanceof ParamEntity || node instanceof Notation || node instanceof ElementDeclImpl || node instanceof AttlistDecl || node instanceof Text || node instanceof Comment || node instanceof ProcessingInstruction)) {
            throw new DOMExceptionImpl(3, "Child is not a compatible type for this node.");
        }
        return (NodeImpl)node;
    }

    public Object clone() {
        DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(this._systemId);
        this.cloneInto(documentTypeImpl, true);
        return documentTypeImpl;
    }

    protected synchronized void cloneInto(NodeImpl nodeImpl, boolean bl) {
        super.cloneInto(nodeImpl, bl);
        ((DocumentTypeImpl)nodeImpl)._standalone = this._standalone;
        ((DocumentTypeImpl)nodeImpl)._systemId = this._systemId;
        ((DocumentTypeImpl)nodeImpl)._publicId = this._publicId;
        if (bl) {
            Node node;
            Enumeration enumeration;
            Hashtable<String, Node> hashtable;
            if (this._entities != null) {
                hashtable = new Hashtable<String, Node>();
                enumeration = this._entities.elements();
                while (enumeration.hasMoreElements()) {
                    node = ((Node)enumeration.nextElement()).cloneNode(bl);
                    hashtable.put(node.getNodeName(), node);
                }
                ((DocumentTypeImpl)nodeImpl)._entities = new NamedNodeMapImpl(nodeImpl, hashtable);
            }
            if (this._notations != null) {
                hashtable = new Hashtable();
                enumeration = this._notations.elements();
                while (enumeration.hasMoreElements()) {
                    node = ((Node)enumeration.nextElement()).cloneNode(bl);
                    hashtable.put(node.getNodeName(), node);
                }
                ((DocumentTypeImpl)nodeImpl)._notations = new NamedNodeMapImpl(nodeImpl, hashtable);
            }
            if (this._params != null) {
                hashtable = new Hashtable();
                enumeration = this._params.elements();
                while (enumeration.hasMoreElements()) {
                    node = ((Node)enumeration.nextElement()).cloneNode(bl);
                    hashtable.put(node.getNodeName(), node);
                }
                ((DocumentTypeImpl)nodeImpl)._params = hashtable;
            }
        } else {
            ((DocumentTypeImpl)nodeImpl)._entities = this._entities;
            ((DocumentTypeImpl)nodeImpl)._notations = this._notations;
            ((DocumentTypeImpl)nodeImpl)._params = this._params;
        }
    }

    public Node cloneNode(boolean bl) {
        DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(this._systemId);
        this.cloneInto(documentTypeImpl, bl);
        return documentTypeImpl;
    }

    public EntityImpl createEntity(String string, String string2) {
        EntityImpl entityImpl = new EntityImpl(this, string, string2);
        return entityImpl;
    }

    public EntityImpl createEntity(String string, String string2, String string3) {
        EntityImpl entityImpl = new EntityImpl((DocumentImpl)this, string, string2, string3);
        return entityImpl;
    }

    public EntityImpl createEntity(String string, String string2, String string3, String string4) {
        EntityImpl entityImpl = new EntityImpl(this, string, string2, string3, string4);
        return entityImpl;
    }

    public Notation createNotation(String string, String string2, String string3) {
        NotationImpl notationImpl = new NotationImpl((DocumentImpl)this, string, string2, string3);
        return notationImpl;
    }

    public ParamEntity createParamEntity(String string, String string2) {
        ParamEntity paramEntity = new ParamEntity(this, string, string2);
        return paramEntity;
    }

    public ParamEntity createParamEntity(String string, String string2, String string3) {
        ParamEntity paramEntity = new ParamEntity((DocumentImpl)this, string, string2, string3);
        return paramEntity;
    }

    public EntityImpl declareEntity(EntityImpl entityImpl) {
        EntityImpl entityImpl2;
        this.isReadOnly();
        if (this._entities == null) {
            this._entities = new NamedNodeMapImpl(this, new Hashtable());
            entityImpl2 = null;
        } else {
            entityImpl2 = (EntityImpl)this._entities.getNamedItem(entityImpl.getNodeName());
        }
        if (entityImpl2 == null) {
            this._entities.setNamedItem(entityImpl);
            return entityImpl;
        }
        return entityImpl2;
    }

    public Notation declareNotation(Notation notation) {
        Notation notation2;
        this.isReadOnly();
        if (this._notations == null) {
            this._notations = new NamedNodeMapImpl(this, new Hashtable());
            notation2 = null;
        } else {
            notation2 = (Notation)this._notations.getNamedItem(notation.getNodeName());
        }
        if (notation2 == null) {
            this._notations.setNamedItem(notation);
            return notation;
        }
        return notation2;
    }

    public ParamEntity declareParamEntity(ParamEntity paramEntity) {
        ParamEntity paramEntity2;
        this.isReadOnly();
        if (this._params == null) {
            this._params = new Hashtable();
            paramEntity2 = null;
        } else {
            paramEntity2 = (ParamEntity)this._params.get(paramEntity.getNodeName());
        }
        if (paramEntity2 == null) {
            this._params.put(paramEntity.getNodeName(), paramEntity);
            return paramEntity;
        }
        return paramEntity2;
    }

    public synchronized boolean equals(Object object) {
        boolean bl;
        if (!super.equals(object)) {
            return false;
        }
        Object object2 = object;
        synchronized (object2) {
            DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)object;
            boolean bl2 = bl = this._standalone == documentTypeImpl._standalone && (this._systemId == null && documentTypeImpl._systemId == null || this._systemId != null && documentTypeImpl._systemId != null && this._systemId.equals(documentTypeImpl._systemId) && (this._publicId == null && documentTypeImpl._publicId == null || this._publicId != null && documentTypeImpl._publicId != null && this._publicId.equals(documentTypeImpl._publicId)));
            if (bl) {
                boolean bl3 = bl = this._entities == null && documentTypeImpl._entities == null || this._entities != null && documentTypeImpl._entities != null && this._entities.equals(documentTypeImpl._entities);
            }
            if (bl) {
                boolean bl4 = bl = this._notations == null && documentTypeImpl._notations == null || this._notations != null && documentTypeImpl._notations != null && this._notations.equals(documentTypeImpl._notations);
            }
            if (bl) {
                bl = this._params == null && documentTypeImpl._params == null || this._params != null && documentTypeImpl._params != null && this._params.equals(documentTypeImpl._params);
            }
        }
        return bl;
    }

    public EntityImpl findEntity(String string) {
        if (this._entities == null) {
            return null;
        }
        return (EntityImpl)this._entities.getNamedItem(string);
    }

    public Notation findNotation(String string) {
        if (this._notations == null) {
            return null;
        }
        return (Notation)this._notations.getNamedItem(string);
    }

    public ParamEntity findParamEntity(String string) {
        if (this._params == null) {
            return null;
        }
        return (ParamEntity)this._params.get(string);
    }

    public Element getDocumentElement() {
        return null;
    }

    public NamedNodeMap getEntities() {
        return this._entities;
    }

    public String getName() {
        return this.getNodeName();
    }

    public short getNodeType() {
        return 10;
    }

    public NamedNodeMap getNotations() {
        return this._notations;
    }

    public Dictionary getParamEntities() {
        return this._params;
    }

    public String getPublicId() {
        return this._publicId;
    }

    public String getSystemId() {
        return this._systemId;
    }

    public String internalAsText() {
        return null;
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public String toString() {
        String string = this.getName();
        if (string.length() > 32) {
            string = String.valueOf(string.substring(0, 32)) + "..";
        }
        string = string.replace('\n', '|');
        return "Doctype { " + string + " }";
    }
}

