/*--------------------------------*-C-*---------------------------------*
 * File:	main.c
 *
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as
 * you don't try to make money out of it and you include an
 * unaltered copy of this message (including the copyright).
 *
 * This module has been heavily modified by R. Nation
 * <nation@rocket.sanders.lockheed.com>
 * No additional restrictions are applied
 *
 * Additional modifications by Garrett D'Amore <garrett@netcom.com>
 * No additional restrictions are applied.
 *
 * Extensive modifications by mj olesen <olesen@me.QueensU.CA>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
/* includes */
#include "main.h"

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include <ctype.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#include "command.h"
#include "debug.h"
#include "mem.h"
#include "graphics.h"
#include "scrollbar.h"
#include "menubar.h"
#include "screen.h"
#include "options.h"

/* Global attributes */
XWindowAttributes attr;
XSetWindowAttributes Attributes;

/* extern functions referenced */
#ifdef DISPLAY_IS_IP
extern char * network_display (const char * display);
#endif

/* extern variables referenced */
extern int my_ruid, my_rgid, my_euid, my_egid;
/* extern variables declared here */
TermWin_t	TermWin;
Display		* Xdisplay;	/* display */

char * rs_color [NRS_COLORS];
Pixel PixColors [NRS_COLORS + NSHADOWCOLORS];

unsigned long Options = (Opt_scrollBar);

const char * display_name = NULL;
      char * rs_name = NULL;	/* client instance (resource name) */

#ifndef NO_BOLDFONT
const char * rs_boldFont = NULL;
#endif
const char * rs_font [NFONTS];
#ifdef KANJI
const char * rs_kfont [NFONTS];
#endif

#ifdef PRINTPIPE
const char * rs_print_pipe = NULL;
#endif

char * rs_cutchars = NULL;

/* local variables */
static Cursor TermWin_cursor;	/* cursor for vt window */
unsigned int colorfgbg;
menuBar_t menuBar;

static XSizeHints szHint = {
   PMinSize | PResizeInc | PBaseSize | PWinGravity,
   0, 0, 80, 24,	/* x, y, width, height */
   1, 1,		/* Min width, height */
   0, 0,		/* Max width, height - unused*/
   1, 1,		/* increments: width, height */
   {1, 1},		/* increments: x, y */
   {0, 0},		/* Aspect ratio - unused */
   0, 0,		/* base size: width, height */
   NorthWestGravity	/* gravity */
};

static char *def_colorName[] = {
   "Black", "White",		/* fg/bg */
   "Black",			/* 0: black		(#000000) */
#ifndef NO_BRIGHTCOLOR
   /* low-intensity colors */
   "Red3",			/* 1: red		(#CD0000) */
   "Green3",			/* 2: green		(#00CD00) */
   "Yellow3",			/* 3: yellow		(#CDCD00) */
   "Blue3",			/* 4: blue		(#0000CD) */
   "Magenta3",			/* 5: magenta		(#CD00CD) */
   "Cyan3",			/* 6: cyan		(#00CDCD) */
   "AntiqueWhite",		/* 7: white		(#FAEBD7) */
   /* high-intensity colors */
   "Grey25",			/* 8: bright black	(#404040) */
#endif	/* NO_BRIGHTCOLOR */
   "Red",			/* 1/9: bright red	(#FF0000) */
   "Green",			/* 2/10: bright green	(#00FF00) */
   "Yellow",			/* 3/11: bright yellow	(#FFFF00) */
   "Blue",			/* 4/12: bright blue	(#0000FF) */
   "Magenta",			/* 5/13: bright magenta	(#FF00FF) */
   "Cyan",			/* 6/14: bright cyan	(#00FFFF) */
   "White",			/* 7/15: bright white	(#FFFFFF) */
#ifndef NO_CURSORCOLOR
   NULL, NULL,			/* cursorColor, cursorColor2 */
#endif	/* NO_CURSORCOLOR */
   NULL, NULL			/* pointerColor, borderColor */
#ifndef NO_BOLDUNDERLINE
   ,NULL, NULL			/* colorBD, colorUL */
#endif	/* NO_BOLDUNDERLINE */
#ifdef KEEP_SCROLLCOLOR
   ,"#B2B2B2"			/* scrollColor: match Netscape color */
#endif
};

#ifdef KANJI
/* Kanji font names, roman fonts sized to match */
static const char * def_kfontName [] = {
   KFONT0, KFONT1, KFONT2, KFONT3, KFONT4
};
#endif	/* KANJI */
static const char * def_fontName [] = {
   FONT0, FONT1, FONT2, FONT3, FONT4
};

/* extern functions referenced */
#ifdef PIXMAP_SUPPORT
/* the originally loaded pixmap and its scaling */
extern Pixmap set_bgPixmap (const char * /* file */);
/* extern struct bgPixmap; */
extern int scale_pixmap (const char * geom);
extern void resize_pixmap (void);
#endif	/* PIXMAP_SUPPORT */

/* have we changed the font? Needed to avoid race conditions
 * while window resizing  */
static int font_change_count = 0;

static void resize (void);

#if 0
  /* not defined in any header file, but this will dump the stack
  ** so you can see where you've been.  Only on HP-UX.
  ** you need to link with  -lcl
  */
extern void U_STACK_TRACE();
#endif

XErrorHandler oldXErrorHandler=NULL;
XErrorHandler
xerror_handler(Display *display, XErrorEvent *event) {

#if 0
  U_STACK_TRACE();  /* dump the stack.. */
#endif
  print_error("XError: Request %d.%d, Error %d", event->request_code,
	      event->minor_code, event->error_code);
  (*oldXErrorHandler)(display, event);
  exit(EXIT_FAILURE);
  return 0;
}

/* color aliases, fg/bg bright-bold */
/*static inline void*/
void
color_aliases (int idx) {

  if (rs_color[idx] && isdigit(*rs_color[idx])) {

    int i = atoi(rs_color[idx]);

    if (i >= 8 && i <= 15) {	/* bright colors */
      i -= 8;
#ifndef NO_BRIGHTCOLOR
      rs_color[idx] = rs_color[minBright + i];
      return;
#endif
    }
    if (i >= 0 && i <= 7)		/* normal colors */
      rs_color[idx] = rs_color[minColor + i];
  }
}

/*
 * find if fg/bg matches any of the normal (low-intensity) colors
 */
#ifndef NO_BRIGHTCOLOR
static inline void
set_colorfgbg (void)
{
   unsigned int i;
   static char *colorfgbg_env = NULL;
   char * p;
   int fg = -1, bg = -1;

   if (!colorfgbg_env) {
     colorfgbg_env = (char *) malloc(30);
     strcpy(colorfgbg_env, "COLORFGBG=default;default;bg");
   }

   for (i = BlackColor; i <= WhiteColor; i++)
     {
	if (PixColors [fgColor] == PixColors [i])
	  {
	     fg = (i - BlackColor);
	     break;
	  }
     }
   for (i = BlackColor; i <= WhiteColor; i++)
     {
	if (PixColors [bgColor] == PixColors [i])
	  {
	     bg = (i - BlackColor);
	     break;
	  }
     }

   p = strchr (colorfgbg_env, '=');
   p++;
   if (fg >= 0)
     sprintf (p, "%d;", fg);
   else
     strcpy (p, "default;");
   p = strchr (p, '\0');
   if (bg >= 0)
     sprintf (p,
# ifdef PIXMAP_SUPPORT
	      "default;"
# endif
	      "%d", bg);
   else
     strcpy (p, "default");
   putenv (colorfgbg_env);

   colorfgbg = DEFAULT_RSTYLE;
   for (i = minColor; i <= maxColor; i++)
     {
	if (PixColors [fgColor] == PixColors [i]
# ifndef NO_BOLDUNDERLINE
	    && PixColors [fgColor] == PixColors [colorBD]
# endif	/* NO_BOLDUNDERLINE */
	    /* if we wanted boldFont to have precedence */
# if 0	/* ifndef NO_BOLDFONT */
	    && TermWin.boldFont == NULL
# endif	/* NO_BOLDFONT */
	    )
	  colorfgbg = SET_FGCOLOR (colorfgbg, i);
	if (PixColors [bgColor] == PixColors [i])
	  colorfgbg = SET_BGCOLOR (colorfgbg, i);
     }
}
#else	/* NO_BRIGHTCOLOR */
# define set_colorfgbg() ((void)0)
#endif /* NO_BRIGHTCOLOR */

/* Create_Windows() - Open and map the window */
static void
Create_Windows (int argc, char * argv []) {

  Cursor cursor;
  XClassHint classHint;
  XWMHints wmHint;
  int i, x, y, flags;
  unsigned int width, height;
  char *tmp;

  if (Options & Opt_borderless) {
    Attributes.override_redirect = TRUE;
  }

   /*
    * grab colors before netscape does
    */
  for (i = 0; i < (Xdepth <= 2 ? 2 : NRS_COLORS); i++) {

    const char * const msg = "can't load color \"%s\"";
    XColor xcol;

    if (!rs_color [i]) continue;

    if (!XParseColor (Xdisplay, Xcmap, rs_color [i], &xcol) ||
	!XAllocColor (Xdisplay, Xcmap, &xcol)) {

      print_error (msg, rs_color [i]);
      rs_color[i] = def_colorName[i];
      if (!rs_color [i]) continue;
      if (!XParseColor (Xdisplay, Xcmap, rs_color [i], &xcol) ||
	  !XAllocColor (Xdisplay, Xcmap, &xcol)) {

	print_error (msg, rs_color [i]);
	switch (i) {
	case fgColor:
	case bgColor:
	  /* fatal: need bg/fg color */
	  print_error ("aborting");
	  exit (EXIT_FAILURE);
	  break;
#ifndef NO_CURSORCOLOR
	case cursorColor:
	  xcol.pixel = PixColors [bgColor];
	  break;
	case cursorColor2:
	  xcol.pixel = PixColors [fgColor];
	  break;
#endif	/* NO_CURSORCOLOR */
	default:
	  xcol.pixel = PixColors [bgColor];	/* None */
	  break;
	}
      }
    }
    PixColors [i] = xcol.pixel;
  }

#ifndef NO_CURSORCOLOR
  if (Xdepth <= 2 || !rs_color[cursorColor])
    PixColors[cursorColor] = PixColors[bgColor];
  if (Xdepth <= 2 || !rs_color[cursorColor2])
    PixColors[cursorColor2] = PixColors[fgColor];
#endif				/* NO_CURSORCOLOR */
  if (Xdepth <= 2 || !rs_color[pointerColor])
    PixColors[pointerColor] = PixColors[fgColor];
  if (Xdepth <= 2 || !rs_color[borderColor])
    PixColors[borderColor] = PixColors[bgColor];

#ifndef NO_BOLDUNDERLINE
  if (Xdepth <= 2 || !rs_color [colorBD])
    PixColors [colorBD] = PixColors [fgColor];
  if (Xdepth <= 2 || !rs_color [colorUL])
    PixColors [colorUL] = PixColors [fgColor];
#endif	/* NO_BOLDUNDERLINE */

   /*
    * get scrollBar/menuBar shadow colors
    *
    * The calculations of topShadow/bottomShadow values are adapted
    * from the fvwm window manager.
    */
#ifdef KEEP_SCROLLCOLOR
  if (Xdepth <= 2) {   /* Monochrome */
    PixColors[scrollColor] = PixColors[bgColor];
    PixColors[topShadowColor] = PixColors[fgColor];
    PixColors[bottomShadowColor] = PixColors[fgColor];
  } else {

    XColor xcol, white;

    /* bottomShadowColor */
    xcol.pixel = PixColors [scrollColor];
    XQueryColor (Xdisplay, Xcmap, &xcol);

    xcol.red   = ((xcol.red)   / 2);
    xcol.green = ((xcol.green) / 2);
    xcol.blue  = ((xcol.blue)  / 2);

    if (!XAllocColor (Xdisplay, Xcmap, &xcol)) {
      print_error ("can't allocate %s", "bottomShadowColor");
      xcol.pixel = PixColors [minColor];
    }
    PixColors [bottomShadowColor] = xcol.pixel;

    /* topShadowColor */
#ifdef PREFER_24BIT
    white.red = white.green = white.blue = ~0;
    XAllocColor(Xdisplay, Xcmap, &white);
/*        XFreeColors(Xdisplay, Xcmap, &white.pixel, 1, ~0);*/
#else        
    white.pixel = WhitePixel(Xdisplay, Xscreen);
    XQueryColor(Xdisplay, Xcmap, &white);
#endif

    xcol.pixel = PixColors[scrollColor];
    XQueryColor(Xdisplay, Xcmap, &xcol);

# ifndef min
#  define min(a,b) (((a)<(b)) ? (a) : (b))
#  define max(a,b) (((a)>(b)) ? (a) : (b))
# endif
    xcol.red   = max ((white.red   / 5), xcol.red);
    xcol.green = max ((white.green / 5), xcol.green);
    xcol.blue  = max ((white.blue  / 5), xcol.blue);

    xcol.red   = min (white.red,   (xcol.red   * 7) / 5);
    xcol.green = min (white.green, (xcol.green * 7) / 5);
    xcol.blue  = min (white.blue,  (xcol.blue  * 7) / 5);

    if (!XAllocColor (Xdisplay, Xcmap, &xcol)) {
      print_error ("can't allocate %s", "topShadowColor");
      xcol.pixel = PixColors [WhiteColor];
    }
    PixColors [topShadowColor] = xcol.pixel;
  }
#endif	/* KEEP_SCROLLCOLOR */

  szHint.base_width = (2 * TermWin.internalBorder +
		       (Options & Opt_scrollBar ? (SB_WIDTH + 2 * sb_shadow) : 0));
  szHint.base_height = (2 * TermWin.internalBorder);

  flags = (rs_geometry ?
	   XParseGeometry (rs_geometry, &x, &y, &width, &height) : 0);

  if (flags & WidthValue) {
    szHint.width = width;
    szHint.flags |= USSize;
  }
  if (flags & HeightValue) {
    szHint.height = height;
    szHint.flags |= USSize;
  }

  TermWin.ncol = szHint.width;
  TermWin.nrow = szHint.height;

  change_font(1, NULL);
#if (MENUBAR_MAX)
  szHint.base_height += (delay_menu_drawing ? menuBar_TotalHeight() : 0);
#endif

  if (flags & XValue) {
    if (flags & XNegative) {
      x += (DisplayWidth (Xdisplay, Xscreen) - (szHint.width + TermWin.internalBorder));
      szHint.win_gravity = NorthEastGravity;
    }
    szHint.x = x;
    szHint.flags |= USPosition;
  }
  if (flags & YValue) {
    if (flags & YNegative) {
      y += (DisplayHeight (Xdisplay, Xscreen) - (szHint.height + TermWin.internalBorder));
      szHint.win_gravity = (szHint.win_gravity == NorthEastGravity ?
			    SouthEastGravity : SouthWestGravity);
    }
    szHint.y = y;
    szHint.flags |= USPosition;
  }

  /* parent window - reverse video so we can see placement errors
   * sub-window placement & size in resize_subwindows()
   */

  if (Options & Opt_borderless) {
#ifdef PREFER_24BIT
    Attributes.background_pixel = PixColors[fgColor];
    Attributes.border_pixel = PixColors[bgColor];
    Attributes.colormap = Xcmap;
    TermWin.parent = XCreateWindow(Xdisplay, Xroot,
				   szHint.x, szHint.y,
				   szHint.width, szHint.height,
#if 0
 				   TermWin.internalBorder,
#endif
                   0,
				   Xdepth, InputOutput,
				   Xvisual,
				   CWBackPixel | CWBorderPixel | CWColormap | CWOverrideRedirect,
				   &Attributes);
#else
    TermWin.parent = XCreateWindow (Xdisplay, Xroot,
				    szHint.x, szHint.y,
				    szHint.width, szHint.height,
#if 0
				    TermWin.internalBorder,
#endif
                    0,
				    Xdepth,
				    InputOutput,
				    CopyFromParent,
				    CWOverrideRedirect,
				    &Attributes);
#endif
  } else {
#ifdef PREFER_24BIT
    Attributes.background_pixel = PixColors[fgColor];
    Attributes.border_pixel = PixColors[bgColor];
    Attributes.colormap = Xcmap;
    TermWin.parent = XCreateWindow(Xdisplay, Xroot,
				   szHint.x, szHint.y,
				   szHint.width, szHint.height,
				   TermWin.internalBorder,
				   Xdepth, InputOutput,
				   Xvisual,
				   CWBackPixel | CWBorderPixel | CWColormap,
				   &Attributes);
#else
    TermWin.parent = XCreateSimpleWindow (Xdisplay, Xroot,
					  szHint.x, szHint.y,
					  szHint.width, szHint.height,
					  TermWin.internalBorder,
					  PixColors[bgColor],
					  PixColors[fgColor]);
#endif
  }

  xterm_seq (XTerm_title, rs_title);
  xterm_seq (XTerm_iconName, rs_iconName);
  classHint.res_name  = (char *) rs_name;
  classHint.res_class = APL_NAME;
  wmHint.window_group = TermWin.parent;
  wmHint.input = True;
  wmHint.initial_state = (Options & Opt_iconic ? IconicState : NormalState);
  wmHint.window_group = TermWin.parent;
#ifdef OVERRIDE_REDIRECT
  wmHint.flags = (InputHint | StateHint | WindowGroupHint);
#else
  wmHint.flags = (InputHint | StateHint | WindowGroupHint);
#endif

  XSetWMProperties (Xdisplay, TermWin.parent, NULL, NULL, argv, argc,
		    &szHint, &wmHint, &classHint);
  
  XSelectInput(Xdisplay, TermWin.parent, (KeyPressMask | FocusChangeMask | StructureNotifyMask | VisibilityChangeMask));
  
  /* vt cursor: Black-on-White is standard, but this is more popular */
  TermWin_cursor = XCreateFontCursor (Xdisplay, XC_xterm);
  {
    XColor fg, bg;
    fg.pixel = PixColors[pointerColor];
    XQueryColor(Xdisplay, Xcmap, &fg);
    bg.pixel = PixColors[bgColor];
    XQueryColor(Xdisplay, Xcmap, &bg);
    XRecolorCursor(Xdisplay, TermWin_cursor, &fg, &bg);
  }

  /* cursor (menuBar/scrollBar): Black-on-White */
  cursor = XCreateFontCursor (Xdisplay, XC_left_ptr);

  /* the vt window */
  if (Options & Opt_borderless) {
    TermWin.vt = XCreateWindow(Xdisplay, TermWin.parent,
			       0, 0,
			       szHint.width, szHint.height,
			       0,
			       Xdepth,
			       InputOutput,
			       CopyFromParent,
			       CWOverrideRedirect,
			       &Attributes);
  } else {
    TermWin.vt = XCreateSimpleWindow(Xdisplay, TermWin.parent,
				     0, 0,
				     szHint.width, szHint.height,
				     0,
				     PixColors[fgColor],
				     PixColors[bgColor]);
  }

  XDefineCursor(Xdisplay, TermWin.vt, TermWin_cursor);
  XSelectInput(Xdisplay, TermWin.vt,
	       (ExposureMask | ButtonPressMask | ButtonReleaseMask |
		Button1MotionMask | Button3MotionMask));

  XMapWindow(Xdisplay, TermWin.vt);
  XMapWindow(Xdisplay, TermWin.parent);

   /* scrollBar: size doesn't matter */
  if (Options & Opt_borderless) {
# ifdef KEEP_SCROLLCOLOR
    Attributes.background_pixel = PixColors[scrollColor];
# else
    Attributes.background_pixel = PixColors[fgColor];
# endif
    Attributes.border_pixel = PixColors[bgColor];
    scrollBar.win = XCreateWindow(Xdisplay, TermWin.parent,
				  0, 0,
				  1, 1,
				  0,
				  Xdepth,
				  InputOutput,
				  CopyFromParent,
				  CWOverrideRedirect,
				  &Attributes);
  } else {
    scrollBar.win = XCreateSimpleWindow(Xdisplay, TermWin.parent,
					0, 0,
					1, 1,
					0,
					PixColors[fgColor],
					PixColors[bgColor]);
  }

  XDefineCursor(Xdisplay, scrollBar.win, cursor);
  XSelectInput(Xdisplay, scrollBar.win,
	       (ExposureMask|ButtonPressMask|ButtonReleaseMask|
		Button1MotionMask|Button2MotionMask|Button3MotionMask)
	       );

#if (MENUBAR_MAX)
   /* menuBar: size doesn't matter */
  if (Options & Opt_borderless) {
# ifdef KEEP_SCROLLCOLOR
    Attributes.background_pixel = PixColors[scrollColor];
# else
    Attributes.background_pixel = PixColors[fgColor];
# endif
    Attributes.border_pixel = PixColors[bgColor];
    menuBar.win = XCreateWindow(Xdisplay, TermWin.parent,
				0, 0,
				1, 1,
				0,
				Xdepth,
				InputOutput,
				CopyFromParent,
				CWOverrideRedirect,
				&Attributes);
  } else {
    menuBar.win = XCreateSimpleWindow (Xdisplay, TermWin.parent,
				       0, 0,
				       1, 1,
				       0,
				       PixColors[fgColor],
# ifdef KEEP_SCROLLCOLOR
				       PixColors[scrollColor]
# else
				       PixColors[fgColor]
# endif
				       );
  }

  XDefineCursor (Xdisplay, menuBar.win, cursor);
  XSelectInput (Xdisplay, menuBar.win,
		(ExposureMask|ButtonPressMask|ButtonReleaseMask|
		 Button1MotionMask)
		);
#endif	/* MENUBAR_MAX */

#ifdef PIXMAP_SUPPORT
  if (rs_pixmaps[pixmap_bg] != NULL) {

    char *p = rs_pixmaps[pixmap_bg];

    if ((p = strchr (p, '@')) != NULL) {
      p++;
      scale_pixmap(p);
    }

    set_bgPixmap(rs_pixmaps[pixmap_bg]);
  }
#endif	/* PIXMAP_SUPPORT */

   /* graphics context for the vt window */
  {
    XGCValues gcvalue;
    gcvalue.font = TermWin.font->fid;
    gcvalue.foreground = PixColors [fgColor];
    gcvalue.background = PixColors [bgColor];
    gcvalue.graphics_exposures = 0;
    TermWin.gc = XCreateGC (Xdisplay, TermWin.vt,
			    GCForeground | GCBackground | GCFont | GCGraphicsExposures,
			    &gcvalue);
  }
}
/* window resizing - assuming the parent window is the correct size */
static void
resize_subwindows (int width, int height)
{
   int x = 0, y = 0;
   int old_width  = TermWin.width;
   int old_height = TermWin.height;

#ifdef DEBUG_SCREEN
   fprintf(stderr, "[debug] resize_subwindows(%d, %d)\n", width, height);
#endif
   TermWin.width  = TermWin.ncol * TermWin.fwidth;
   TermWin.height = TermWin.nrow * TermWin.fheight;

   /* size and placement */
   if (scrollbar_visible ())
     {
	scrollBar.beg = 0;
	scrollBar.end = height;
#ifndef XTERM_SCROLLBAR
	/* arrows are as high as wide - leave 1 pixel gap */
	scrollBar.beg += (SB_WIDTH + 1) + sb_shadow;
	scrollBar.end -= (SB_WIDTH + 1) + sb_shadow;
#endif
	width -= (SB_WIDTH + 2 * sb_shadow);
	XMoveResizeWindow (Xdisplay, scrollBar.win,
			   ((Options & Opt_scrollBar_right) ? (width) : (x)), 0,
			   (SB_WIDTH + 2 * sb_shadow), height);

	if (!(Options & Opt_scrollBar_right)) {
	  x = (SB_WIDTH + 2 * sb_shadow);/* placement of vt window */
	}
     }

#if (MENUBAR_MAX)
   if (menubar_visible()) {
     y = menuBar_TotalHeight();	/* for placement of vt window */
     XMoveResizeWindow (Xdisplay, menuBar.win, x, 0, width, y);
   }
#endif	/* NO_MENUBAR */

   XMoveResizeWindow (Xdisplay, TermWin.vt,
		      x, y,
		      width, height + 1);

   if (old_width) Gr_Resize (old_width, old_height);
   XClearWindow (Xdisplay, TermWin.vt);
#ifdef PIXMAP_SUPPORT
   resize_pixmap();
#endif
   XSync (Xdisplay, 0);
}

static void
resize (void)
{
  szHint.base_width  = (2 * TermWin.internalBorder);
  szHint.base_height = (2 * TermWin.internalBorder);

   szHint.base_width += (scrollbar_visible() ? (SB_WIDTH + 2 * sb_shadow) : 0);
#if (MENUBAR_MAX)
   szHint.base_height += (menubar_visible() ? menuBar_TotalHeight() : 0);
#endif

   szHint.min_width  = szHint.base_width  + szHint.width_inc;
   szHint.min_height = szHint.base_height + szHint.height_inc;

   szHint.width  = szHint.base_width  + TermWin.width;
   szHint.height = szHint.base_height + TermWin.height;

   szHint.flags = PMinSize|PResizeInc|PBaseSize|PWinGravity;

   XSetWMNormalHints (Xdisplay, TermWin.parent, &szHint);
   XResizeWindow (Xdisplay, TermWin.parent, szHint.width, szHint.height);

   resize_subwindows (szHint.width, szHint.height);
}

#if (MENUBAR_MAX)
void
map_menuBar (int map) {

  if (delay_menu_drawing) {
    delay_menu_drawing++;
  } else if (menubar_mapping(map)) {
    resize();
  }
}
#endif	/* MENUBAR_MAX */

void
map_scrollBar (int map)
{
   if (scrollbar_mapping (map))
     {
	scr_touch ();
	resize ();
     }
}

/*
 * Redraw window after exposure or size change
 */
static void
resize_window1 (unsigned int width, unsigned int height)
{
   static short first_time = 1;
   int new_ncol = (width  - szHint.base_width)  / TermWin.fwidth;
   int new_nrow = (height - szHint.base_height) / TermWin.fheight;

   if (first_time ||
       (new_ncol != TermWin.ncol) ||
       (new_nrow != TermWin.nrow))
     {
	int curr_screen = -1;

	/* scr_reset only works on the primary screen */
	if (!first_time)	/* this is not the first time thru */
	  {
	     selection_clear ();
	     curr_screen = scr_change_screen (PRIMARY);
	  }

	TermWin.ncol = new_ncol;
	TermWin.nrow = new_nrow;

	resize_subwindows (width, height);
	scr_reset ();

	if (curr_screen >= 0)	/* this is not the first time thru */
	  scr_change_screen (curr_screen);
	first_time = 0;
     }
}

/*
 * good for toggling 80/132 columns
 */
void
set_width (unsigned short width)
{
   unsigned short height = TermWin.nrow;

   if (width != TermWin.ncol)
     {
	width  = szHint.base_width  + width  * TermWin.fwidth;
	height = szHint.base_height + height * TermWin.fheight;

	XResizeWindow (Xdisplay, TermWin.parent, width, height);
	resize_window1 (width, height);
     }
}

/*
 * Redraw window after exposure or size change
 */
void
resize_window (void)
{
   Window root;
   XEvent dummy;
   int x, y;
   unsigned int border, depth, width, height;

   while (XCheckTypedWindowEvent (Xdisplay, TermWin.parent,
				  ConfigureNotify, &dummy));

   /* do we come from an fontchange? */
   if (font_change_count > 0) {
     font_change_count--;
     return;
   }

   XGetGeometry (Xdisplay, TermWin.parent,
		 &root, &x, &y, &width, &height, &border, &depth);
#if 0
   XGetGeometry (Xdisplay, TermWin.vt,
		 &root, &x, &y, &width, &height, &border, &depth);
#endif

   /* parent already resized */

   resize_window1 (width, height);
}

/* xterm sequences - title, iconName, color (exptl) */
#ifdef SMART_WINDOW_TITLE
static void
set_title (const char * str)
{
   char * name;
   if (XFetchName (Xdisplay, TermWin.parent, &name)) name = NULL;
   if (name == NULL || strcmp (name, str))
     XStoreName (Xdisplay, TermWin.parent, str);
   if (name) XFree (name);
}
#else
# define set_title(str) XStoreName (Xdisplay, TermWin.parent, str)
#endif

#ifdef SMART_WINDOW_TITLE
static void
set_iconName (const char * str)
{
   char * name;
   if (XGetIconName (Xdisplay, TermWin.parent, &name)) name = NULL;
   if (name == NULL || strcmp (name, str))
     XSetIconName (Xdisplay, TermWin.parent, str);
   if (name) XFree (name);
}
#else
# define set_iconName(str) XSetIconName (Xdisplay, TermWin.parent, str)
#endif

#ifdef XTERM_COLOR_CHANGE
static void
set_window_color (int idx, const char * color)
{
   const char * const msg = "can't load color \"%s\"";
   XColor xcol;
   int i;

   if (color == NULL || *color == '\0') return;

   /* handle color aliases */
   if (isdigit (*color))
     {
	i = atoi (color);
	if (i >= 8 && i <= 15)	/* bright colors */
	  {
	     i -= 8;
# ifndef NO_BRIGHTCOLOR
	     PixColors [idx] = PixColors [minBright + i];
	     goto Done;
# endif
	  }
	if (i >= 0 && i <= 7)	/* normal colors */
	  {
	     PixColors [idx] = PixColors [minColor + i];
	     goto Done;
	  }
     }

   if (!XParseColor (Xdisplay, Xcmap, color, &xcol) ||
       !XAllocColor (Xdisplay, Xcmap, &xcol))
     {
	print_error (msg, color);
	return;
     }

   /* XStoreColor (Xdisplay, Xcmap, XColor*); */

   /*
    * FIXME: should free colors here, but no idea how to do it so instead,
    * so just keep gobbling up the colormap
    */
#if 0
   for (i = BlackColor; i <= WhiteColor; i++)
     if (PixColors [idx] == PixColors [i])
       break;
   if (i > WhiteColor)
     {
	/* fprintf (stderr, "XFreeColors: PixColors [%d] = %lu\n", idx, PixColors [idx]); */
	XFreeColors (Xdisplay, Xcmap, (PixColors + idx), 1,
		     DisplayPlanes(Xdisplay, Xscreen));
     }
#endif

   PixColors [idx] = xcol.pixel;

   /* XSetWindowAttributes attr; */
   /* Cursor cursor; */
   Done:
   if (idx == bgColor)
     XSetWindowBackground (Xdisplay, TermWin.vt, PixColors [bgColor]);

   /* handle colorBD, scrollbar background, etc. */

   set_colorfgbg ();
     {
	XColor fg, bg;
	fg.pixel = PixColors [fgColor]; XQueryColor (Xdisplay, Xcmap, &fg);
	bg.pixel = PixColors [bgColor]; XQueryColor (Xdisplay, Xcmap, &bg);
	XRecolorCursor (Xdisplay, TermWin_cursor, &fg, &bg);
     }
   /* the only reasonable way to enforce a clean update */
   scr_poweron ();
}
#else
# define set_window_color(idx,color) ((void)0)
#endif	/* XTERM_COLOR_CHANGE */

/*
 * XTerm escape sequences: ESC ] Ps;Pt BEL
 *	 0 = change iconName/title
 *	 1 = change iconName
 *	 2 = change title
 *	46 = change logfile (not implemented)
 *	50 = change font
 *
 * rxvt extensions:
 *	10 = menu
 *	20 = bg pixmap
 *	39 = change default fg color
 *	49 = change default bg color
 */
void
xterm_seq (int op, const char *str) {

#ifdef PIXMAP_SUPPORT
   int changed = 0;
   char *nstr = strdup(str);
#endif

   assert (str != NULL);
   switch (op) {
    case XTerm_name:		set_title (str);	/* drop */
    case XTerm_iconName:	set_iconName (str);	break;
    case XTerm_title:		set_title (str);	break;
    case XTerm_Menu:
      /* This function cannot be called with a const char * */
      /* menubar_dispatch (str); */
      break;
    case XTerm_Pixmap:
#ifdef PIXMAP_SUPPORT

      /* FIXME: Should the ';' be changed to '@'? -vendu */
      /* I don't think so.  The ';' comes from the XTerm
         escape sequence convention. -- mej */
      nstr = strtok(nstr, ";");
      if (nstr) {
	if (*nstr) {
	  scale_pixmap("");
	  set_bgPixmap (nstr);
	}

	while ((nstr = strtok(NULL, ";")) != NULL) {
	  changed += scale_pixmap(nstr);
	}
	if (changed) {
	  resize_pixmap();
	  scr_touch();
	}
      } else {
	set_bgPixmap("");
      }
#endif	/* PIXMAP_SUPPORT */
      break;

    case XTerm_restoreFG:	set_window_color (fgColor, str);	break;
    case XTerm_restoreBG:	set_window_color (bgColor, str);	break;
    case XTerm_logfile:		break;
    case XTerm_font:		change_font (0, str);	break;
   }
}

/* change_font() - Switch to a new font */
/*
 * init = 1	- initialize
 *
 * fontname == FONT_UP	- switch to bigger font
 * fontname == FONT_DN	- switch to smaller font
 */
#define ABORT() do { print_error("aborting"); exit(EXIT_FAILURE); } while (0)
void
change_font (int init, const char * fontname)
{
   const char * const msg = "can't load font \"%s\"";
   XFontStruct * xfont;
   static char * newfont [NFONTS];
#ifndef NO_BOLDFONT
   static XFontStruct * boldFont = NULL;
#endif
   static int fnum = FONT0_IDX;		/* logical font number */
   int idx = 0;				/* index into rs_font[] */

#if (FONT0_IDX == 0)
# define IDX2FNUM(i) (i)
# define FNUM2IDX(f) (f)
#else
# define IDX2FNUM(i) (i == 0? FONT0_IDX : (i <= FONT0_IDX? (i-1) : i))
# define FNUM2IDX(f) (f == FONT0_IDX ? 0 : (f < FONT0_IDX ? (f+1) : f))
#endif
#define FNUM_RANGE(i)	(i <= 0 ? 0 : (i >= NFONTS ? (NFONTS-1) : i))

   if (!init)
     {
	switch (fontname [0]) {
	 case '\0':
	   fnum = FONT0_IDX;
	   fontname = NULL;
	   break;

	   /* special (internal) prefix for font commands */
	 case FONT_CMD:
	   idx = atoi (fontname+1);
	   switch (fontname [1]) {
	    case '+':		/* corresponds to FONT_UP */
	      fnum += (idx ? idx : 1);
	      fnum = FNUM_RANGE (fnum);
	      break;

	    case '-':		/* corresponds to FONT_DN */
	      fnum += (idx ? idx : -1);
	      fnum = FNUM_RANGE (fnum);
	      break;

	    default:
	      if (fontname [1] != '\0' && !isdigit (fontname [1]))
		return;
	      if (idx < 0 || idx >= (NFONTS))
		return;
	      fnum = IDX2FNUM (idx);
	      break;
	   }
	   fontname = NULL;
	   break;

	 default:
	   if (fontname != NULL)
	     {
		/* search for existing fontname */
		for (idx = 0; idx < NFONTS; idx++)
		  {
		     if (!strcmp (rs_font [idx], fontname))
		       {
			  fnum = IDX2FNUM (idx);
			  fontname = NULL;
			  break;
		       }
		  }
	     }
	   else
	     return;
	   break;
	}
	/* re-position around the normal font */
	idx = FNUM2IDX (fnum);

	if (fontname != NULL)
	  {
	     char * name;
	     xfont = XLoadQueryFont (Xdisplay, fontname);
	     if (!xfont)
	       return;

	     name = MALLOC (strlen(fontname+1)*sizeof(char));

	     if (name == NULL)
	       {
		  XFreeFont (Xdisplay, xfont);
		  return;
	       }

	     strcpy (name, fontname);
	     if (newfont [idx] != NULL)
	       FREE (newfont[idx]);
	     newfont [idx] = name;
	     rs_font [idx] = newfont [idx];
	  }
     }

   if (TermWin.font)
     XFreeFont (Xdisplay, TermWin.font);

   /* load font or substitute */
   xfont = XLoadQueryFont (Xdisplay, rs_font [idx]);
   if (!xfont)
     {
	print_error (msg, rs_font [idx]);
	rs_font [idx] = "fixed";
	xfont = XLoadQueryFont (Xdisplay, rs_font [idx]);
	if (!xfont)
	  {
	     print_error (msg, rs_font [idx]);
	     ABORT();
	  }
     }
   TermWin.font = xfont;

#ifndef NO_BOLDFONT
   /* fail silently */
   if (init && rs_boldFont != NULL)
     boldFont = XLoadQueryFont (Xdisplay, rs_boldFont);
#endif

#ifdef KANJI
   if (TermWin.kanji)
     XFreeFont (Xdisplay, TermWin.kanji);

   /* load font or substitute */
   xfont = XLoadQueryFont (Xdisplay, rs_kfont [idx]);
   if (!xfont)
     {
	print_error (msg, rs_kfont [idx]);
	rs_kfont [idx] = "k14";
	xfont = XLoadQueryFont (Xdisplay, rs_kfont [idx]);
	if (!xfont)
	  {
	     print_error (msg, rs_kfont [idx]);
	     ABORT();
	  }
     }
   TermWin.kanji = xfont;
#endif	/* KANJI */

   /* alter existing GC */
   if (!init)
     {
	XSetFont (Xdisplay, TermWin.gc, TermWin.font->fid);
#if (MENUBAR_MAX)
	menubar_expose();
#endif	/* MENUBAR_MAX */
     }

   /* set the sizes */
     {

       int		i, cw, fh, fw = 0;
       
       fw = TermWin.font->min_bounds.width;
       fh = TermWin.font->ascent + TermWin.font->descent;
       
       if (TermWin.font->min_bounds.width == TermWin.font->max_bounds.width)
	 TermWin.fprop = 0;	/* Mono-spaced (fixed width) font */
       else
	 TermWin.fprop = 1;	/* Proportional font */
       if (TermWin.fprop == 1)
	 for (i = TermWin.font->min_char_or_byte2;
	      i <= TermWin.font->max_char_or_byte2; i++) {
	   cw = TermWin.font->per_char[i].width;
	   MAX_IT(fw, cw);
	 }
       
       /* not the first time thru and sizes haven't changed */
       if (fw == TermWin.fwidth && fh == TermWin.fheight)
	 return; /* TODO: not return; check KANJI if needed */
       
       TermWin.fwidth  = fw;
       TermWin.fheight = fh;
     }

   /* check that size of boldFont is okay */
#ifndef NO_BOLDFONT
   TermWin.boldFont = NULL;
   if (boldFont != NULL) {
     int		i, cw, fh, fw = 0;
     
     fw = boldFont->min_bounds.width;
     fh = boldFont->ascent + boldFont->descent;
     if (TermWin.fprop == 0) {	/* bold font must also be monospaced */
       if (fw != boldFont->max_bounds.width)
	 fw = -1;
     } else
       for (i = 0; i < 256; i++) {
	 if (!isprint(i))
	   continue;
	 cw = boldFont->per_char[i].width;
	 MAX_IT(fw, cw);
       }
     if (fw == TermWin.fwidth && fh == TermWin.fheight)
       TermWin.boldFont = boldFont;
   }
#endif	/* NO_BOLDFONT */

   set_colorfgbg ();

   TermWin.width  = TermWin.ncol * TermWin.fwidth;
   TermWin.height = TermWin.nrow * TermWin.fheight;

   szHint.width_inc  = TermWin.fwidth;
   szHint.height_inc = TermWin.fheight;

   szHint.min_width  = szHint.base_width  + szHint.width_inc;
   szHint.min_height = szHint.base_height + szHint.height_inc;

   szHint.width  = szHint.base_width  + TermWin.width;
   szHint.height = szHint.base_height + TermWin.height;
#if (MENUBAR_MAX)
   szHint.height += (delay_menu_drawing ? menuBar_TotalHeight() : 0);
#endif

   szHint.flags = PMinSize|PResizeInc|PBaseSize|PWinGravity;

   if (!init) {
     font_change_count++;
     resize();
   }

   return;
#undef IDX2FNUM
#undef FNUM2IDX
#undef FNUM_RANGE
}

/* main() */
int
main(int argc, char *argv[]) {

  int i;
  char *val;
  /* "WINDOWID=\0" = 10 chars, UINT_MAX = 10 chars */
  static char windowid_string[20], *display_string, *term_string;

  /* Security enhancements -- mej */
  my_ruid = getuid();
  my_euid = geteuid();
  my_rgid = getgid();
  my_egid = getegid();
  privileges(REVERT);

#ifdef DEBUG_UTMP
  fprintf(stderr, "Saved real uid/gid = [ %d, %d ]  effective uid/gid = [ %d, %d ]\n",
	  my_ruid, my_rgid, my_euid, my_egid);
  fprintf(stderr, "Now running with real uid/gid = [ %d, %d ]  effective uid/gid = [ %d, %d ]\n",
	  getuid(), getgid(), geteuid(), getegid());
#endif
  rs_name = APL_NAME " " VERSION;

#ifndef NDEBUG
  memrec_init();
#endif

  Options = (Opt_scrollBar);
  Xdisplay = NULL;
  display_name = NULL;
  rs_term_name = NULL;
#ifdef CUTCHAR_OPTION
  rs_cutchars = NULL;
#endif
#ifndef NO_BOLDFONT
  rs_boldFont = NULL;
#endif
#ifdef PRINTPIPE
  rs_print_pipe = NULL;
#endif
  rs_title = NULL;		/* title name for window */
  rs_iconName = NULL;		/* icon name for window */
  rs_geometry = NULL;		/* window geometry */

#if (MENUBAR_MAX)
  rs_menu = NULL;
#endif
#ifdef PIXMAP_SUPPORT
  rs_path = NULL;
#endif
#ifndef NO_BRIGHTCOLOR
  colorfgbg = DEFAULT_RSTYLE;
#endif

  /* Open display, get options/resources and create the window */
  if ((display_name = getenv("DISPLAY")) == NULL) display_name = ":0";

  TermWin.internalBorder = DEFAULT_BORDER_WIDTH;
#ifdef USE_THEMES
  get_initial_options(argc, argv);


#endif
  read_config();
  get_options(argc, argv);
#ifdef DEBUG_OPTIONS
  fprintf(stderr, "[debug] Bold color == %s\n", rs_color[colorBD]);
#endif

  Xdisplay = XOpenDisplay(display_name);
  if (!Xdisplay) {
    print_error("can't open display %s", display_name);
    exit(EXIT_FAILURE);
  }

#ifdef XTERM_SCROLLBAR
  sb_shadow = 0;
#else
  sb_shadow = (Options & Opt_scrollBar_floating) ? 0 : SHADOW;
#endif
  /* set any defaults not already set */
  if (!rs_title) rs_title = rs_name;
  if (!rs_iconName) rs_iconName = rs_name;
  if ((TermWin.saveLines = rs_saveLines) < 0) {
    TermWin.saveLines = SAVELINES;
  }

  /* no point having a scrollbar without having any scrollback! */
  if (!TermWin.saveLines) Options &= ~Opt_scrollBar;

#ifdef PRINTPIPE
  if (!rs_print_pipe) rs_print_pipe = PRINTPIPE;
#endif
#ifdef CUTCHAR_OPTION
  if (!rs_cutchars) rs_cutchars = CUTCHARS;
#endif

#ifndef NO_BOLDFONT
  if (rs_font[0] == NULL && rs_boldFont != NULL) {
    rs_font[0] = rs_boldFont;
    rs_boldFont = NULL;
  }
#endif
  for (i = 0; i < NFONTS; i++) {
    if (!rs_font[i]) rs_font[i]  = def_fontName[i];
#ifdef KANJI
    if (!rs_kfont[i]) rs_kfont[i] = def_kfontName[i];
#endif
  }

#ifdef XTERM_REVERSE_VIDEO
  /* this is how xterm implements reverseVideo */
  if (Options & Opt_reverseVideo) {
    if (!rs_color[fgColor]) rs_color[fgColor] = def_colorName[bgColor];
    if (!rs_color[bgColor]) rs_color[bgColor] = def_colorName[fgColor];
  }
#endif

  for (i = 0; i < NRS_COLORS; i++) {
    if (!rs_color[i]) rs_color[i] = def_colorName[i];
  }

#ifndef XTERM_REVERSE_VIDEO
  /* this is how we implement reverseVideo */
  if (Options & Opt_reverseVideo) {
    char *tmp;
    /* swap foreground/background colors */

    tmp = rs_color[fgColor];
    rs_color[fgColor] = rs_color[bgColor];
    rs_color[bgColor] = tmp;

    tmp = def_colorName[fgColor];
    def_colorName[fgColor] = def_colorName[bgColor];
    def_colorName[bgColor] = tmp;
  }
#endif

  /* convenient aliases for setting fg/bg to colors */
  color_aliases(fgColor);
  color_aliases(bgColor);
#ifndef NO_CURSORCOLOR
  color_aliases(cursorColor);
  color_aliases(cursorColor2);
#endif	/* NO_CURSORCOLOR */
#ifndef NO_BOLDUNDERLINE
  color_aliases(colorBD);
  color_aliases(colorUL);
#endif	/* NO_BOLDUNDERLINE */
  color_aliases(pointerColor);
  color_aliases(borderColor);
#ifdef DEBUG_OPTIONS
  fprintf(stderr, "[debug] Bold color == %s\n", rs_color[colorBD]);
#endif
  
#ifdef PREFER_24BIT
  Xdepth = DefaultDepth(Xdisplay, Xscreen);
  Xcmap = DefaultColormap(Xdisplay, Xscreen);
  Xvisual = DefaultVisual(Xdisplay, Xscreen);

  /*
   * If depth is not 24, look for a 24bit visual.
   */
  if (Xdepth != 24) {
    XVisualInfo vinfo;

    if (XMatchVisualInfo(Xdisplay, Xscreen, 24, TrueColor, &vinfo)) {
      Xdepth = 24;
      Xvisual = vinfo.visual;
      Xcmap = XCreateColormap(Xdisplay, RootWindow(Xdisplay, Xscreen),
			      Xvisual, AllocNone);
    }
  }
#endif

  /* add startup-menu: */
#if (MENUBAR_MAX)
  delay_menu_drawing = 1;
  menubar_read(rs_menu);
  delay_menu_drawing--;
#else
  delay_menu_drawing = 0;
#endif

  Create_Windows(argc, argv);
  scr_reset();		/* initialize screen */
  Gr_reset();			/* reset graphics */

/* add scrollBar, do it directly to avoid resize() */
  scrollbar_mapping(Options & Opt_scrollBar);
/* we can now add menuBar */
  if (delay_menu_drawing) {
    delay_menu_drawing = 0;
    menubar_mapping(1);
  }
  
#ifdef DEBUG_X
  XSynchronize(Xdisplay, True);
  XSetErrorHandler((XErrorHandler) abort);
#else
  oldXErrorHandler = XSetErrorHandler((XErrorHandler) xerror_handler);
#endif
  
#ifdef DISPLAY_IS_IP
  /* Fixup display_name for export over pty to any interested terminal
   * clients via "ESC[7n" (e.g. shells).  Note we use the pure IP number
   * (for the first non-loopback interface) that we get from
   * network_display().  This is more "name-resolution-portable", if you
   * will, and probably allows for faster x-client startup if your name
   * server is beyond a slow link or overloaded at client startup.  Of
   * course that only helps the shell's child processes, not us.
   *
   * Giving out the display_name also affords a potential security hole
   */
  val = display_name = network_display(display_name);
  if (val == NULL)
#endif	/* DISPLAY_IS_IP */
    
    val = XDisplayString(Xdisplay);
  if (display_name == NULL)
    display_name = val;	/* use broken `:0' value */
  
  i = strlen(val);
  display_string = MALLOC((i+9));
  
  sprintf(display_string, "DISPLAY=%s", val);
  sprintf(windowid_string, "WINDOWID=%u", (unsigned int) TermWin.parent);
  
  /* add entries to the environment:
   * @ DISPLAY:   in case we started with -display
   * @ WINDOWID:  X window id number of the window
   * @ COLORTERM: terminal sub-name and also indicates its color
   * @ TERM:      terminal name
   */
  putenv(display_string);
  putenv(windowid_string);
  if (Xdepth <= 2) {
    putenv ("COLORTERM=" COLORTERMENV "-mono");
    putenv ("TERM=" TERMENV);
  } else {
    if (rs_term_name != NULL) {
      i = strlen(rs_term_name);
      term_string = MALLOC((i + 6) * sizeof(char));

      sprintf(term_string, "TERM=%s", rs_term_name);
      putenv(term_string);
    } else {
#ifdef DEFINE_XTERM_COLOR
      if (Xdepth <= 2)
	putenv("TERM=" TERMENV);
      else
	putenv("TERM=" TERMENV "-color");
#else
      putenv("TERM=" TERMENV);
#endif
    }
#ifdef PIXMAP_SUPPORT
    putenv("COLORTERM=" COLORTERMENV "-pixmap");
#else
    putenv("COLORTERM=" COLORTERMENV);
#endif
  }

  init_command(rs_execArgs);
  if (Options & Opt_borderless) {
	resize_window();
  }
  main_loop();		/* main processing loop */
  return (EXIT_SUCCESS);
}
/* EOF */
