/*
 * $Id: w_string.c,v 1.4 1994/10/14 05:39:11 kuwa Exp $
 */
/*
 * Copyright Kyoto University Research Institute for Mathematical Sciences
 *                 1987, 1988, 1989, 1990, 1991
 * Copyright OMRON Corporation. 1987, 1988, 1989, 1990, 1991
 * Copyright ASTEC, Inc. 1987, 1988, 1989, 1990, 1991
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that all of the following conditions are satisfied:
 *
 * 1) The above copyright notices appear in all copies
 * 2) Both those copyright notices and this permission notice appear
 *    in supporting documentation
 * 3) The name of "Wnn" isn't changed unless substantial modifications
 *    are made, or
 * 3') Following words followed by the above copyright notices appear
 *    in all supporting documentation of software based on "Wnn":
 *
 *   "This software is based on the original version of Wnn developed by
 *    Kyoto University Research Institute for Mathematical Sciences (KURIMS),
 *    OMRON Corporation and ASTEC Inc."
 *
 * 4) The names KURIMS, OMRON and ASTEC not be used in advertising or
 *    publicity pertaining to distribution of the software without
 *    specific, written prior permission
 *
 * KURIMS, OMRON and ASTEC make no representations about the suitability
 * of this software for any purpose.  It is provided "as is" without
 * express or implied warranty.
 *
 * Wnn consortium is one of distributors of the official Wnn source code
 * release.  Wnn consortium also makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * KURIMS, OMRON, ASTEC AND WNN CONSORTIUM DISCLAIM ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL KURIMS, OMRON, ASTEC OR
 * WNN CONSORTIUM BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
/*	Version 4.0
 */
#include <stdio.h>
#include "commonhd.h"
#include "wnn_string.h"

void Sreverse(w1, w2)
register w_char *w1, *w2;
{
    wnn_Sreverse(w1, w2);
}

int Sstrcpy(w, c)
register w_char *w;
register unsigned char *c;
{
    return(wnn_Sstrcpy(w, c));
}

int Strcmp(w1, w2)
register w_char *w1, *w2;
{
    return(wnn_Strcmp(w1, w2));
}

int Substr(w1, w2)
register w_char *w1, *w2;
{
    return(wnn_Substr(w1, w2));
}

int Strncmp(w1, w2, n)
register w_char *w1, *w2;
register int n;
{
    return(wnn_Strncmp(w1, w2, n));
}

w_char * Strcpy(w1, w2)
register w_char *w1, *w2;
{
    return(wnn_Strcpy(w1, w2));
}

w_char * Strncpy(w1, w2, n)
register w_char *w1, *w2;
register int n;
{
    return(wnn_Strncpy(w1, w2, n));
}

int Strlen(w)
register w_char *w;
{
    return(wnn_Strlen(w));
}

#ifdef nodef
int
wstrncmp(s1, s2, n)
register w_char *s1, *s2;
register int n;
{
	for(; *s1 != 0 && *s2 !=0; ) {
		if (*s1 != *s2)
			return (w_char_cmp(*s1, *s2));
		s1++;
		s2++;
		n--;
		if ( n == 0)
			return (0);
	}
	if (*s1 == 0 && *s2 == 0)
		return (0);
	if (*s1 == 0)
		return (-1);
	return (1);
}

w_char_cmp(s1, s2)
register w_char s1, s2;
{
	if (s1 == s2)
		return (0);
	if (s1 == TOUTEN_NUM){
		if(s2== KUTEN_NUM)
			return(-1);
		return(1);
	}
	if (s1 == KUTEN_NUM)
		return(1);
	if(s2 == TOUTEN_NUM || s2 == KUTEN_NUM)
		return(-1);
	if (s2 > s1)
		return (-1);
	return (1);
}
#endif
