#include "pscol.h"

/***********************************************************************/
/*                                                                     */
/* convcolor: converts the ansi string to readable colors              */
/*                                                                     */
/***********************************************************************/

char *convcolor(char *col)
{
 char *color[] = {"non", "bla", "red", "gre", "yel", "blu", "mag", "cya",
                  "whi", 0};
 char *ansi, *a;
 int bri = 0, bli = 0, bg = -1, fg = -1, abort = 0, x;

 ansi = malloc(16);
 abort = bri = bli = 0;
 for (a = strtok(strdup(col), ";");a && !abort;a = strtok(NULL, ";"))
 {
  x = atoi(a);
  switch (x)
  {
   case 0: break;                /* Compatability! */
   case 1: bri = 1;              /* Bright text    */
           break;
   case 5: bli = 1;              /* Blinking text  */
           break;
   case 30 ... 37: fg = x - 30;  /* Foreground     */
                   break;
   case 40 ... 47: bg = x - 40;  /* Background     */
                   break;
   default: abort = 1;           /* unknown code   */
  }
 }
 if (!abort)
 {
  if (bg == -1)
   sprintf(ansi, "%s%s%s", bri?"bri ":"", bli?"bli ":"", color[fg + 1]);
  else
   sprintf(ansi, "%s%s%s on %s", bri?"bri ":"", bli?"bli ":"",
           color[fg + 1], color[bg + 1]);
  return ansi;
 }
 return col;  /* color couldn't be converted */
}
