dnl Testing delegations for a2ps: a recent version of psutils
dnl 
dnl Usage: a2_PSUTILS(major, minor)
dnl
dnl If psutils version MAJOR, patch level MINOR is available
dnl     SUBST(PSUTILS) to <nothing>
dnl else
dnl     SUBST(PSUTILS) to `#'
dnl Akim.Demaille@inf.enst.fr

# serial 2

AC_DEFUN(a2_PSUTILS,
[AC_CHECK_PROG(HAVE_PSSELECT, psselect, yes, no)
if test $HAVE_PSSELECT = no; then
  AC_MSG_WARN([a2ps works better with the psutils.  Available at])
  AC_MSG_WARN([  http://www.dcs.ed.ac.uk/home/ajcd/psutils/])
  PSUTILS="#"
else
  if test $HAVE_PSSELECT = yes; then
    # There is one.  Check version > MAJOR.MINOR
    ac_prog_psselect_banner=`psselect -h 2>&1 | sed 1q`
    ac_prog_psselect_release=`set -- $ac_prog_psselect_banner && echo $[3]`
    ac_prog_psselect_patch=`set -- $ac_prog_psselect_banner && echo $[5]`
    test ${ac_prog_psselect_release}0 -lt $1[0] && HAVE_PSSELECT=no
    test ${ac_prog_psselect_patch}0 -lt $2[0] && HAVE_PSSELECT=no
    if test $HAVE_PSSELECT = no; then
       AC_MSG_WARN([a2ps works better with the psutils.  Yours is too old.])
       AC_MSG_WARN([  http://www.dcs.ed.ac.uk/home/ajcd/psutils/])
       PSUTILS="#"
    else
       PSUTILS=""
    fi
  fi
fi
AC_SUBST(PSUTILS)])
