/*
 *  qftp
 *  Copyright (C) 1997,1998 Peter Strand
 *  Distributed under the GNU Pulic Licence
 */

#include <string.h>
#include <stdlib.h>

#include "flist.h"

FileInf &FileInf::operator=(FileInf &fi)
{
	if (fi.name)
		name = strdup(fi.name);
	else
		name = NULL;
	if (fi.date)
		date = strdup(fi.date);
	else
		date = NULL;
	perm = fi.perm;
	size = fi.size;
	type = fi.type;
	next = NULL;
}

		
FileList::FileList()
{
	first = last = cur = NULL;
}


FileList &FileList::operator=(FileList &fl)
{
	first = fl.first;
	last = fl.last;
	cur = fl.cur;
}

void FileList::Flush()
{
	if (first) {
		FileInf *tmp = first;
		FileInf *t;
		while (tmp) {
			t = tmp->next;
			if (tmp->name)
				free(tmp->name);
			if (tmp->date)
				free(tmp->date);
			delete tmp;
			tmp = t;
		}
	}
}

void FileList::AddFile(FileInf &file)
{
	FileInf *tmp;
	tmp = new FileInf;
	*tmp = file;
	if (first) {
		last->next = tmp;
		last = tmp;
	} else {
		first = tmp;
		last = tmp;
		cur = tmp;
	}
}

int FileList::GetFile(FileInf &file)
{
	if (!cur)
		return 0;
	file = *cur;
	//	file.name = strdup(cur->name);
	//	file.date = strdup(cur->date);
	
	cur = cur->next;
	return 1;
}

int FileList::GetFileAt(FileInf &file, int n)
{
	FileInf *t = first;
	while (t && --n) {
		t = t->next;
		if (!t)
			break;
	}
	if (!t || n)
		return 0;
	file = *t;
	return 1;
}

void FileList::Reset()
{
	cur = first;
}






