/*
 * notice.c: special stuff for parsing NOTICEs
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1991
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#if 0
static	char	rcsid[] = "@(#)$Id: notice.c,v 1.18 1994/07/02 02:32:13 mrg Exp $";
#endif

#include "irc.h"

#include "whois.h"
#include "ctcp.h"
#include "window.h"
#include "lastlog.h"
#include "flood.h"
#include "vars.h"
#include "ircaux.h"
#include "hook.h"
#include "ignore.h"
#include "server.h"
#include "funny.h"
#include "output.h"
#include "names.h"
#include "parse.h"
#include "notify.h"
#include "edit.h"
#include "whois.h"

extern	char	*FromUserHost;
extern	void	got_initial_version _((char *));
static time_t convert_note_time_to_real_time _((char *stuff));
	int	doing_notice;


/*
 * The client apparantly never was adapted to handle the new NOTE syntax.
 * So i had to kludge this up to work with it.  Currently, NOTEs are sent
 * something like this:
 *
 *	NOTICE yournick :Note from nick!user@host /xxxd:xxh:xxm/ [N] message
 *
 * and parse() calls parse_notice(), who notices that there is no pefix
 * and passes it off to parse_server_notice(), who checks to see if it is
 * a note (it is), blows away the "Note from" part, and re-sets the "from"
 * and "FromUserHost" parts with the nick!user@host part and passes us the
 * buck with 'line' pointing at the time description (the /.../ part)
 */
#ifdef __STDC__
static void parse_note (char *from, char *line)
#else
static	void	parse_note(from, line)
char	*from;
char	*line;
#endif
{
	char	*date,
		*flags,
		*high;
	time_t	when;
	int 	level;

	switch (check_ignore(from, FromUserHost, IGNORE_NOTES))
	{
		case IGNORED:
			return;
		case HIGHLIGHTED:
			high = highlight_char;
			break;
		default:
			high = empty_string;
	}

/* 
	at this point, line looks like:
	"/xxxd:xxh:xxm/ [FLAGS] message goes here"
 */
	date = next_arg(line, &line);
	flags = next_arg(line, &line);

	when = convert_note_time_to_real_time(date);
	level = set_lastlog_msg_level(LOG_NOTES);

	if (do_hook(NOTE_LIST, "%s %lu %s", from, when, line))
	{
		if (time(NULL) - when > 60)	/* not just sent */
			put_it("%s[%s]%s %s (%s)", high, from, high, line, my_ctime(when));
		else
			put_it("%s[%s]%s %s", high, from, high, line);
	}

	if (beep_on_level & LOG_NOTES)
		beep_em(1);
	set_lastlog_msg_level(level);
}

#ifdef __STDC__
static time_t convert_note_time_to_real_time(char *stuff)
#else
static time_t convert_note_time_to_real_time(stuff)
char *stuff;
#endif
{
	time_t days = 0, hours = 0, minutes = 0;

	stuff++;			      /* first character is a '/' */
	days = strtoul(stuff, &stuff, 10);    /* get the number of days */
	stuff++;			      /* skip over the 'd' */
	stuff++;			      /* skip over the ':' */
	hours = strtoul(stuff, &stuff, 10);   /* get the number of hours */
	stuff++;			      /* skip over the 'h' */
	stuff++;			      /* skip over the ':' */
	minutes = strtoul(stuff, &stuff, 10); /* get the number of minutes */
	stuff++;			      /* skip over the 'm' */
	stuff++;			      /* skip over the '/' */
	if (*stuff)
		yell("cntto: bad format");

	hours += days * 24;
	minutes += hours * 60;
	return (time(NULL) - minutes * 60);
}

#ifdef __STDC__
static 	void 	parse_server_notice (char *from, char *line)
#else
static	void	parse_server_notice(from, line)
	char	*from,
		*line;
#endif
{
	int	lastlog_level;

	if (!from || !*from)
		from = server_list[from_server].itsname ?
			server_list[from_server].itsname :
			server_list[from_server].name;

#ifdef COMPAT_27
	/* ircd2.7 MOTD */
	if (get_int_var(SUPPRESS_SERVER_MOTD_VAR) &&
		get_server_motd(from_server))
	{
		if (strncmp("*** Message-of-today", line, 20) == 0)
		{
			set_server_motd(from_server, 0);
			return;
		}
		if (strncmp("MOTD ", line, 5) == 0)
		{
			set_server_motd(from_server, 1);
			return;
		}
		if (strcmp("* End of /MOTD command.", line) == 0)
		{
			set_server_motd(from_server, 0);
			return;
		}
	}

	/* Only bite on the "IRCII_KLUDGE" if its not a 2.8 class server. */
	else if (!get_server2_8(from_server) && !strncmp(line, "*** Your host is ", 17))
		got_initial_version(line);

	else
#endif /* COMPAT_27 */


	/* OPERator Notices */
	if (!strncmp(line, "*** Notice --", 13))
	{
		message_from((char *) 0, LOG_OPNOTE);
		lastlog_level = set_lastlog_msg_level(LOG_OPNOTE);
	}

	/* NOTEs */
	else if (!strncmp(line, "Note", 4))
	{
		char *note_from = NULL;
		line += 10; /* skip the "Note from" part */
		note_from = line;
		line = index(note_from, '!');
		*line++ = 0;
		FromUserHost = line;
		line = index(FromUserHost, ' ');
		parse_note(note_from, line);
		return;
	}

	message_from((char *) 0, LOG_SNOTE);
	lastlog_level = set_lastlog_msg_level(LOG_SNOTE);

	/* Check to see if the notice already has its own header... */
	if (*line == '*' || *line == '#')
	{
		if (do_hook(SERVER_NOTICE_LIST, "%s %s", from, line))
			put_it("%s", line);
	}
	else
		if (do_hook(SERVER_NOTICE_LIST, "%s *** %s", from, line))
			put_it("*** %s", line);

	if (lastlog_level)
	{
		set_lastlog_msg_level(lastlog_level);
		message_from((char *) 0, lastlog_level);
	}
}

#ifdef __STDC__
extern void 	parse_notice (char *from, char **Args)
#else
extern void 	parse_notice(from, Args)
	char 	*from;
	char 	**Args;
#endif
{
	int	level,
		type;
	char	*to;
	int	no_flooding;
	char	*high,
		not_from_server = 1;
	char	*line;

	PasteArgs(Args, 1);
	to = Args[0];
	line = Args[1];
	if (!to || !line)
		return;
	doing_notice = 1;

	if (*to)
	{
		if (is_channel(to))
		{
			message_from(to, LOG_NOTICE);
			type = PUBLIC_NOTICE_LIST;
		}
		else
		{
			message_from(from, LOG_NOTICE);
			type = NOTICE_LIST;
		}

		if (from && *from && strcmp(get_server_itsname(from_server), from))
		{
			switch (check_ignore_channel(from, FromUserHost, to, IGNORE_NOTICES))
			{
				case IGNORED:
					doing_notice = 0;
					return;
				case HIGHLIGHTED:
					high = highlight_char;
					break; /* oops! */
				default:
					high = empty_string;
			}

	/*
	 * only dots in servernames, right ?
	 *
	 * But a server name doesn't nessicarily have to have
	 * a 'dot' in it..  - phone, jan 1993.
	 */
			if (index(from, '.'))
				not_from_server = 0;

			line = do_notice_ctcp(from, to, line);
			if (*line == (char) 0)
			{
				doing_notice = 0;
				return;
			}
			level = set_lastlog_msg_level(LOG_NOTICE);
			no_flooding = check_flooding(from, NOTICE_FLOOD, line);

			if (sed == 1 && !do_hook(ENCRYPTED_NOTICE_LIST, "%s %s %s", from, to, line))
				sed = 0;
			else
			{
				if (no_flooding)
				{
					if (type == NOTICE_LIST)
					{
						if (do_hook(type, "%s %s", from, line))
							put_it("%s-%s-%s %s", high, from, high, line);
					}
					else
					{
						if (do_hook(type, "%s %s %s", from, to, line))
							put_it("%s-%s:%s-%s %s", high, from, to, high, line);
					}
					if (beep_on_level & LOG_NOTICE)
						beep_em(1);
				}
				set_lastlog_msg_level(level);
				if (not_from_server)
					notify_mark(from, 1, 0);
			}
		}
		else 
			parse_server_notice(from, line);
	}
	else
		put_it("%s", line + 1);

	doing_notice = 0;
}

#ifdef COMPAT_27
/*
 * got_initial_version: this is called when ircii get the NOTICE in
 * all version of ircd before 2.8, or the 002 numeric for 2.8 and
 * beyond.  I guess its handled rather badly at the moment....
 * added by phone, late 1992.
 */
#ifdef __STDC__
extern 	void 	got_initial_version (char *line)
#else
extern 	void	got_initial_version(line)
	char	*line;
#endif
{
	char	server[81],
		version[21];
	char	*c;

	if ((sscanf(line, "*** Your host is %80s running version %20s",
			server, version)) != 2)
		return;
	attempting_to_connect--;
	set_server_motd(from_server, 1);
	server_is_connected(from_server, 1);
	server[strlen(server) - 1] = '\0';
	if ((c = (char *) index(server, '[')) != NULL)
		*c = '\0';	/*
				 * Handles the case where the server name is
				 * different to the host name.
				 */
	set_server_version(from_server, Server2_7);
	add_userhost_to_whois(get_server_nickname(from_server), got_my_userhost);

	malloc_strcpy(&server_list[from_server].version_string, version);
	set_server_itsname(from_server, server);
	reconnect_all_channels();
	reinstate_user_modes();
	if (never_connected)
	{
		never_connected = 0;
		loading_global = 1;
		load("LOAD", "global", empty_string);
		loading_global = 0;
		/* read the .ircrc file */
		if (access(ircrc_file, R_OK) == 0 && !quick_startup)
			load(empty_string, ircrc_file, empty_string);

		else if (get_int_var(NOVICE_VAR))
			say("If you have not already done so, please read the new user information with /HELP NEWUSER");
	}
	else if (server_list[from_server].away)
		send_to_server("AWAY :%s", server_list[from_server].away);
	update_all_status();
	do_hook(CONNECT_LIST, "%s %d", get_server_name(from_server),
		get_server_port(from_server));
}
#endif /* COMPAT_27 */

/*
 * got_initial_version_28: this is called when ircii gets the serial
 * number 004 reply.  We do this becuase the 004 numeric gives us the
 * server name and version in a very easy to use fashion, and doesnt
 * rely on the syntax or construction of the 002 numeric.
 *
 * Hacked as neccesary by jfn, May 1995
 */
#ifdef __STDC__
extern void 	got_initial_version_28 (char **ArgList)
#else
extern void	got_initial_version_28(ArgList)
	char	**ArgList;
#endif
{
	char *server, *version;

	server = ArgList[0];
	version = ArgList[1];

	attempting_to_connect--;
	set_server_motd(from_server, 1);
	server_is_connected(from_server, 1);
	add_userhost_to_whois(get_server_nickname(from_server), got_my_userhost);

	if (!strncmp(version, "2.8", 3))
	{
		if (strstr(version, "mu") || strstr(version, "me"))
			set_server_version(from_server, Server_u2_8);
		else
			set_server_version(from_server, Server2_8);
	}
	else if (!strncmp(version, "2.9", 3))
		set_server_version(from_server, Server2_9);
	else if (!strncmp(version, "u2.9", 4))
		set_server_version(from_server, Server_u2_9);
	else if (!strncmp(version, "u2.10", 4))
		set_server_version(from_server, Server_u2_10);
	else if (!strncmp(version, "u3.0", 4))
		set_server_version(from_server, Server_u3_0);
	else
		set_server_version(from_server, Server2_8);

	malloc_strcpy(&server_list[from_server].version_string, version);
	set_server_itsname(from_server, server);
	reconnect_all_channels();
	reinstate_user_modes();
	if (never_connected)
	{
		char buffer[BIG_BUFFER_SIZE+1];
		strcpy(buffer, "global");

		never_connected = 0;

		loading_global = 1;
		load("LOAD", buffer, empty_string);
		loading_global = 0;

		/* read the .ircrc file */
		if (access(ircrc_file, R_OK) == 0 && !quick_startup)
			load("LOAD", ircrc_file, empty_string);

		else if (get_int_var(NOVICE_VAR))
			say("If you have not already done so, please read the new user information with /HELP NEWUSER");
	}
	else if (server_list[from_server].away)
		send_to_server("AWAY :%s", server_list[from_server].away);

	update_all_status();
	do_hook(CONNECT_LIST, "%s %d", get_server_name(from_server),
		get_server_port(from_server));
}
