/* Asp Address Search Protocol (file: asp.h)                               */
/* Copyright (C) 1996-97 Stenio Brunetta                                   */
/*                                                                         */
/*  This program is free software; you can redistribute it and/or modify   */
/*  it under the terms of the GNU General Public License as published by   */
/*  the Free Software Foundation; either version 2 of the License, or      */
/*  (at your option) any later version.                                    */
/*                                                                         */
/*  This program is distributed in the hope that it will be useful,        */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of         */  
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*  GNU General Public License for more details.                           */
/*                                                                         */
/*  You should have received a copy of the GNU General Public License      */
/*  along with this program; if not, write to the Free Software            */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                         */
/*  Author's addresses:                                                    */
/*  email: brunetta@tin.it, stebrune@dsi.unive.it                          */


#ifndef ASP_H
#define ASP_H 1

#ifdef HAVE_CONFIG_H
#   include <config.h>
#endif

#ifdef HAVE_ARPA_INET_H
#   include <arpa/inet.h>
#endif

#include <ctype.h>

#ifdef HAVE_ERRNO_H
#   include <errno.h>
#endif

#ifdef HAVE_LIBC_H
#   include <libc.h>
#endif

#ifdef HAVE_LIMITS_H
#   include <limits.h>
#else
#   define INT_MAX 32767
#endif

#ifdef HAVE_NETDB_H
#   include <netdb.h>
#endif

#ifdef HAVE_NETINET_IN_H
#   include <netinet/in.h>
#endif

#ifdef HAVE_PWD_H
#   include <pwd.h>
#endif

#include <signal.h>
#include <stdio.h>

#ifdef STDC_HEADERS
#   include <stdlib.h>
#else
#   ifndef HAVE_STRCHR
#      define strchr index
#      define strrchr rindex
#   endif
char *strchr (), *strrchr ();
#endif

#ifdef HAVE_STRING_H
#   include <string.h>
#else
#   ifdef HAVE_STRINGS_H
#      include <strings.h>
#   endif
#endif

#ifdef HAVE_SYS_DDI_H
#   include <sys/ddi.h>
#endif

#ifdef HAVE_SYS_SELECT_H
#   include <sys/select.h>
#endif

#ifdef HAVE_SYS_SOCKET_H
#   include <sys/socket.h>
#endif

#ifdef HAVE_SYS_SOCKETVAR_H
#   include <sys/socketvar.h>
#endif

#ifdef HAVE_SYS_SYSLOG_H
#   ifndef HAVE_SYSLOG_H
#      include <sys/syslog.h>
#   endif
#endif

#ifdef TIME_WITH_SYS_TIME
#   include <sys/time.h>
#   include <time.h>
#else
#   ifdef HAVE_SYS_TIME_H
#      include <sys/time.h>
#   else
#      include <time.h>
#   endif
#endif

#include <sys/types.h>

#ifdef HAVE_SYS_UTSNAME_H
#   ifndef HAVE_GETHOSTNAME
#      ifdef HAVE_UNAME
#         include <sys/utsname.h>
#      endif
#   endif
#endif

#ifdef HAVE_SYSLOG_H
#   include <syslog.h>
#endif

#ifdef HAVE_UNISTD_H
#   include <unistd.h>
#endif

#define MSGSIZE         64
#define ASP_PORT	27374

extern int verbose;
extern char* prog_name;

#ifndef HAVE_ERRNO_DECL
extern int errno;
#endif

extern void*  emalloc(int, char*);
extern char*  ins(char*, char*, int);
extern char*  tilde_expand(char*);
extern char** get_token(int*, char*);
extern int    bound_check(char*, int, int, int*);
extern int    asp_send(int, int, char*, struct sockaddr *);
extern int    asp_recv(int, int, char*, char*, struct sockaddr *, int);
extern int    get_ip(char buffer[]);
extern int    input_timeout(int, unsigned int, unsigned int);
extern void   asp_perror(char*); 

#ifndef HAVE_GETHOSTNAME
extern int gethostname(char*, size_t);
#endif

#ifndef HAVE_STRERROR
extern char* strerror(int);
#endif

#ifndef HAVE_STRSIGNAL_DECL
extern char* strsignal(int);
#endif

#ifndef HAVE_INET_ATON_DECL
#   ifdef HAVE_INET_ATON
extern int inet_aton(const char *, struct in_addr *);
#   endif
#endif

#endif




