#!/usr/local/bin/perl
#  rep-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: txn-list.pl,v 2.6 1997/04/23 18:06:24 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff


my($cbb_incl_dir, $temp);
my($account, @account_list, $name, $key, $trans, %ALLTRANS);
my($gtotal, $junk, $result);
my($date, $todate, $fromdate);


# return the directory of a file name (this is duplicated in common.pl
# but we need this to find the include directory for common.pl :-(
sub my_file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else { 
	return "./"; 
    }
}

# specify the installed location of the necessary pieces.
$temp = &my_file_dirname($0); chop($temp);
$cbb_incl_dir = &my_file_dirname($temp);
unshift(@INC, $cbb_incl_dir);

require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%ALLTRANS = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $trans) = split(/\t/, $result, 2);
        ($date, $junk) = split(/\t/, $trans, 2);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
	    $ALLTRANS{"$key$name"} = $trans;
        }

        $result = &next_trans();
    }
}

# sort and print
foreach $key (sort (keys %ALLTRANS) ) {
    # print $ALLTRANS{$key} . "\n";
    &format_line("$ALLTRANS{$key}");
}


$gtotal = 0.00;

sub format_line {
    my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/\t/, $_[0]);
    my($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    my($nicedate, $cutdesc, $cutcom, $nicecat);

    $year = substr($year, 2, 4);

    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 15);
    $cutcom = substr($com, 0, 15);
    $nicecat = substr($cat, 0, 9);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

    $gtotal += $credit - $debit;

    printf("%5s  %-8s  %-15s  %9.2f  %9.2f  %-1s  %9.2f\n",
          $check, $nicedate, $cutdesc, $debit, $credit, $cleared, $gtotal);
    printf("%5s  %-8s  %-15s  %-9s\n\n", "", "", $cutcom, $nicecat);
}

# ----------------------------------------------------------------------------
# $Log: txn-list.pl,v $
# Revision 2.6  1997/04/23 18:06:24  curt
# Fixed a missing "require"
#
# Revision 2.5  1997/01/28 03:25:52  curt
# Force strict scoping in all perl scripts.
#
# Revision 2.4  1996/12/17 14:54:16  curt
# Updated copyright date.
#
# Revision 2.3  1996/12/13 01:25:54  curt
# Modified paths.  Updated to work with reports.tcl
#
# Revision 2.2  1996/07/13 02:58:46  curt
# Misc. changes.
#
# Revision 2.1  1996/02/27  05:36:24  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:43:33  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
