/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
 
#include <X11/Intrinsic.h>
#include "icon.h"

#ifdef XPM
#include <X11/xpm.h>
#include "../common/bitmaps/siag_fg.xpm"
#else
#include "../common/bitmaps/siag_fg.xbm"
#include "../common/bitmaps/siag_bg.xbm"
#endif

static Pixmap	SiagIcon,SiagMask;

void
ReadIcons(Widget toplevel)
{
	XWMHints *hints;
	Display *dpy=XtDisplay(toplevel);
	int Width,Height;
	int scrn=DefaultScreen(dpy);
	int dpth=XDefaultDepth(dpy,scrn);
	Window win=DefaultRootWindow(dpy);
	/* Create the pixmaps accordingly		       *
	 * All the pixmaps MUST have the same height and width */
#ifdef XPM
	XpmAttributes xpmattributes;
	xpmattributes.depth=dpth;
	xpmattributes.valuemask=XpmSize | XpmDepth;
	XpmCreatePixmapFromData(dpy,win,siag_fg_xpm,&SiagIcon,&SiagMask,
				&xpmattributes);
	Width=xpmattributes.width;
	Height=xpmattributes.height;
#else
	SiagIcon=XCreatePixmapFromBitmapData(dpy,win,siag_fg_bits,
			siag_fg_width,siag_fg_height,BlackPixel(dpy,scrn),
			WhitePixel(dpy,scrn),dpth);
	SiagMask=XCreateBitmapFromData(dpy, win,siag_bg_bits,
			siag_bg_width,siag_bg_height);
	Width=siag_fg_width;
	Height=siag_fg_height;
#endif
	
	/* Now tell the window manager what the icon is */
	hints=XAllocWMHints();
	hints->flags=IconPixmapHint | IconMaskHint;
	hints->icon_pixmap=SiagIcon;
	hints->icon_mask=SiagMask;
	XSetWMHints(dpy,XtWindow(toplevel),hints);
	XFree(hints);
}
