#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Label.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Viewport.h>
#include <X11/Xaw/List.h>

static Widget alert, listshell;
static int status;

static void
alert_clicked(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(alert);
	status = (int)client_data;
}

int alertbox(Widget pw, char *text, char *buttons[], int nbuttons)
{
	Widget topbox, buttonbox, label, command;
	int i;
	Position x, y;
	Dimension width, height, w1, h1;
	XtAppContext app_context = XtWidgetToApplicationContext(pw);

	alert = XtVaCreatePopupShell("alert",
		transientShellWidgetClass, pw, NULL);
	topbox = XtVaCreateManagedWidget("topbox",
		boxWidgetClass, alert, NULL);
	label = XtVaCreateManagedWidget("label",
		labelWidgetClass, topbox, XtNlabel, text, NULL);
	buttonbox = XtVaCreateManagedWidget("buttonbox",
		boxWidgetClass, topbox, NULL);
	for (i = 0; i < nbuttons; i++) {
		command = XtVaCreateManagedWidget("command",
			commandWidgetClass, buttonbox,
			XtNlabel, buttons[i], NULL);
		XtAddCallback(command,
			XtNcallback, alert_clicked, (XtPointer)i);
	}
	status = -1;
	XtRealizeWidget(alert);
	XtUnrealizeWidget(alert);
	XtVaGetValues(pw,
		XtNwidth, &width,
		XtNheight, &height, NULL);
	XtVaGetValues(alert,
		XtNwidth, &w1,
		XtNheight, &h1, NULL);
	XtTranslateCoords(pw,
		(Position) (width-w1)/2, (Position) (height-h1)/2,
		&x, &y);
	XtVaSetValues(alert,
		XtNx, x,
		XtNy, y, NULL);
	XtPopup(alert, XtGrabNonexclusive);
	while (status < 0) {
		XEvent event_return;
		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}
	XtDestroyWidget(alert);
	return status;
}

void errorbox(Widget pw, char *message)
{
	char *buttons[] = {"OK"};

	alertbox(pw, message, buttons, 1);
}

static void
listsel_clicked(Widget w, XtPointer client_data, XtPointer call_data)
{
	XtPopdown(listshell);
	status = (int)client_data;
}

void center(Widget parent, Widget child)
{
	Position x, y;
	Dimension width, height, w1, h1;

	XtRealizeWidget(child);
	XtUnrealizeWidget(child);
	XtVaGetValues(parent,
		XtNwidth, &width,
		XtNheight, &height, NULL);
	XtVaGetValues(child,
		XtNwidth, &w1,
		XtNheight, &h1, NULL);
	XtTranslateCoords(parent,
		(Position)(width-w1)/2, (Position)(height-h1)/2, &x, &y);
	XtVaSetValues(child,
		XtNx, x,
		XtNy, y, NULL);
}

int listsel(Widget pw, char *text, char *choices[], int nchoices)
{
	Widget topbox, listbox, buttonbox, label, viewport, list,
		okbutton, cancelbutton;
	int n;
	XtAppContext app_context = XtWidgetToApplicationContext(pw);

	listshell = XtVaCreatePopupShell("listshell",
		transientShellWidgetClass, pw, NULL);
	topbox = XtVaCreateManagedWidget("topbox",
		boxWidgetClass, listshell, NULL);
	listbox = XtVaCreateManagedWidget("listbox",
		boxWidgetClass, topbox, NULL);
	label = XtVaCreateManagedWidget("label",
		labelWidgetClass, listbox, XtNlabel, text, NULL);
	viewport = XtVaCreateManagedWidget("viewport",
		viewportWidgetClass, listbox, NULL);
	list = XtVaCreateManagedWidget("list",
		listWidgetClass, viewport, NULL);
	XawListChange(list,
		choices, nchoices, 0, True);
	buttonbox = XtVaCreateManagedWidget("buttonbox",
		boxWidgetClass, topbox, NULL);
	okbutton = XtVaCreateManagedWidget("okbutton",
		commandWidgetClass, buttonbox, NULL);
	XtAddCallback(okbutton,
		XtNcallback, listsel_clicked, (XtPointer)1);
	cancelbutton = XtVaCreateManagedWidget("cancelbutton",
		commandWidgetClass, buttonbox, NULL);
	XtAddCallback(cancelbutton,
		XtNcallback, listsel_clicked, (XtPointer)0);
	status = -1;
	center(pw, listshell);
	XtPopup(listshell, XtGrabNonexclusive);

	while (status < 0) {
		XEvent event_return;
		XtAppNextEvent(app_context, &event_return);
		XtDispatchEvent(&event_return);
	}
	n = XawListShowCurrent(list)->list_index;
	XtDestroyWidget(listshell);
	if (status)	/* clicked OK */
		return n;
	else		/* clicked Cancel */
		return -1;
}

