
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>
#include "../siod/siod.h"
#include "../siag/types.h"
#include "../siag/calc.h"
#include "tsiag.h"

int select_file(char *path, char *name, char *patterns[], char *fmt)
{
	int nchoices, format;
	for (nchoices = 0; patterns[nchoices]; nchoices++);
	format = select_from_list("File format:", patterns, nchoices);
	if (format < 0) return 0;
	strcpy(fmt, patterns[format]);

	return ask_for_str("Filename:", name);
}

int alert_box(char *text, char *buttons[], int nbuttons)
{
	llpr(text);
	return 0;
}

int select_from_list(char *text, char *choices[], int nchoices)
{
	char b[1024];
	int i;

TRACEME((f,"select_from_list(%s,%s...,%d)",text,*choices,nchoices))

	clear();
	refresh();
	move(0, 0);
	clrtoeol();
	standout();
	addstr(text);
	standend();
	for (i = 1; i <= nchoices; i++) {
		move(i, 0);
		clrtoeol();
		printw("%d: %s", i, choices[i-1]);
		refresh();
	}
	move(i, 0);
	clrtoeol();
	pr_scr_flag = 1;

	b[0] = '\0';
	if (ask_for_str(text, b) && ((i = atol(b)) > 0) && (i <= nchoices))
		return i-1;
	return -1;
}

void error_box(char *message)
{
	llpr(message);
}

static LISP get_geometry(void)
{
	int x, y;
        unsigned int width, height, border_width, depth;
        LISP result;
	window *w = w_list;

	x = 0;
	y = 0;
	width = 80;
	height = w->max_y*20;
	border_width = 1;
	depth = 8;

	result = cons(flocons(depth), NIL);
        result = cons(flocons(border_width), result);
        result = cons(flocons(height), result);
        result = cons(flocons(width), result);
        result = cons(flocons(y), result);
        result = cons(flocons(x), result);

        return result;
}

static LISP set_block()
{
        if (get_point(w_list).row < get_mark(w_list).row) {
                set_blku_row(w_list, get_point(w_list).row);
                set_blkl_row(w_list, get_mark(w_list).row);
        } else {
                set_blku_row(w_list, get_mark(w_list).row);
                set_blkl_row(w_list, get_point(w_list).row);
        }
        if (get_point(w_list).col < get_mark(w_list).col) {
                set_blku_col(w_list, get_point(w_list).col);
                set_blkl_col(w_list, get_mark(w_list).col);
        } else {
                set_blku_col(w_list, get_mark(w_list).col);
                set_blkl_col(w_list, get_point(w_list).col);
        }

        pr_scr_flag = TRUE;
        return NIL;
}

static LISP unset_block()
{
        set_blku_row(w_list, -1); set_blku_col(w_list, -1);
        set_blkl_row(w_list, -1); set_blkl_col(w_list, -1);
        pr_scr_flag = TRUE;
        return NIL;
}

/* this one overrides the one in siag/cmds.c */
static LISP execute_extended_command()
{
  char b[256];

  b[0] = '\0';
  if (ask_for_str("M-x ", b)) execute(b);
  return NIL;
}

static LISP invoke_shell()
{
  move(LINES-1, 0);
  standend();
  clrtoeol();
  refresh();
  standend();

  system("/bin/sh");              /* invoke shell */
  
  clear();
  refresh();
  pr_scr_flag = TRUE;
  return NIL;
}

static LISP bogus()
{
TRACEME((f,"bogus()"));
	return NIL;
}

void interp_startup()
{
	init_subr_0("get-geometry", get_geometry);
	init_subr_0("set-block", set_block);
	init_subr_0("unset-block", unset_block);
	
	init_subr_0("execute-extended-command", execute_extended_command);
	init_subr_0("invoke-shell", invoke_shell);
	init_subr_3("add-menu-entry", bogus);
	init_subr_1("helptext-mode", bogus);
}

void embed_load()
{
	;
}

int font_input(int *format, int *mask)
{
	return 0;	/* ABORT */
}

/* Dummy Postscript functions */
char *ps_fontname(int index)
{
        return "Helvetica";
}

int ps_text_width(int index, char *s)
{
        return 80;
}

int ps_font_descent(int index)
{
        return 5;
}

int ps_font_height(long font)
{
        return 10;
}

int ps_embed_print(FILE *fp, char *tag, int x_base, int y_base)
{
        return 0;
}

int ps_font_size(int index)
{
	return 10;
}

