/*								-*- C++ -*-
 * $Id: WIN_canvas.h,v 1.1 1996-09-25 11:06:45+02 mho Exp $
 *
 * Purpose: canvas panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Canvas_h
#define Canvas_h

#ifdef __GNUG__
#pragma interface
#endif

class wxColourMap;
class wxCommandEvent;
class wxCursor;
class wxKeyEvent;
class wxMouseEvent;
class wxPanel;

class wxCanvas : public wxItem {
DECLARE_DYNAMIC_CLASS(wxCanvas)
public:
    wxCanvas(void); 
    wxCanvas(wxWindow *parent,
	    int x=-1, int y=-1, int width=-1, int height=-1,
	    int style=0, Constdata char *name=wxCanvasNameStr);

    Bool Create(wxWindow *parent,
		int x=-1, int y=-1, int width=-1, int height=-1,
		int style=0, Constdata char *name=wxCanvasNameStr);

    void EnableScrolling(Bool x, Bool y);
    int  GetScrollPage(int orient);
    void GetScrollPixelsPerUnit(int *x_units, int *y_units);
    void GetScrollUnitsPerPage(int *x, int *y);
    void GetVirtualSize(int *x, int *y);
    Bool IsRetained(void);
    void Scroll(int x_pos, int y_pos);
    void SetScrollbars(int h_pixels, int v_pixels, int x_len, int y_len,
		       int x_page, int y_page, int x_pos=0, int y_pos=0,
		       Bool setVirtualSize = TRUE);
    void SetScrollPage(int orient, int range);
    void SetVirtualSize(int hsize, int vsize);
    void ViewStart(int *x, int *y);
    void WarpPointer(int x, int y);
    // override parent methods
    void GetClientSize(int *width, int *height);
    void SetClientSize(int x, int y, int width, int height);
    void SetSize(int x, int y, int width, int height, int flags=wxSIZE_AUTO);
    // allow shorter access
    void SetClientSize(int width, int height) { SetClientSize(-1, -1, width, height); }
    void SetSize(int width, int height) { SetSize(-1, -1, width, height, wxSIZE_USE_EXISTING); }
    // overriden callback methods
    virtual void OnChar(wxKeyEvent &event);
    virtual void OnScroll(wxCommandEvent& event);
private:
    #ifdef Have_Xt_Types
    static void ResizeProc(Widget w, wxCanvas *can, XRectangle* bounds);
    #endif

    int  hstart, hsize, vphsize, hunits, hpage; Bool hscroll;
    int  vstart, vsize, vpvsize, vunits, vpage; Bool vscroll;
    Bool quoted;
};

#endif // Canvas_h
