/*								-*- C++ -*-
 * $Id: GDI_pen+brush.h,v 1.1 1996-09-25 11:06:19+02 mho Exp $
 *
 * Purpose: pen and brush classes needed for drawing
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef PenBrush_h
#define PenBrush_h

#ifdef __GNUG__
#pragma interface
#endif

class wxBitmap;
class wxBrushRep;
class wxPenRep;

typedef unsigned char wxDash;

class wxBrush : public wxObject { // brush representation
DECLARE_DYNAMIC_CLASS(wxBrush)
public:
    wxBrush(void);
    wxBrush(wxBrush& new_brush);
    wxBrush(wxColour& col, int style);
    wxBrush(const char *col, int style);
    ~wxBrush(void);

    wxBrush& operator = (wxBrush& new_brush);
    void     operator = (wxBrush* new_brush);

    wxColour&  GetColour(void);
    wxBitmap   *GetStipple(void);
    int        GetStyle(void);

    void SetColour(wxColour& col);
    void SetColour(const char *col);
    void SetColour(char r, char g, char b);
    void SetStipple(wxBitmap *s);
    void SetStyle(int s);
private:
    wxBrushRep* rep;
};

class wxPen : public wxObject { // pen representation
DECLARE_DYNAMIC_CLASS(wxPen)
public:
    wxPen(void);
    wxPen(wxPen& new_pen);
    wxPen(wxColour& col, int width, int style);
    wxPen(const char *col, int width, int style);
    ~wxPen(void);

    wxPen& operator = (wxPen& new_pen);
    void   operator = (wxPen* new_pen);

    int       GetCap(void);
    wxColour& GetColour(void);
    int       GetDashes(wxDash **p);
    int       GetJoin(void);
    wxBitmap  *GetStipple(void);
    int       GetStyle(void);
    int       GetWidth(void);

    void SetCap(int c);
    void SetColour(wxColour& col);
    void SetColour(const char *col);
    void SetColour(char r, char g, char b);
    void SetDashes(int n, wxDash *d);
    void SetJoin(int j);
    void SetStipple(wxBitmap *s);
    void SetStyle(int s);
    void SetWidth(int w);
private:
    wxPenRep* rep;
};

class wxBrushList : public wxList {
DECLARE_DYNAMIC_CLASS(wxBrushList)
public:
    wxBrushList(void);
    ~wxBrushList(void);

    void  AddBrush(wxBrush *Brush)     { Append (Brush); } 
    void  RemoveBrush(wxBrush *Brush)  { DeleteObject (Brush); }
    wxBrush *FindOrCreateBrush(wxColour *colour, int style);
    wxBrush *FindOrCreateBrush(char *colour, int style);
};

class wxPenList : public wxList {
DECLARE_DYNAMIC_CLASS(wxPenList)
public:
    wxPenList(void);
    ~wxPenList(void);

    void  AddPen(wxPen *pen)     { Append (pen); } 
    void  RemovePen(wxPen *pen)  { DeleteObject (pen); }
    wxPen *FindOrCreatePen(wxColour *colour, int width, int style);
    wxPen *FindOrCreatePen(char *colour, int width, int style);
};

#endif // PenBrush_h
