/*								-*- C++ -*-
 * $Id: APP_global.h,v 1.2 1997-01-30 09:55:21+01 mho Exp $
 *
 * Purpose: global data for an application (UNSHARED)
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef GlobalData_h
#define GlobalData_h

#ifdef __GNUG__
#pragma interface
#endif

class wxApp;
class wxBrush;
class wxBrushList;
class wxColour;
class wxColourDatabase;
class wxColourMap;
class wxCursor;
class wxFont;
class wxFontList;
class wxFontNameDirectory;
class wxGDIList;
class wxIcon;
class wxList;
class wxPen;
class wxPenList;
class wxPrintPaperDatabase;
class wxPrintSetupData;
class wxTypeTree;
class wxWindow;

//-- Application --------------------------------------------------------------

extern wxApp* wxTheApp;

extern char* wxAPP_CLASS;
extern char* wxAPP_NAME;
extern Bool  wxAPP_DEBUGOUTPUT;
extern Bool  wxAPP_DEBUGEVENTS;
extern int   wxAPP_PRINTMODE;
extern char* wxAPP_GEOMETRY;
extern Bool  wxAPP_ICONIC;

extern wxColourMap* wxAPP_COLOURMAP;
extern wxWindow*    wxAPP_ACTIVE_WINDOW;

#if defined (Uses_XtIntrinsic) || defined (Uses_XtIntrinsicP)
extern Widget	    wxAPP_TOPLEVEL;
extern XtAppContext wxAPP_CONTEXT;
#endif

#if defined (Uses_XtIntrinsic) || defined (Uses_XtIntrinsicP) || defined (Uses_XLib)
extern Display*	wxAPP_DISPLAY;
extern Screen*	wxAPP_SCREEN;
extern Window   wxAPP_ROOT;
extern Cursor   wxAPP_FALLBACK_CURSOR;
extern Pixmap   wxAPP_FALLBACK_PIXMAP;
inline Display* wxGetDisplay(void) { return wxAPP_DISPLAY; }
#endif

//-- DialogBox ----------------------------------------------------------------

// A stack of modal_showing flags, since we can't rely
// on accessing wxDialogBox::modal_showing within
// wxDialogBox::Show in case a callback has deleted the wxDialogBox.
extern wxList wxModalShowingStack;
extern wxList wxModalFrames;

//-- Events --------------------------------------------------------------------

extern wxList wxEventClassList;
extern wxList wxEventNameList;
extern wxList wxPrimaryEventHandlerList;
extern wxList wxPreEventHandlerList;
extern wxList wxPostEventHandlerList;

//-- Frame --------------------------------------------------------------------

extern wxList wxTopLevelFrames;

//-- GDI collections ----------------------------------------------------------

extern wxColourDatabase*    wxTheColourDatabase;
extern wxPenList*	    wxThePenList;
extern wxBrushList*	    wxTheBrushList;
extern wxFontList*	    wxTheFontList;
extern wxGDIList*	    wxTheBitmapList;
extern wxFontNameDirectory* wxTheFontNameDirectory;

//-- IPC ----------------------------------------------------------------------

#if USE_IPC
extern Bool  wxIPCInitialized;
extern char* wxDefaultIPCBuffer;
extern int   wxDefaultIPCBufferSize;
#endif

//-- misc ---------------------------------------------------------------------

extern char* wxBuffer;
extern int   wxBufferSize; // size of wxBuffer-1 (space for terminating '\0')
extern int   wxCursorBusy;

//-- Printing -----------------------------------------------------------------

extern wxPrintPaperDatabase* wxThePrintPaperDatabase;
extern wxPrintSetupData*     wxThePrintSetupData;

//-- Prolog IO ----------------------------------------------------------------

#if USE_PROLOGIO
// Error handler function definition. If app returns TRUE,
// carry on processing.
typedef Bool (*proioErrorHandler) (int errorType, char *msg);
extern proioErrorHandler currentProioErrorHandler;
// Temporary variable for communicating between read.cpp and YACC/LEX
class PrologDatabase;
extern PrologDatabase* hyPrologDatabase;
#endif

//-- Resources ----------------------------------------------------------------

#if USE_RESOURCES
#if defined (Uses_XtIntrinsic) || defined (Uses_XtIntrinsicP) || defined (Uses_XLib)
extern XrmDatabase wxResourceDatabase;
#endif
extern wxList wxResourceCache;
#endif

//-- RPC ----------------------------------------------------------------------

#if USE_RPC
class PrologDatabase;
extern PrologDatabase *rpcPrologDatabase;
#endif

//-- simple language support---------------------------------------------------

extern char **wx_msg_str;

//-- stock objects ------------------------------------------------------------

extern wxFont* wxNORMAL_FONT;
extern wxFont* wxSMALL_FONT;
extern wxFont* wxITALIC_FONT;
extern wxFont* wxSWISS_FONT;
extern wxFont* wxLABEL_FONT;
			
extern wxPen* wxRED_PEN;
extern wxPen* wxCYAN_PEN;
extern wxPen* wxGREEN_PEN;
extern wxPen* wxBLACK_PEN;
extern wxPen* wxWHITE_PEN;
extern wxPen* wxTRANSPARENT_PEN;
extern wxPen* wxBLACK_DASHED_PEN;
extern wxPen* wxGREY_PEN;
extern wxPen* wxMEDIUM_GREY_PEN;
extern wxPen* wxLIGHT_GREY_PEN;
			
extern wxBrush* wxBLUE_BRUSH;
extern wxBrush* wxGREEN_BRUSH;
extern wxBrush* wxWHITE_BRUSH;
extern wxBrush* wxBLACK_BRUSH;
extern wxBrush* wxGREY_BRUSH;
extern wxBrush* wxMEDIUM_GREY_BRUSH;
extern wxBrush* wxLIGHT_GREY_BRUSH;
extern wxBrush* wxTRANSPARENT_BRUSH;
extern wxBrush* wxCYAN_BRUSH;
extern wxBrush* wxRED_BRUSH;
			
extern wxColour* wxBLACK;
extern wxColour* wxWHITE;
extern wxColour* wxGREY;
extern wxColour* wxRED;
extern wxColour* wxBLUE;
extern wxColour* wxGREEN;
extern wxColour* wxCYAN;
extern wxColour* wxLIGHT_GREY;

extern wxCursor* wxSTANDARD_CURSOR;
extern wxCursor* wxHOURGLASS_CURSOR;
extern wxCursor* wxCROSS_CURSOR;
extern wxCursor* wxMOVE_CURSOR;

extern wxIcon* wxDLG_ERROR_ICON;
extern wxIcon* wxDLG_INFO_ICON;
extern wxIcon* wxDLG_NOENTER_ICON;
extern wxIcon* wxDLG_QUESTION_ICON;
extern wxIcon* wxDLG_WARNING_ICON;

//-- Types --------------------------------------------------------------------

#if USE_TYPETREE
extern wxTypeTree wxAllTypes;
#endif

//-- default window names -----------------------------------------------------

extern Constdata char *wxButtonNameStr;
extern Constdata char *wxCanvasNameStr;
extern Constdata char *wxCheckBoxNameStr;
extern Constdata char *wxChoiceNameStr;
extern Constdata char *wxDialogNameStr;
extern Constdata char *wxFrameNameStr;
extern Constdata char *wxGaugeNameStr;
extern Constdata char *wxGroupBoxNameStr;
extern Constdata char *wxListBoxNameStr;
extern Constdata char *wxMessageNameStr;
extern Constdata char *wxMultiTextNameStr;
extern Constdata char *wxPanelNameStr;
extern Constdata char *wxRadioBoxNameStr;
extern Constdata char *wxScrollBarNameStr;
extern Constdata char *wxSliderNameStr;
extern Constdata char *wxStaticNameStr;
extern Constdata char *wxTextWindowNameStr;
extern Constdata char *wxTextNameStr;
extern Constdata char *wxVirtListBoxNameStr;
extern Constdata char *wxButtonBarNameStr;
extern Constdata char *wxEnhDialogNameStr;
extern Constdata char *wxToolBarNameStr;
extern Constdata char *wxStatusLineNameStr;
extern Constdata char *wxEmptyString;
extern Constdata char *wxInternalErrorStr;
extern Constdata char *wxFatalErrorStr;
extern Constdata char *wxGetTextFromUserPromptStr;
extern Constdata char *wxGetSingleChoiceStr;
extern Constdata char *wxGetMultipleChoiceStr;
extern Constdata char *wxMessageBoxCaptionStr;
extern Constdata char *wxFileSelectorPromptStr;
extern Constdata char *wxFileSelectorDefaultWildcardStr;

#endif // GlobalData_h
