/*								-*- C++ -*-
 * $Id: WIN_message.cpp,v 1.3 1997-01-30 09:56:05+01 mho Exp $
 *
 * Purpose: message panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifdef __GNUG__
#pragma implementation "WIN_message.h"
#endif

#define  Uses_XtIntrinsic
#define  Uses_wxMessage
#include "wx.h"
#define  Uses_EnforcerWidget
#define  Uses_LabelWidget
#include <widgets.h>

//-----------------------------------------------------------------------------
// create and destroy message
//-----------------------------------------------------------------------------

IMPLEMENT_DYNAMIC_CLASS(wxMessage, wxItem)

/*
 * wxMessage()
 */

wxMessage::wxMessage(void) : wxItem()
{
    __type = wxTYPE_MESSAGE;

    isBitmap = FALSE;
}

/*
 * wxMessage with label
 */

wxMessage::wxMessage(wxPanel *panel, Const char *message,
		   int x, int y, long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_MESSAGE;
    Create(panel, message, x, y, -1, -1, style, name);
}

wxMessage::wxMessage(wxPanel *panel, Const char *message, int x, int y,
		     int width, int height, long style, Constdata char* name)
    : wxItem()
{
    __type = wxTYPE_MESSAGE;
    Create(panel, message, x, y, width, height, style, name);
}

Bool wxMessage::Create(wxPanel *panel, Const char *message,
		       int x, int y, int width, int height, long style,
		       Constdata char *name)
{
    ChainToPanel(panel, style, name);

    if (style & wxUSE_BUTTON_FONT)
	label_font = font;

    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfLabelWidgetClass, GetParentWidget(panel),
	 XtNlabel,              message,
	 XtNbackground,         bg.GetPixel(&cmap),
	 XtNforeground,         label_fg.GetPixel(&cmap),
	 XtNfont,               label_font.GetInternalFont(),
	 XtNinnerVOffset,       ((style & wxNO_BORDER) ? 0 : 6),
	 XtNalignment,          wxALIGN_LEFT,
	 XtNshrinkToFit,        TRUE,
	 XtNhighlightThickness, 0,
	 ( !(style & wxBORDER) ) ?
	     NULL :
	     XtNouterOffset, 2, XtNinnerHOffset, 1, XtNinnerVOffset, 1,
	     XtNframeWidth,  2, XtNframeType, XfwfSunken,
	     NULL);

    if (width > 0)
	AllowResize(FALSE);
    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();

    isBitmap = FALSE;
    return TRUE;
}

/*
 * wxMessage with bitmap
 */

wxMessage::wxMessage(wxPanel *panel, wxBitmap *bitmap,
		   int x, int y, long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_MESSAGE;
    Create(panel, bitmap, x, y,-1,-1, style, name);
}

wxMessage::wxMessage(wxPanel *panel, wxBitmap& bitmap,
		   int x, int y, long style, Constdata char *name) : wxItem()
{
    __type = wxTYPE_MESSAGE;
    Create(panel, bitmap, x, y,-1,-1, style, name);
}

wxMessage::wxMessage(wxPanel *panel, wxBitmap *bitmap,
		     int x, int y,int w, int h, long style,
		     Constdata char *name) : wxItem()
{
    __type = wxTYPE_MESSAGE;
    Create(panel, bitmap, x, y,w,h, style, name);
}

Bool wxMessage::Create(wxPanel *panel, wxBitmap *bitmap,
		      int x, int y, int width, int height, long style,
		       Constdata char *name)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxMessage::Create");
	return Create(panel, "ERROR", x, y,width, height, style, name);
    } 
    return Create(panel, *bitmap, x, y,width, height, style, name);
}

Bool wxMessage::Create(wxPanel *panel, wxBitmap& bitmap,
		       int x, int y, int width, int height, long style,
		       Constdata char *name)
{
    ChainToPanel(panel, style, name);

    if (style & wxUSE_BUTTON_FONT)
	label_font = font;

    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxMessage::Create");
	return Create(panel, "ERROR", x, y,width, height, style, name);
    }
    bmp = bitmap;
    // create widget
    HWidget() = FWidget() = XtVaCreateManagedWidget
	(name, xfwfLabelWidgetClass, GetParentWidget(panel),
	 XtNpixmap,      bitmap.GetPixmap(),
	 XtNmask,        bitmap.GetMask(),
	 XtNbackground,  bg.GetPixel(&cmap),
	 XtNforeground,  label_fg.GetPixel(&cmap),
	 XtNfont,        label_font.GetInternalFont(),
	 XtNalignment,   wxALIGN_LEFT,
	 XtNshrinkToFit, TRUE,
	 XtNhighlightThickness, 0,
	 ( !(style & wxBORDER) ) ?
	     NULL :
	     XtNouterOffset, 2, XtNinnerHOffset, 1, XtNinnerVOffset, 1,
	     XtNframeWidth,  2, XtNframeType, XfwfSunken,
	     NULL);

    panel->PositionItem(this, x, y, width, height);
    AddEventHandlers();

    isBitmap = TRUE;
    return TRUE;
}

//-----------------------------------------------------------------------------
// alternate SetLabel for changing bitmap
//-----------------------------------------------------------------------------

void wxMessage::AllowResize(Bool allow)
{
    XtVaSetValues(HWidget(), XtNshrinkToFit, allow, NULL);
}

void wxMessage::SetAlignment(long alignment)
{
    XtVaSetValues(HWidget(), XtNalignment, alignment, NULL);
}

void wxMessage::SetLabel(char *message)
{
    isBitmap = FALSE;
    Boolean shrink; XtVaGetValues(HWidget(), XtNshrinkToFit, &shrink, NULL);

    if (shrink)
	XtVaSetValues(HWidget(), XtNlabel, message, NULL);
    else
	XfwfSetLabel(HWidget(), message);
}

void wxMessage::SetLabel(wxBitmap *bitmap)
{
    if (!bitmap) {
	wxError("NULL bitmap specified", "wxMessage::SetLabel");
	SetLabel("ERROR");
    } else
	SetLabel(*bitmap);
}

void wxMessage::SetLabel(wxBitmap& bitmap)
{
    if (!bitmap.Ok()) {
	wxError("uninitialized bitmap specified", "wxMessage::SetLabel");
	SetLabel("ERROR");
    } else {
	bmp = bitmap;
	if (bmp.GetDepth() == 1 || bmp.GetDepth() == wxDisplayDepth())
	    XtVaSetValues(HWidget(),
			  XtNlabel,  NULL,
			  XtNpixmap, bitmap.GetPixmap(),
			  XtNmask,   bitmap.GetMask(),
			  NULL);
    }
    isBitmap = TRUE;
}

void wxMessage::SetLabelFont(wxFont *new_font)
{
    SetFont(new_font);
    label_font=new_font;
}


