/*								-*- C++ -*-
 * $Id: UTL_directory.cpp,v 1.2 1996-11-19 13:30:36+01 mho Exp $
 *
 * Purpose: basic file and directory handling
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#include "wx.h"

#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>

Bool wxConcatFiles(const char *src1, const char *src2, const char *dest)
{
    char *outfile = wxGetTempFileName("cat");

    FILE *f1, *f2, *fd;
    int ch;

    if (!(f1 = fopen(src1, "rb"))) {
	return FALSE;
    } else if (!(f2 = fopen(src2, "rb"))) {
	fclose(f1); return FALSE;
    } else if (!(fd = fopen(outfile, "wb"))) {
	fclose(f1); fclose(f2); return FALSE;
    }

    while ((ch = getc (f1)) != EOF)
	putc (ch, fd);
    while ((ch = getc (f2)) != EOF)
	putc (ch, fd);

    fclose (f1); fclose (f2); fclose (fd);

    Bool result = wxRenameFile(outfile, dest);
    delete[] outfile;
    return result;
}

Bool wxCopyFile(const char *src, const char *dest)
{
    FILE *fs, *fd;
    int ch;

    if (!(fs = fopen(src, "rb"))) {
	return FALSE;
    } else if (!(fd = fopen(dest, "wb"))) {
	fclose(fs); return FALSE;
    }

    while ((ch = getc (fs)) != EOF)
	putc (ch, fd);

    fclose (fs); fclose (fd);

    return TRUE;
}

Bool wxDirExists(const char *dir)
{
    struct stat sbuf;
    return ((stat(dir, &sbuf) != -1) && S_ISDIR(sbuf.st_mode) ? TRUE : FALSE);
}

char *wxGetWorkingDirectory(char *buf, int sz)
{
    if (!buf)
	buf = wxNEW char[sz+1];
    if (getcwd(buf, sz) == NULL) {
	buf[0] = '.';
	buf[1] = '\0';
    }
    return buf;
}

Bool wxMkdir(const char *dir)
{
    return (mkdir(dir,S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IXGRP|S_IROTH|S_IXOTH)
	    == 0);
}

Bool wxFileExists(const char *filename)
{
    struct stat stbuf;

    return (filename && stat((char *)filename, &stbuf) == 0);
}

Bool wxRemoveFile(const char *file)
{
    return Bool((unlink(file) == 0));
}

Bool wxRenameFile(const char *file1, const char *file2)
{
    if (0 == rename(file1, file2))
	return TRUE;
    // Try to copy (renaming may not be allowed across file systems)
    if (wxCopyFile(file1, file2)) {
	wxRemoveFile(file1);
	return TRUE;
    }
    // Give up
    return FALSE;
}

Bool wxRmdir(const char *dir)
{
    return (rmdir(dir) == 0);
}

Bool wxSetWorkingDirectory(char *dir)
{
    return (chdir(dir) == 0);
}
