/**
 *
 * $Id: DragIcon.c,v 1.7 1997/08/19 19:29:02 miers Exp $
 *
 * Copyright (C) 1995 Free Software Foundation, Inc.
 *
 * This file is part of the GNU LessTif Library.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **/

static char rcsid[] = "$Id: DragIcon.c,v 1.7 1997/08/19 19:29:02 miers Exp $";

#include <LTconfig.h>
#include <XmI/XmI.h>

#include <Xm/XmP.h>
#include <Xm/DragDrop.h>
#include <Xm/DragIconP.h>
#include <Xm/ScreenP.h>

#include <XmI/DebugUtil.h>

static void class_initialize();

static void class_part_initialize(WidgetClass w_class);

static void initialize(Widget request, Widget new_w,
		       ArgList args, Cardinal *num_args);

static void destroy(Widget w);

static Boolean set_values(Widget current, Widget request, Widget new_w,
			  ArgList args, Cardinal *num_args);


/*
 * Resources for the DragIcon class
 */
#define Offset(field) XtOffsetOf(XmDragIconRec, drag.field)
static XtResource resources[] =
{
    {
	XmNdepth, XmCDepth, XmRInt,
	sizeof(Cardinal), Offset(depth),
	XmRImmediate, (XtPointer)1
    },
    {
	XmNwidth, XmCWidth, XmRDimension,
	sizeof(Dimension), Offset(width),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNheight, XmCHeight, XmRDimension,
	sizeof(Dimension), Offset(height),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNhotX, XmCHot, XmRPosition,
	sizeof(Position), Offset(hot_x),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNhotY, XmCHot, XmRPosition,
	sizeof(Position), Offset(hot_y),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNmask, XmCPixmap, XmRBitmap,
	sizeof(Pixmap), Offset(mask),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNpixmap, XmCPixmap, XmRBitmap,
	sizeof(Pixmap), Offset(pixmap),
	XmRImmediate, (XtPointer)XmUNSPECIFIED_PIXMAP
    },
    {
	XmNoffsetX, XmCOffset, XmRPosition,
	sizeof(Position), Offset(offset_x),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNoffsetY, XmCOffset, XmRPosition,
	sizeof(Position), Offset(offset_y),
	XmRImmediate, (XtPointer)0
    },
    {
	XmNattachment, XmCAttachment, XmRIconAttachment,
	sizeof(unsigned char), Offset(attachment),
	XmRImmediate, (XtPointer)XmATTACH_NORTH_WEST
    }
};
/* *INDENT-OFF* */
static XmBaseClassExtRec _XmDragIconRectClassExtRec = {
    /* next_extension            */ NULL,
    /* record_type               */ NULLQUARK,                             
    /* version                   */ XmBaseClassExtVersion,
    /* size                      */ sizeof(XmBaseClassExtRec),
    /* initialize_prehook        */ NULL,
    /* set_values_prehook        */ NULL,
    /* initialize_posthook       */ NULL,
    /* set_values_posthook       */ NULL,
    /* secondary_object_class    */ NULL,
    /* secondary_object_create   */ NULL,
    /* get_secondary_resources   */ NULL,
    /* fast_subclass             */ { 0 },
    /* get_values_prehook        */ NULL,
    /* get_values_posthook       */ NULL,
    /* class_part_init_prehook   */ NULL,
    /* class_part_init_posthook  */ NULL,
    /* ext_resources             */ NULL,
    /* compiled_ext_resources    */ NULL,
    /* num_ext_resources         */ 0,
    /* use_sub_resources         */ False,
    /* widget_navigable          */ NULL,
    /* focus_change              */ NULL,
    /* wrapper_data              */ NULL
};

XmDragIconClassRec xmDragIconClassRec = {
    /* RectObj class part */
    {
       /* superclass            */ (WidgetClass)&objectClassRec,
       /* class_name            */ "XmDragIcon",
       /* widget_size           */ sizeof(XmDragIconRec),
       /* class_initialize      */ class_initialize,
       /* class_part_initialize */ class_part_initialize,
       /* class_inited          */ False,
       /* initialize            */ initialize,
       /* initialize_hook       */ NULL,
       /* rect1                 */ NULL,
       /* rect2                 */ NULL,
       /* rect3                 */ 0,
       /* resources             */ resources,
       /* num_resources         */ XtNumber(resources),
       /* xrm_class             */ NULLQUARK,
       /* rect4                 */ 0,
       /* rect5                 */ 0,
       /* rect6                 */ 0,
       /* rect7                 */ 0,
       /* destroy               */ destroy,
       /* resize                */ NULL,
       /* expose                */ NULL,
       /* set_values            */ set_values,
       /* set_values_hook       */ NULL,
       /* set_values_almost     */ XtInheritSetValuesAlmost,
       /* get_values_hook       */ NULL,
       /* rect9                 */ NULL,
       /* version               */ XtVersion,
       /* callback offsets      */ NULL,
       /* rect10                */ NULL,
       /* query_geometry        */ NULL,
       /* rect11                */ NULL,
       /* extension             */ NULL
    },
    /* XmDragIcon part */
    {
        /* extension          */ NULL
    }
};
/* *INDENT-ON* */


WidgetClass xmDragIconObjectClass = (WidgetClass)&xmDragIconClassRec;

#define state16_width 16
#define state16_height 16
static unsigned char state16_bits[] =
{
    0x00, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x0e, 0x00, 0x06, 0x00, 0x02, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define state16_mask_width 16
#define state16_mask_height 16
static unsigned char state16_mask_bits[] =
{
    0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x0f, 0x00,
    0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define move16_width 16
#define move16_height 16
static unsigned char move16_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x07, 0x40, 0x0c,
    0x40, 0x1c, 0x40, 0x3c, 0x40, 0x20, 0x40, 0x20, 0x40, 0x20, 0x40, 0x20,
    0x40, 0x20, 0x40, 0x20, 0xc0, 0x3f, 0x00, 0x00};

#define move16_mask_width 16
#define move16_mask_height 16
static unsigned char move16_mask_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xe0, 0x0f, 0xe0, 0x1f, 0xe0, 0x3f,
    0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f,
    0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f};

#define copy16_width 16
#define copy16_height 16
static unsigned char copy16_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x80, 0x18, 0x80, 0x38, 0xb0, 0x78,
    0x90, 0x40, 0x90, 0x40, 0x90, 0x40, 0x90, 0x40, 0x90, 0x40, 0x90, 0x7f,
    0x10, 0x00, 0x10, 0x08, 0xf0, 0x0f, 0x00, 0x00};

#define copy16_mask_width 16
#define copy16_mask_height 16
static unsigned char copy16_mask_bits[] =
{
    0x00, 0x00, 0xc0, 0x1f, 0xc0, 0x3f, 0xc0, 0x7f, 0xf8, 0xff, 0xf8, 0xff,
    0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0xff,
    0xf8, 0xff, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f};

#define link16_width 16
#define link16_height 16
static unsigned char link16_bits[] =
{
    0x00, 0x00, 0x80, 0x0f, 0x80, 0x18, 0x80, 0x38, 0x80, 0x78, 0xb8, 0x40,
    0x88, 0x4e, 0x88, 0x4c, 0x08, 0x4a, 0x08, 0x41, 0xa8, 0x7c, 0x68, 0x00,
    0xe8, 0x04, 0x08, 0x04, 0xf8, 0x07, 0x00, 0x00};

#define link16_mask_width 16
#define link16_mask_height 16
static unsigned char link16_mask_bits[] =
{
    0xc0, 0x1f, 0xc0, 0x3f, 0xc0, 0x7f, 0xc0, 0xff, 0xfc, 0xff, 0xfc, 0xff,
    0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff,
    0xfc, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f, 0xfc, 0x0f};

#define source16_width 16
#define source16_height 16
static unsigned char source16_bits[] =
{
    0x00, 0x00, 0xaa, 0xca, 0x54, 0x85, 0xaa, 0xca, 0x54, 0xe0, 0x2a, 0xe3,
    0x94, 0x81, 0xea, 0xf8, 0x54, 0xd4, 0xaa, 0xac, 0x94, 0xd9, 0xca, 0xac,
    0x64, 0xd6, 0x32, 0xab, 0xa4, 0xd6, 0xfe, 0xff};

#define text16_width 16
#define text16_height 16
static unsigned char text16_bits[] =
{
    0x00, 0x00, 0xfe, 0x0f, 0x02, 0x08, 0x02, 0x08, 0xfa, 0x0b, 0x02, 0x08,
    0xfa, 0x0b, 0x02, 0x08, 0x02, 0x08, 0xfe, 0x0f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define text16_mask_width 16
#define text16_mask_height 16
static unsigned char text16_mask_bits[] =
{
    0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f,
    0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define state32_width 32
#define state32_height 28
static unsigned char state32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
    0x1e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
    0x0e, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define state32_mask_width 32
#define state32_mask_height 32
static unsigned char state32_mask_bits[] =
{
    0x0f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,
    0x7f, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00,
    0xff, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,
    0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define move32_width 32
#define move32_height 32
static unsigned char move32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0x20, 0x60, 0x00, 0x00,
    0x20, 0xe0, 0x00, 0x00, 0x20, 0xe0, 0x01, 0x00, 0x20, 0xe0, 0x03, 0x00,
    0x20, 0xe0, 0x07, 0x00, 0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00,
    0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00,
    0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00,
    0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00,
    0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define move32_mask_width 32
#define move32_mask_height 32
static unsigned char move32_mask_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x7f, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xf0, 0xff, 0x01, 0x00,
    0xf0, 0xff, 0x03, 0x00, 0xf0, 0xff, 0x07, 0x00, 0xf0, 0xff, 0x0f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x1f, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define copy32_width 32
#define copy32_height 32
static unsigned char copy32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x3f, 0x00, 0x00, 0x20, 0x60, 0x00, 0x00,
    0x20, 0xe0, 0x00, 0x00, 0x20, 0xe0, 0x01, 0x00, 0x20, 0xe0, 0x03, 0x00,
    0x20, 0xe0, 0x07, 0x00, 0x20, 0x00, 0x0c, 0x00, 0x20, 0x00, 0x0c, 0x00,
    0x20, 0x00, 0x2c, 0x00, 0x20, 0x00, 0x6c, 0x00, 0x20, 0x00, 0xec, 0x00,
    0x20, 0x00, 0x8c, 0x01, 0x20, 0x00, 0x8c, 0x01, 0x20, 0x00, 0x8c, 0x01,
    0x20, 0x00, 0x8c, 0x01, 0x20, 0x00, 0x8c, 0x01, 0x20, 0x00, 0x8c, 0x01,
    0xe0, 0xff, 0x8f, 0x01, 0xc0, 0xff, 0x8f, 0x01, 0x00, 0x00, 0x80, 0x01,
    0x00, 0x04, 0x80, 0x01, 0x00, 0x04, 0x80, 0x01, 0x00, 0xfc, 0xff, 0x01,
    0x00, 0xf8, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00};

#define copy32_mask_width 32
#define copy32_mask_height 32
static unsigned char copy32_mask_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x7f, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00, 0xf0, 0xff, 0x01, 0x00,
    0xf0, 0xff, 0x03, 0x00, 0xf0, 0xff, 0x07, 0x00, 0xf0, 0xff, 0x0f, 0x00,
    0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x1f, 0x00, 0xf0, 0xff, 0x7f, 0x00,
    0xf0, 0xff, 0xff, 0x00, 0xf0, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x03,
    0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x03,
    0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x03,
    0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x03, 0xe0, 0xff, 0xff, 0x03,
    0x00, 0xfe, 0xff, 0x03, 0x00, 0xfe, 0xff, 0x03, 0x00, 0xfe, 0xff, 0x03,
    0x00, 0xfe, 0xff, 0x03, 0x00, 0xfc, 0xff, 0x03};

#define link32_width 32
#define link32_height 32
static unsigned char link32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0xe0, 0x1f, 0x00, 0x00, 0x20, 0x30, 0x00, 0x00,
    0x20, 0x70, 0x00, 0x00, 0x20, 0xf0, 0x00, 0x00, 0x20, 0xf0, 0x01, 0x00,
    0x20, 0x00, 0x7b, 0x00, 0x20, 0x00, 0xc3, 0x00, 0x20, 0x04, 0xc3, 0x01,
    0x20, 0x06, 0xc3, 0x03, 0x20, 0x0f, 0xc2, 0x07, 0x20, 0x36, 0x00, 0x0c,
    0x20, 0xc4, 0x00, 0x0c, 0x20, 0x00, 0x23, 0x0c, 0x20, 0x00, 0x6c, 0x0c,
    0x20, 0x00, 0xf0, 0x0c, 0xe0, 0xff, 0x61, 0x0c, 0xc0, 0xff, 0x23, 0x0c,
    0x00, 0x00, 0x00, 0x0c, 0x00, 0x80, 0x00, 0x0c, 0x00, 0x80, 0x00, 0x0c,
    0x00, 0x80, 0xff, 0x0f, 0x00, 0x00, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define link32_mask_width 32
#define link32_mask_height 32
static unsigned char link32_mask_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0xf0, 0x3f, 0x00, 0x00, 0xf0, 0x7f, 0x00, 0x00, 0xf0, 0xff, 0x00, 0x00,
    0xf0, 0xff, 0x01, 0x00, 0xf0, 0xff, 0x03, 0x00, 0xf0, 0xff, 0xff, 0x00,
    0xf0, 0xff, 0xff, 0x01, 0xf0, 0xff, 0xff, 0x03, 0xf0, 0xff, 0xff, 0x07,
    0xf0, 0xff, 0xff, 0x0f, 0xf0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x1f,
    0xf0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x1f,
    0xf0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x1f, 0xf0, 0xff, 0xff, 0x1f,
    0xe0, 0xff, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x1f,
    0x00, 0xc0, 0xff, 0x1f, 0x00, 0xc0, 0xff, 0x1f, 0x00, 0x80, 0xff, 0x1f,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define source32_width 32
#define source32_height 32
static unsigned char source32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x54, 0x55, 0x55, 0xd5,
    0xa8, 0xaa, 0xaa, 0xea, 0x54, 0x55, 0x55, 0xd1, 0xa8, 0xaa, 0xaa, 0xe0,
    0x54, 0x55, 0x55, 0xd0, 0xa8, 0xaa, 0xaa, 0xf0, 0x54, 0x55, 0x55, 0xd9,
    0xa8, 0xaa, 0x00, 0xee, 0x54, 0x55, 0x00, 0xd6, 0xa8, 0x2a, 0x3f, 0xea,
    0x54, 0x95, 0x05, 0xd7, 0xa8, 0xea, 0x82, 0xee, 0x54, 0x45, 0xc1, 0xd5,
    0xa8, 0xaa, 0xf4, 0x81, 0x54, 0xd5, 0x78, 0xff, 0xa8, 0xaa, 0xa0, 0xea,
    0x54, 0x95, 0x41, 0xd5, 0xa8, 0x4a, 0x87, 0xea, 0x54, 0x85, 0x0d, 0xd5,
    0xa8, 0xc2, 0x9a, 0xea, 0x54, 0x61, 0x05, 0xd5, 0xa8, 0xb0, 0xc2, 0xea,
    0x54, 0x58, 0x61, 0xd5, 0x28, 0xac, 0xb0, 0xea, 0x14, 0x56, 0x58, 0xd5,
    0x08, 0xab, 0xa8, 0xea, 0x14, 0x55, 0x51, 0xd5, 0x28, 0xaa, 0xaa, 0xea,
    0xfc, 0xff, 0xff, 0xff, 0xfe, 0xff, 0xff, 0xff};

#define text32_width 32
#define text32_height 20
static unsigned char text32_bits[] =
{
    0x00, 0x00, 0x00, 0x00, 0xfe, 0xff, 0xff, 0x01, 0x02, 0x00, 0x00, 0x01,
    0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01,
    0x82, 0xff, 0x0f, 0x01, 0xc2, 0xff, 0x0f, 0x01, 0xc2, 0xff, 0x07, 0x01,
    0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01, 0x82, 0xff, 0x0f, 0x01,
    0xc2, 0xff, 0x0f, 0x01, 0xc2, 0xff, 0x07, 0x01, 0x02, 0x00, 0x00, 0x01,
    0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01, 0x02, 0x00, 0x00, 0x01,
    0xfe, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x00};

#define text32_mask_width 32
#define text32_mask_height 20
static unsigned char text32_mask_bits[] =
{
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03,
    0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 0xff, 0x03};

/*
 * standardize building for the standard op/state/source pixmaps
 */
typedef struct
{
    int width, height;
    int hot_x, hot_y;
    int offset_x, offset_y;
    char *pix_name;
    unsigned char *data;
    char *mask_name;
    unsigned char *mask_data;
}
XmCursorDataRec;

static XmCursorDataRec state16CursorDataRec =
{
    state16_width, state16_height,
    1, 1, -8, -2,
    "state16", state16_bits,
    "state16_mask", state16_mask_bits
};

static XmCursorDataRec move16CursorDataRec =
{
    move16_width, move16_height,
    1, 1, -8, -2,
    "move16", move16_bits,
    "move16_mask", move16_mask_bits
};

static XmCursorDataRec copy16CursorDataRec =
{
    copy16_width, copy16_height,
    1, 1, -8, -2,
    "copy16", copy16_bits,
    "copy16_mask", copy16_mask_bits
};

static XmCursorDataRec link16CursorDataRec =
{
    link16_width, link16_height,
    1, 1, -8, -2,
    "link16", link16_bits,
    "link16_mask", link16_mask_bits
};

static XmCursorDataRec source16CursorDataRec =
{
    source16_width, source16_height,
    0, 0, 0, 0,
    "source16", source16_bits,
    NULL, NULL
};

static XmCursorDataRec text16CursorDataRec =
{
    text16_width, text16_height,
    2, 2, 0, 0,
    "text16", text16_bits,
    "text16_mask", text16_mask_bits
};

static XmCursorDataRec state32CursorDataRec =
{
    state32_width, state32_height,
    1, 1, -16, -4,
    "state32", state32_bits,
    "state32_mask", state32_mask_bits
};

static XmCursorDataRec move32CursorDataRec =
{
    move32_width, move32_height,
    1, 1, -16, -4,
    "move32", move32_bits,
    "move32_mask", move32_mask_bits
};

static XmCursorDataRec copy32CursorDataRec =
{
    move32_width, move32_height,
    1, 1, -16, -4,
    "copy32", copy32_bits,
    "copy32_mask", copy32_mask_bits
};

static XmCursorDataRec link32CursorDataRec =
{
    link32_width, link32_height,
    1, 1, -16, -4,
    "link32", link32_bits,
    "link32_mask", link32_mask_bits
};

static XmCursorDataRec source32CursorDataRec =
{
    source32_width, source32_height,
    0, 0, 0, 0,
    "source32", source32_bits,
    NULL, NULL
};

static XmCursorDataRec text32CursorDataRec =
{
    text32_width, text32_height,
    4, 4, 0, 0,
    "text32", text32_bits,
    "text32_mask", text32_mask_bits
};

/*
 * associate the quarks to the DragIcons
 */
typedef struct
{
    XrmQuark *quark;
    XmCursorDataRec *cdr;
}
XmQuarkToCursorRec;

XmQuarkToCursorRec quarkTo16CursorTable[] =
{
    {&_XmValidCursorIconQuark, &state16CursorDataRec},
    {&_XmInvalidCursorIconQuark, &state16CursorDataRec},
    {&_XmNoneCursorIconQuark, &state16CursorDataRec},
    {&_XmMoveCursorIconQuark, &move16CursorDataRec},
    {&_XmCopyCursorIconQuark, &copy16CursorDataRec},
    {&_XmLinkCursorIconQuark, &link16CursorDataRec},
    {&_XmDefaultDragIconQuark, &source16CursorDataRec},
    {NULL, &text16CursorDataRec},
};

XmQuarkToCursorRec quarkToCursorTable[] =
{
    {&_XmValidCursorIconQuark, &state32CursorDataRec},
    {&_XmInvalidCursorIconQuark, &state32CursorDataRec},
    {&_XmNoneCursorIconQuark, &state32CursorDataRec},
    {&_XmMoveCursorIconQuark, &move32CursorDataRec},
    {&_XmCopyCursorIconQuark, &copy32CursorDataRec},
    {&_XmLinkCursorIconQuark, &link32CursorDataRec},
    {&_XmDefaultDragIconQuark, &source32CursorDataRec},
    {NULL, &text32CursorDataRec}
};

static void
class_initialize()
{
    _XmDragIconRectClassExtRec.record_type = XmQmotif;
}

static void
class_part_initialize(WidgetClass widget_class)
{
    _XmFastSubclassInit(widget_class, XmDRAG_ICON_BIT);
}

static void
initialize(Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    Dimension uwidth, uheight;
    Screen *pscr;
    char *name;
    Pixel fg, bg;
    int hx, hy, depth, which;
    unsigned int width, height;
    XImage *image;

    pscr = XtScreenOfObject(XtParent(new_w));

    DI_Region(new_w) = NULL;
    DI_RestoreRegion(new_w) = NULL;

    DI_IsDirty(new_w) = False;

    if (DI_Pixmap(new_w) == XmUNSPECIFIED_PIXMAP)
    {
	_XmGetMaxCursorSize(new_w, &uwidth, &uheight);

	if (uwidth < 32 || uheight < 32)
	{
	    for (which = 0;
		 quarkTo16CursorTable[which].quark != NULL;
		 which++)
	    {
		if (ObjName(new_w) == *(quarkTo16CursorTable[which].quark))
		    break;
	    }

	    _XmCreateImage(image, XtDisplay(new_w),
			   (char *)quarkTo16CursorTable[which].cdr->data,
			   quarkTo16CursorTable[which].cdr->width,
			   quarkTo16CursorTable[which].cdr->height,
			   LSBFirst);

	    _XmInstallImage(image, quarkTo16CursorTable[which].cdr->pix_name,
			    quarkTo16CursorTable[which].cdr->hot_x,
			    quarkTo16CursorTable[which].cdr->hot_y);

	    DI_Pixmap(new_w) = _XmGetPixmap(pscr,
				     quarkTo16CursorTable[which].cdr->pix_name,
					    1,
					    1,
					    0);

	    _XmCreateImage(image, XtDisplay(new_w),
			   (char *)quarkTo16CursorTable[which].cdr->mask_data,
			   quarkTo16CursorTable[which].cdr->width,
			   quarkTo16CursorTable[which].cdr->height,
			   LSBFirst);

	    _XmInstallImage(image, quarkTo16CursorTable[which].cdr->mask_name,
			    quarkTo16CursorTable[which].cdr->hot_x,
			    quarkTo16CursorTable[which].cdr->hot_y);

	    DI_Mask(new_w) = _XmGetPixmap(pscr,
				    quarkTo16CursorTable[which].cdr->mask_name,
					  1,
					  1,
					  0);

	    DI_Width(new_w) = quarkTo16CursorTable[which].cdr->width;
	    DI_Height(new_w) = quarkTo16CursorTable[which].cdr->height;
	    DI_HotX(new_w) = quarkTo16CursorTable[which].cdr->hot_x;
	    DI_HotY(new_w) = quarkTo16CursorTable[which].cdr->hot_y;
	    DI_OffsetX(new_w) = quarkTo16CursorTable[which].cdr->offset_x;
	    DI_OffsetY(new_w) = quarkTo16CursorTable[which].cdr->offset_y;
	}
	else
	{
	    for (which = 0;
		 quarkToCursorTable[which].quark != NULL;
		 which++)
	    {
		if (ObjName(new_w) == *(quarkToCursorTable[which].quark))
		    break;
	    }

	    _XmCreateImage(image, XtDisplay(new_w),
			   (char *)quarkToCursorTable[which].cdr->data,
			   quarkToCursorTable[which].cdr->width,
			   quarkToCursorTable[which].cdr->height,
			   LSBFirst);

	    _XmInstallImage(image, quarkToCursorTable[which].cdr->pix_name,
			    quarkToCursorTable[which].cdr->hot_x,
			    quarkToCursorTable[which].cdr->hot_y);

	    DI_Pixmap(new_w) = _XmGetPixmap(pscr,
				       quarkToCursorTable[which].cdr->pix_name,
					    1,
					    1,
					    0);

	    _XmCreateImage(image, XtDisplay(new_w),
			   (char *)quarkToCursorTable[which].cdr->mask_data,
			   quarkToCursorTable[which].cdr->width,
			   quarkToCursorTable[which].cdr->height,
			   LSBFirst);

	    _XmInstallImage(image, quarkToCursorTable[which].cdr->mask_name,
			    quarkToCursorTable[which].cdr->hot_x,
			    quarkToCursorTable[which].cdr->hot_y);

	    DI_Mask(new_w) = _XmGetPixmap(pscr,
				      quarkToCursorTable[which].cdr->mask_name,
					  1,
					  1,
					  0);

	    DI_Width(new_w) = quarkToCursorTable[which].cdr->width;
	    DI_Height(new_w) = quarkToCursorTable[which].cdr->height;
	    DI_HotX(new_w) = quarkToCursorTable[which].cdr->hot_x;
	    DI_HotY(new_w) = quarkToCursorTable[which].cdr->hot_y;
	    DI_OffsetX(new_w) = quarkToCursorTable[which].cdr->offset_x;
	    DI_OffsetY(new_w) = quarkToCursorTable[which].cdr->offset_y;
	}
    }

    if (DI_Width(new_w) == 0 || DI_Height(new_w) == 0)
    {

	if (_XmGetPixmapData(pscr, DI_Pixmap(new_w), &name, &depth,
			     &fg, &bg, &hx, &hy, &width, &height))
	{
	    DI_Depth(new_w) = depth;
	    DI_HotX(new_w) = hx;
	    DI_HotY(new_w) = hy;
	    DI_Width(new_w) = width;
	    DI_Height(new_w) = height;

	}
	else
	{
	    DI_Width(new_w) = 0;
	    DI_Height(new_w) = 0;
	    DI_Pixmap(new_w) = XmUNSPECIFIED_PIXMAP;
	}
    }
}

static void
destroy(Widget w)
{
    if (DI_Region(w))
    {
	XDestroyRegion(DI_Region(w));
    }

    if (DI_RestoreRegion(w))
    {
	XDestroyRegion(DI_RestoreRegion(w));
    }

    _XmScreenRemoveFromCursorCache((XmDragIconObject)w);
}

static Boolean
set_values(Widget current, Widget request, Widget new_w,
	   ArgList args, Cardinal *num_args)
{
    Boolean refresh = False;

    if (DI_Depth(new_w) != DI_Depth(current) ||
	DI_Width(new_w) != DI_Width(current) ||
	DI_Height(new_w) != DI_Height(current) ||
	DI_HotX(new_w) != DI_HotX(current) ||
	DI_HotY(new_w) != DI_HotY(current) ||
	DI_OffsetX(new_w) != DI_OffsetX(current) ||
	DI_OffsetY(new_w) != DI_OffsetY(current))
    {
	refresh = True;
	DI_IsDirty(new_w) = True;
    }

    if (DI_Pixmap(new_w) != DI_Pixmap(current) ||
	DI_Mask(new_w) != DI_Mask(current))
    {
	refresh = True;
	DI_IsDirty(new_w) = True;
    }

    return refresh;
}

static XContext textIconContext = None;
#define XmTextualDragIconRID	((XID)None)

Widget
_XmGetTextualDragIcon(Widget w)
{
    Widget widget;

    DEBUGOUT(XdbDebug(__FILE__, w, "_XmGetTextualDragIcon\n"));

    if (textIconContext == None)
    {
	textIconContext = XUniqueContext();
    }

    if (XFindContext(XtDisplay(w), XmTextualDragIconRID, textIconContext,
		     (XPointer *)&widget) == XCSUCCESS)
    {
	return widget;
    }

    widget = XmCreateDragIcon(w, "XmTextualDragIcon",
			      NULL, 0);

    XSaveContext(XtDisplay(w), XmTextualDragIconRID, textIconContext,
		 (_Xconst char *)widget);

    return widget;
}

void
_XmDestroyDefaultDragIcon(XmDragIconObject icon)
{
    Screen *scr = XtScreenOfObject(XtParent(icon));

    if (DI_Pixmap(icon) != XmUNSPECIFIED_PIXMAP)
    {
	XmDestroyPixmap(scr, DI_Pixmap(icon));
	DI_Pixmap(icon) = XmUNSPECIFIED_PIXMAP;
    }

    if (DI_Mask(icon) != XmUNSPECIFIED_PIXMAP)
    {
	XmDestroyPixmap(scr, DI_Mask(icon));
	DI_Mask(icon) = XmUNSPECIFIED_PIXMAP;
    }

    XtDestroyWidget((Widget)icon);
}

Boolean
_XmDragIconIsDirty(XmDragIconObject icon)
{
    return DI_IsDirty(icon);
}

void
_XmDragIconClean(XmDragIconObject icon1,
		 XmDragIconObject icon2,
		 XmDragIconObject icon3)
{
    DI_IsDirty(icon1) = False;
    DI_IsDirty(icon2) = False;
    DI_IsDirty(icon3) = False;
}

Widget
XmCreateDragIcon(Widget widget,
		 String name,
		 ArgList arglist,
		 Cardinal argcount)
{
    return XtCreateWidget(name, xmDragIconObjectClass,
			  widget, arglist, argcount);
}
