// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  Filename.h

  Stephane Rehel
  April 12 1997
*/

#ifndef __Filename_h
#define __Filename_h

#ifndef __IBOOL_h
#include "IBOOL.h"
#endif

#ifndef __OString_h
#include "OString.h"
#endif

#ifndef __Path_h
#include "Path.h"
#endif

/////////////////////////////////////////////////////////////////////////////

class Filename
{
protected:
  Path path; // e.g. "/usr/local/lib/"
  OString filename; // e.g. "libjpeg"
  OString extension; // e.g. ".a"

public:
  Filename();

  Filename( const OString& fullname );

  virtual ~Filename()
    {}

  const Path& getPath() const
    {
    return path;
    }

  const OString& getFilename() const
    {
    return filename;
    }

  const OString& getExtension() const
    {
    return extension;
    }

  OString get() const
    {
    return path.get() + filename + extension;
    }

  IBOOL isAbsolute() const;

  static void split( const OString& fullname,
                     Path& path, OString& filename );

  // if error, return FALSE
  IBOOL operator == ( const Filename& _file2 ) const;
};

/////////////////////////////////////////////////////////////////////////////

#endif // ifndef __Filename_h

