// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
   MLSVertex.C

   November 10 1996
   Stephane Rehel
*/

#include "MLSVertex.h"
#include "MLPolygon.h"
#include "MeshRep.h"

/////////////////////////////////////////////////////////////////////////////

int MLSVertex::getSizeOf() const
{
  return sizeof(*this);
}

/////////////////////////////////////////////////////////////////////////////

void MLSVertex::updateNormal( MeshRep* mesh )
{
  const MLVertex& v= mesh->vertices[vertex];
  const int* polygons= v.polygons;
  const int nPolygons= v.nPolygons;

  MLPolygonArray& mesh_polygons= mesh->polygons;

  normal= Vector(0,0,0);
  for( int i= 0; i < nPolygons; ++i )
    {
    int pi= polygons[i];
    if( pi == 0 )
      continue;
    normal+= mesh_polygons[ pi ].normal;
    }

  double norm= normal.norm();
  if( norm > 1e-30 )
    normal /= norm;
}

/////////////////////////////////////////////////////////////////////////////

void MLSVertex::gob( const MLSVertex& sv )
{
  vertex= sv.vertex;
  normal= sv.normal;
  material= sv.material;
  txtCoord= sv.txtCoord;

  flags= sv.flags;
}

/////////////////////////////////////////////////////////////////////////////

void MLSVertex::unallocate()
{
  flags &= ~Flag(ALLOCATED);
}

/////////////////////////////////////////////////////////////////////////////
