// This file is part of Moonlight Creator
//   Copyright (C) 1996-1998  Stephane Rehel
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/*
  PhotoModes.C

  Stephane Rehel

  October 25 1997
*/

#include "PhotoModes.h"

#include "interface/MLModes.h"

#include "modes/PhotoMSelect.h"
#include "modes/PhotoMDrag.h"
#include "modes/PhotoMClick.h"
#include "modes/PhotoMPan.h"
#include "modes/PhotoMZoom.h"
#include "modes/PhotoMRectZoom.h"

/////////////////////////////////////////////////////////////////////////////

// static
void PhotoModes::init( PhotoModule* photo, MLModes* m )
{
  if( m == 0 )
    return;

  m->add( SELECT,   new PhotoMSelect(photo) );
  m->add( DRAG,     new PhotoMDrag(photo) );
  m->add( CLICK,    new PhotoMClick(photo) );
  m->add( PAN,      new PhotoMPan(photo) );
  m->add( ZOOM,     new PhotoMZoom(photo) );
  m->add( RECTZOOM, new PhotoMRectZoom(photo) );
}

/////////////////////////////////////////////////////////////////////////////
