/*    o_model.cpp
 *
 *    Copyright (c) 1994-1996, Marko Macek
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 */

#include "fte.h"

EModel *ActiveModel = 0;
char msgbuftmp[MSGBUFTMP_SIZE] = "";

int GetNewModelID(EModel *B) {
    static int lastid = 0;

    return lastid++;

    /*EModel *p = B;
    int m = 1;
    int did = 0;
    
    while (p) {
        if (p->ModelNo == m) {
            m++;
            did = 1;
        }
        p = p->Next;
        if (p == B)
            if (!did)
                break;
            else
                did = 0;
    }
    return m;*/
}

EModel::EModel(EModel **ARoot) {
    Root = ARoot;
    if (Root) {
        if (*Root) {
            Next = *Root;
            Prev = (*Root)->Prev;
            Prev->Next = this;
            Next->Prev = this;
        } else
            Prev = Next = this;
        *Root = this;
    } else {
        Prev = Next = this;
    }
    View = 0;
    ModelNo = -1;
    ModelNo = GetNewModelID(this);
}

EModel::~EModel() {
    EModel *D = this;
    
    while (D) {
        D->NotifyDelete(this);
        D = D->Next;
        if (D == this)
            break;
    }
    
    if (Next != this) {
        Prev->Next = Next;
        Next->Prev = Prev;
        if (*Root == this)
            *Root = Next;
    } else
        *Root = 0;
}

void EModel::AddView(EView *V) {
    RemoveView(V);
    if (V) 
        V->NextView = View;
    View = V;
}

void EModel::RemoveView(EView *V) {
    EView **X = &View;
    
    if (!V) return;
    while (*X) {
        if ((*X) == V) {
            *X = V->NextView;
            return;
        }
        X = (&(*X)->NextView);
    }
}

void EModel::SelectView(EView *V) {
    RemoveView(V);
    AddView(V);
}

EViewPort *EModel::CreateViewPort(EView *V) {
    return 0;
}

int EModel::ExecCommand(int Command, ExState &State) {
    return ErFAIL;
}

void EModel::HandleEvent(TEvent &Event) {
}

void EModel::Msg(int level, char *s, ...) {
    va_list ap;
    
    if (View == 0)
        return;
    
    va_start(ap, s);
    vsprintf(msgbuftmp, s, ap);
    va_end(ap);
    
    if (level != BUSY)
        View->SetMsg(msgbuftmp);
}

int EModel::CanQuit() {
    return 1;
}

int EModel::ConfQuit(GxView *V) {
    return 1;
}

int EModel::GetContext() { return CONTEXT_NONE; }
EEventMap *EModel::GetEventMap() { return 0; }
int EModel::BeginMacro() { return 1; }
void EModel::GetName(char *AName, int MaxLen) { *AName = 0; }
void EModel::GetPath(char *APath, int MaxLen) { *APath = 0; }
void EModel::GetInfo(char *AInfo, int MaxLen) { *AInfo = 0; }
void EModel::GetTitle(char *ATitle, int MaxLen, char *ASTitle, int SMaxLen) { *ATitle = 0; *ASTitle = 0; }
void EModel::NotifyPipe(int PipeId) { }

void EModel::NotifyDelete(EModel *Deleted) {
}
void EModel::DeleteRelated() {
}

EViewPort::EViewPort(EView *V) { View = V; ReCenter = 0; }
EViewPort::~EViewPort() {}
void EViewPort::HandleEvent(TEvent &Event) { }
void EViewPort::UpdateView() { }
void EViewPort::RepaintView() { }
void EViewPort::UpdateStatus() { }
void EViewPort::RepaintStatus() { }
void EViewPort::GetPos() { }
void EViewPort::StorePos() { }
void EViewPort::Resize(int Width, int Height) {}

void EModel::UpdateTitle() {
    char Title[256] = ""; //fte: ";
    char STitle[256] = ""; //"fte: ";
    EView *V;
    
    GetTitle((char *)(Title + 0), sizeof(Title) - 0,
             (char *)(STitle + 0), sizeof(STitle) - 0);

    V = View;
    while (V) {
        V->MView->Win->UpdateTitle(Title, STitle);
        V = V->NextView;
    }
}
