.TH DLAED1 l "08 October 1994" "LAPACK version 2.0" "LAPACK routine (version 2.0)"
.TH DLAED1 l "08 October 1994" "BLAS routine" "BLAS routine"
.SH NAME
DLAED1 - compute the updated eigensystem of a diagonal matrix after modification by a rank-one symmetric matrix
.SH SYNOPSIS
.TP 19
SUBROUTINE DLAED1(
N, D, Q, LDQ, INDXQ, RHO, CUTPNT, WORK, IWORK,
INFO )
.TP 19
.ti +4
INTEGER
CUTPNT, INFO, LDQ, N
.TP 19
.ti +4
DOUBLE
PRECISION RHO
.TP 19
.ti +4
INTEGER
INDXQ( * ), IWORK( * )
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), Q( LDQ, * ), WORK( * )
.SH PURPOSE
DLAED1 computes the updated eigensystem of a diagonal
matrix after modification by a rank-one symmetric matrix.  This
routine is used only for the eigenproblem which requires all
eigenvalues and eigenvectors of a tridiagonal matrix.  DLAED7 handles
the case in which eigenvalues only or eigenvalues and eigenvectors
of a full symmetric matrix (which was reduced to tridiagonal form)
are desired.
.br

  T = Q(in) ( D(in) + RHO * Z*Z' ) Q'(in) = Q(out) * D(out) * Q'(out)

   where Z = Q'u, u is a vector of length N with ones in the
   CUTPNT and CUTPNT + 1 th elements and zeros elsewhere.

   The eigenvectors of the original matrix are stored in Q, and the
   eigenvalues are in D.  The algorithm consists of three stages:

      The first stage consists of deflating the size of the problem
      when there are multiple eigenvalues or if there is a zero in
      the Z vector.  For each such occurence the dimension of the
      secular equation problem is reduced by one.  This stage is
      performed by the routine DLAED2.
.br

      The second stage consists of calculating the updated
      eigenvalues. This is done by finding the roots of the secular
      equation via the routine DLAED4 (as called by SLAED3).
      This routine also calculates the eigenvectors of the current
      problem.
.br

      The final stage consists of computing the updated eigenvectors
      directly using the updated eigenvalues.  The eigenvectors for
      the current problem are multiplied with the eigenvectors from
      the overall problem.
.br

.SH ARGUMENTS
.TP 7
N      (input) INTEGER
The dimension of the symmetric tridiagonal matrix.  N >= 0.
.TP 7
D      (input/output) DOUBLE PRECISION array, dimension (N)
On entry, the eigenvalues of the rank-1-perturbed matrix.
On exit, the eigenvalues of the repaired matrix.
.TP 7
Q      (input/output) DOUBLE PRECISION array, dimension (LDQ,N)
On entry, the eigenvectors of the rank-1-perturbed matrix.
On exit, the eigenvectors of the repaired tridiagonal matrix.
.TP 7
LDQ    (input) INTEGER
The leading dimension of the array Q.  LDQ >= max(1,N).
.TP 7
INDXQ  (input/output) INTEGER array, dimension (N)
On entry, the permutation which separately sorts the two
subproblems in D into ascending order.
On exit, the permutation which will reintegrate the
subproblems back into sorted order,
i.e. D( INDXQ( I = 1, N ) ) will be in ascending order.
.TP 7
RHO    (input) DOUBLE PRECISION
The subdiagonal entry used to create the rank-1 modification.

CUTPNT (input) INTEGER
The location of the last eigenvalue in the leading sub-matrix.
min(1,N) <= CUTPNT <= N.
.TP 7
WORK   (workspace) DOUBLE PRECISION array, dimension (3*N+2*N**2)
.TP 7
IWORK  (workspace) INTEGER array, dimension (4*N)
.TP 7
INFO   (output) INTEGER
= 0:  successful exit.
.br
< 0:  if INFO = -i, the i-th argument had an illegal value.
.br
> 0:  if INFO = 1, an eigenvalue did not converge
