// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qbitmap.h>
#include "TransferLogo.h"

#include "logo.h"
#include "logomask.xbm"
#include "trans.h"
#include "trans00mask.xbm"
#include "trans01mask.xbm"
#include "trans02mask.xbm"
#include "trans03mask.xbm"
#include "trans04mask.xbm"
#include "trans05mask.xbm"
#include "trans06mask.xbm"
#include "trans07mask.xbm"
#include "trans08mask.xbm"
#include "trans09mask.xbm"
#include "trans10mask.xbm"
#include "trans11mask.xbm"
#include "trans12mask.xbm"
#include "trans13mask.xbm"

TransferLogo::TransferLogo( QWidget* parent, const char* name )
        : QLabel( parent, name )
{
    setFixedSize( 100, 40 );

    _logo.loadFromData( logo_bmp_data, logo_bmp_len );
    _logo.setMask( QBitmap( logomask_width, logomask_height, logomask_bits, TRUE ) );

    _pixmaps = new QPixmap*[15];
    _pixmaps[0] = new QPixmap;
    _pixmaps[0]->loadFromData( trans00_bmp_data, trans00_bmp_len );
    _pixmaps[0]->setMask( QBitmap( trans00mask_width, trans00mask_height, trans00mask_bits, TRUE ) );
    _pixmaps[1] = new QPixmap;
    _pixmaps[1]->loadFromData( trans01_bmp_data, trans01_bmp_len );
    _pixmaps[1]->setMask( QBitmap( trans01mask_width, trans01mask_height, trans01mask_bits, TRUE ) );
    _pixmaps[2] = new QPixmap;
    _pixmaps[2]->loadFromData( trans02_bmp_data, trans02_bmp_len );
    _pixmaps[2]->setMask( QBitmap( trans02mask_width, trans02mask_height, trans02mask_bits, TRUE ) );
    _pixmaps[3] = new QPixmap;
    _pixmaps[3]->loadFromData( trans03_bmp_data, trans03_bmp_len );
    _pixmaps[3]->setMask( QBitmap( trans03mask_width, trans03mask_height, trans03mask_bits, TRUE ) );
    _pixmaps[4] = new QPixmap;
    _pixmaps[4]->loadFromData( trans04_bmp_data, trans04_bmp_len );
    _pixmaps[4]->setMask( QBitmap( trans04mask_width, trans04mask_height, trans04mask_bits, TRUE ) );
    _pixmaps[5] = new QPixmap;
    _pixmaps[5]->loadFromData( trans05_bmp_data, trans05_bmp_len );
    _pixmaps[5]->setMask( QBitmap( trans05mask_width, trans05mask_height, trans05mask_bits, TRUE ) );
    _pixmaps[6] = new QPixmap;
    _pixmaps[6]->loadFromData( trans06_bmp_data, trans06_bmp_len );
    _pixmaps[6]->setMask( QBitmap( trans06mask_width, trans06mask_height, trans06mask_bits, TRUE ) );
    _pixmaps[7] = new QPixmap;
    _pixmaps[7]->loadFromData( trans07_bmp_data, trans07_bmp_len );
    _pixmaps[7]->setMask( QBitmap( trans07mask_width, trans07mask_height, trans07mask_bits, TRUE ) );
    _pixmaps[8] = new QPixmap;
    _pixmaps[8]->loadFromData( trans08_bmp_data, trans08_bmp_len );
    _pixmaps[8]->setMask( QBitmap( trans08mask_width, trans08mask_height, trans08mask_bits, TRUE ) );
    _pixmaps[9] = new QPixmap;
    _pixmaps[9]->loadFromData( trans09_bmp_data, trans09_bmp_len );
    _pixmaps[9]->setMask( QBitmap( trans09mask_width, trans09mask_height, trans09mask_bits, TRUE ) );
    _pixmaps[10] = new QPixmap;
    _pixmaps[10]->loadFromData( trans10_bmp_data, trans10_bmp_len );
    _pixmaps[10]->setMask( QBitmap( trans10mask_width, trans10mask_height, trans10mask_bits, TRUE ) );
    _pixmaps[11] = new QPixmap;
    _pixmaps[11]->loadFromData( trans11_bmp_data, trans11_bmp_len );
    _pixmaps[11]->setMask( QBitmap( trans11mask_width, trans11mask_height, trans11mask_bits, TRUE ) );
    _pixmaps[12] = new QPixmap;
    _pixmaps[12]->loadFromData( trans12_bmp_data, trans12_bmp_len );
    _pixmaps[12]->setMask( QBitmap( trans12mask_width, trans12mask_height, trans12mask_bits, TRUE ) );
    _pixmaps[13] = new QPixmap;
    _pixmaps[13]->loadFromData( trans13_bmp_data, trans13_bmp_len );
    _pixmaps[13]->setMask( QBitmap( trans13mask_width, trans13mask_height, trans13mask_bits, TRUE ) );
    _pixmaps[14] = 0;

    setPixmap( _logo );
}

TransferLogo::~TransferLogo()
{
    int i;
    
    for ( i = 0; _pixmaps[i]; i++ ) {
        delete _pixmaps[i];
    }
    delete [] _pixmaps;
}

void TransferLogo::setTransfer( bool b )
{
    killTimers();
    
    if ( b ) {
        _index = 0;
        startTimer( 100 );
    } else {
        setPixmap( _logo );
    }
}

void TransferLogo::timerEvent( QTimerEvent* )
{
    if ( _pixmaps[_index] == 0 ) {
        _index = 0;
    }

    setPixmap( *_pixmaps[_index++] );
}
