// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _StyleSheet_h_
#define _StyleSheet_h_

#include <qlist.h>
#include "Style.h"

//: The StyleSheet class stores and saves the style information for a single DTD.
//. Two types of styles are maintained: basic and compound.  A basic style is a
//. style associated with a single element (i.e. "BODY", "P", "H3").  These
//. styles are added to the style sheet only by the style parser.  Compound
//. styles are created and cached as a document instance is being rendered.
//. Compound styles look like "/HTML/HEAD/TITLE" or "/HTML/BODY/P/A/EM".
class StyleSheet {
    friend class StyleEditor;
    
    QString      _soi;
    QList<Style> _styles;

    //. Create and return a new style by combining the two given styles.  If a
    //. value in "style" is Inherit, then the value of the new style will be
    //. taken from "base".
    Style* inherit( const Style* base, const Style* style );
public:
    StyleSheet();

    StyleSheet( const StyleSheet& src );

    //. Return the storage object identifier for this style sheet.
    QString soi() { return _soi; }

    //. Set the storage object identifier for this style sheet.
    void    soi( const QString& soi ) { _soi = soi.copy(); }

    //. Add a new basic or compound style to the style sheet.
    void    addStyle( Style* style );

    void deleteStyle( Style* style );

    //. Return the basic or compound style for the given tag path.  If a
    //. compound style has been requested, all of the necessary intermediate
    //. compound styles will be created and cached automatically.
    Style*  getStyle( const Style* parent, const STag& tag );

    //. Save this style sheet, using its storage object identifier.
    void    save();
};

#endif
