// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#ifndef _SgmlElement_h_
#define _SgmlElement_h_

#include <qdict.h>
#include <qstrlist.h>
#include <qstring.h>
#include "Attribute.h"
#include "SgmlNode.h"
#include "ContentModel.h"

//: The SgmlElement class stores data about an SGML element derived from the DTD.
//. The SgmlElement is created by the DtdParser, and it is used by the
//. SgmlParser.
class SgmlElement {
    QString          _name;
    bool             _stagRequired;
    bool             _etagRequired;
    QStrIList        _include;
    QStrIList        _exclude;
    ContentModel     _model;
//    SgmlNode*        _tree;
    bool             _isEmpty;
    QList<Attribute> _attrs;
public:
    //. Construct a new SgmlElement.  Create a content model DFA from the
    //. provided parse tree.
    SgmlElement( QString name, bool stag, bool etag, QStrIList& incl, QStrIList& excl, SgmlNode* root );

    ~SgmlElement();

    //. Returns the element name.
    QString name() { return _name; }

    //. Returns TRUE if the start tag is required fro this element.
    bool stagRequired() { return _stagRequired; }

    //. Returns TRUE if the end tag is required for this element.
    bool etagRequired() { return _etagRequired; }

    //. Returns the list of included elements.
    QStrIList& include() { return _include; }

    //. Returns the list of excluded elements.
    QStrIList& exclude() { return _exclude; }

    //. Returns the elements content model.
    ContentModel& model() { return _model; }

    //. Returns the root node of the content model parse tree.
//    SgmlNode* tree() { return _tree; }

    bool isEmpty() { return _isEmpty; }

    //. Returns TRUE if the given element is excluded from the content model.
    bool excluded( QString name );

    //. Returns TRUE if the given element is included in the content model.
    bool included( QString name );

    //. Return the list of attributes that this element can have.
    QList<Attribute>& attrs() { return _attrs; }
};

#endif
