// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include <qchkbox.h>
#include <qlabel.h>
#include <qlined.h>
#include "Options.h"
#include "PrefsWindow.h"

GeneralPage::GeneralPage( QWidget* parent, const char* name )
        : QWidget( parent, name )
{
    _homeUrlLabel = new QLabel( "Home Page URL:", this );
    _homeUrlLabel->setAlignment( AlignRight | AlignVCenter );
    _labelWidth = _homeUrlLabel->sizeHint().width();

    _homeUrlEntry = new QLineEdit( this );

    _homeAutoLoadCheck = new QCheckBox( "Autoload", this );

    _bookmarksLabel = new QLabel( "Bookmarks URL:", this );
    _bookmarksLabel->setAlignment( AlignRight | AlignVCenter );
    if ( _labelWidth < _bookmarksLabel->sizeHint().width() ) {
        _labelWidth = _bookmarksLabel->sizeHint().width();
    }

    _bookmarksEntry = new QLineEdit( this );

    _catalogUrlLabel = new QLabel( "SGML Catalog File:", this );
    _catalogUrlLabel->setAlignment( AlignRight | AlignVCenter );
    if ( _labelWidth < _catalogUrlLabel->sizeHint().width() ) {
        _labelWidth = _catalogUrlLabel->sizeHint().width();
    }

    _catalogUrlEntry = new QLineEdit( this );
}

void GeneralPage::resizeEvent( QResizeEvent* )
{
    const int pad        = 4;
    const int rowHeight  = 24;
    const int dataWidth  = width() - 3 * pad - _labelWidth;
    const int checkWidth = _homeAutoLoadCheck->sizeHint().width();

    _homeUrlLabel->setGeometry     ( pad                       , pad                    , _labelWidth                 , rowHeight );
    _homeUrlEntry->setGeometry     ( 2 * pad + _labelWidth     , pad                    , dataWidth - pad - checkWidth, rowHeight );
    _homeAutoLoadCheck->setGeometry( width() - pad - checkWidth, pad                    , checkWidth                  , rowHeight );
    _bookmarksLabel->setGeometry   ( pad                       , 2 * pad + rowHeight    , _labelWidth                 , rowHeight );
    _bookmarksEntry->setGeometry   ( 2 * pad + _labelWidth     , 2 * pad + rowHeight    , dataWidth                   , rowHeight );
    _catalogUrlLabel->setGeometry  ( pad                       , 3 * pad + 2 * rowHeight, _labelWidth                 , rowHeight );
    _catalogUrlEntry->setGeometry  ( 2 * pad + _labelWidth     , 3 * pad + 2 * rowHeight, dataWidth                   , rowHeight );
}

void GeneralPage::apply()
{
    if ( options->homeUrl() != _homeUrlEntry->text() ) {
        options->setHomeUrl( _homeUrlEntry->text() );
    }

    if ( options->autoLoad() != _homeAutoLoadCheck->isChecked() ) {
        options->setAutoLoad( _homeAutoLoadCheck->isChecked() );
    }

    if ( options->bookmarksUrl() != _bookmarksEntry->text() ) {
        options->setBookmarksUrl( _bookmarksEntry->text() );
    }

    if ( options->catalogFile() != _catalogUrlEntry->text() ) {
        options->setCatalogFile( _catalogUrlEntry->text() );
    }
}

void GeneralPage::update()
{
    _homeUrlEntry->setText( options->homeUrl() );
    _homeAutoLoadCheck->setChecked( options->autoLoad() );
    _bookmarksEntry->setText( options->bookmarksUrl() );
    _catalogUrlEntry->setText( options->catalogFile() );
}

PrefsWindow::PrefsWindow( QWidget* parent, const char* name )
        : QTabDialog( parent, name, TRUE )
{
    setCaption( "QWeb: Preferences" );
    setIconText( "Preferences" );
    
    _general = new GeneralPage( this );
    addTab( _general, "General" );

    setApplyButton();
    setCancelButton();

    connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( apply() ) );
    connect( this, SIGNAL( aboutToShow() )       , this, SLOT( update() ) );
}

void PrefsWindow::apply()
{
    _general->apply();
}

void PrefsWindow::update()
{
    _general->update();
}
