/***************************************************************************
**    xIrcMsgFrame1.cpp  $Revision: 1.19 $ - $Name: V2-0 $ 
**    Class to handle chatting w/ a person or channel
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <sys/types.h>
#include <qkeycode.h>
#include "xDefaults.h"
#include "xResources.h"
#include "xIrcMsgDispatch.h"
#include "xIrcMsgFrame.h"
#include "xIrcNickQuery.h"

static int dbg = 0;

extern xIrcCommands ircResponses;
extern xIrcNickQuery *NickQuery;
extern xDefaults Defaults;
extern QPixmap *AppPixMap;
extern xIrcMsgDispatch Dispatcher;

static const char *pInitialResources[] =
{
   NULL
};

xIrcMessageFrame::xIrcMessageFrame(xWidgetResInfo *pPRes, QWidget *pParent, 
                                   const char *pName) :
               xDialog(wdtRes = new xWidgetResInfo(pPRes, QString("msgchat"),
                                                   QString("MsgChat")),
                       pParent, pName, 0)
{
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Enter\n");
   if (dbg) fflush(stdout);
   
   Resources->setWidgetInit(pInitialResources);
   setDefPallet(this, wdtRes);
   setDefFont(this, wdtRes);
   if (AppPixMap != NULL)
      setIcon(*AppPixMap);

   resizeCnt = -2;
   pNext = NULL;
   pPrev = NULL;
   if (pName)
      setCaption(pName);
      
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Creating Timer\n");
   if (dbg) fflush(stdout);
   pNickUpdateTimer = new QTimer(this);
   pNickPurgeTimer = new QTimer(this);
   
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Creating TermFrame\n");
   if (dbg) fflush(stdout);
   pMsgFrame = new xMultiLineFrame(wdtRes, this, NULL, 80, 
                                   (*pName == '#') ? 22 : 11);
   connect(pMsgFrame, SIGNAL(textSelected(xMultiLineTextSelection)),
           this, SLOT(haveTextSelection(xMultiLineTextSelection)));
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Creating Button Bar\n");
   if (dbg) fflush(stdout);
   pButtons = new xPshBtnFrame(wdtRes, this);
   pButtons->setFrameStyle(QFrame::Panel | QFrame::Raised);
   pButtons->setAlignment(xALIGN_Horz);
   pButtons->setResizeMode(xSPACE_Resize);
   pButtons->setWidgetSpacing(0);
   pButtons->setMargins(2, 2);
   pButtons->addButton("Close", btnClose);
   pButtons->addButton("Ping", btnPing);
   pButtons->addButton("Nick Actions", btnAction);
   if (*pName == '#')
      pButtons->addButton("Nick List", btnList);
   pButtons->addButton("Clear Line", btnClear);
   connect(pButtons, SIGNAL(clicked(int)), this, SLOT(buttonPressed(int)));
   
   if (*pName == '#')
   {
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Creating Channel nick box\n");
      if (dbg) fflush(stdout);
      pNicks = new xIrcChanNickBox(wdtRes, NULL, pName);
      pNicks->show();
      connect(pNicks, SIGNAL(buttonPressed(int)), this, SLOT(nickButtonPressed(int)));
      
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Starting Timer\n");
      if (dbg) fflush(stdout);
      pNickUpdateTimer->start(NICK_UPDATE_TIME);
      pNickPurgeTimer->start(NICK_PURGE_TIME);
      
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Connecting Timer\n");
      if (dbg) fflush(stdout);
      connect(pNickUpdateTimer, SIGNAL(timeout()), this, SLOT(nickTime()));
      connect(pNickPurgeTimer, SIGNAL(timeout()), this, SLOT(nickPurgeTime()));
      
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Timer Connected\n");
      if (dbg) fflush(stdout);
   }
   else
      pNicks = NULL;
      
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Creating Edit Widget\n");
   if (dbg) fflush(stdout);
   pEdit = new xEdit(wdtRes, this);
   addWidget(pButtons);
   addWidget(pMsgFrame);
   addWidget(pEdit);
   setMargins(0,0);
   setWidgetSpacing(0);
   initFrame();
   connect(pEdit, SIGNAL(returnPressed()), this, SLOT(gotKeyboardInput()));
   if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Exit\n");
   if (dbg) fflush(stdout);
}

void xIrcMessageFrame::link(xIrcMessageFrame *pMsg)
{
   if (dbg) fprintf(stdout, "xIrcmessageFrame::~xIrcMessageFrame():Enter\n");
   if (dbg) fflush(stdout);
   pMsg->pNext = pNext;
   if (pNext)
      pNext->pPrev = pMsg;
   pNext = pMsg;
   pMsg->pPrev = this;
   if (dbg) fprintf(stdout, "xIrcmessageFrame::~xIrcMessageFrame():Exit\n");
   if (dbg) fflush(stdout);
}

xIrcMessageFrame::~xIrcMessageFrame()
{
   if (pMsgFrame)
      delete pMsgFrame;
   if (pEdit)
      delete pEdit;
   if (pButtons)
      delete pButtons;
   if (pPrev)
      pPrev->pNext = pNext;
   if (pNext)
      pNext->pPrev = pPrev;
}

void xIrcMessageFrame::buttonPressed(int btn) 
{
   xMultiLineTextSelection msg;

   switch(btn)
   {
      case btnClose:
         closeFrame();
         break;

      case btnPing:
         doPing();
         break;

      case btnAction:
         msg.winName = name();
         msg.text = "";
         emit textSelected(msg);
         break;

      case btnList:
         if (pNicks && pNicks->isVisible())
            pNicks->hide();
         else
            pNicks->show();

      case btnClear:
         clearLine();
         break;
   }
}

void xIrcMessageFrame::newName(const char *pName) 
{
   if (*pName == '#')
   {
      if (pNicks)
         delete pNicks;
      pNicks = new xIrcChanNickBox(wdtRes, NULL, pName);
      pNicks->show();
      pNickUpdateTimer->start(NICK_UPDATE_TIME);
      pNickPurgeTimer->start(NICK_PURGE_TIME);
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Connecting Timer\n");
      if (dbg) fflush(stdout);
      connect(pNickUpdateTimer, SIGNAL(timeout()), this, SLOT(nickTime()));
      connect(pNickPurgeTimer, SIGNAL(timeout()), this, SLOT(nickPurgeTime()));
      connect(pNicks, SIGNAL(buttonPressed(int)), this, SLOT(nickButtonPressed(int)));
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Timer Connected\n");
      if (dbg) fflush(stdout);
   }
   else
   {
      if (pNicks)
         delete pNicks;
      pNicks = NULL;
   }
   setName(pName);
   setCaption(pName);
}

void xIrcMessageFrame::closeFrame() 
{
   char *cp;
   xIrcMessage msg;

   cp = (char *)name();
   if (*cp == '#')
   {
      msg.rspCode = ircResponses.code("PART");
      msg.dstStr = cp;
      msg.msgStr = "";
      Dispatcher.dispatchMsg(this, SLOT(ircRespMessageIn(xIrcMessage*)), &msg);
//      emit ircMessageOut(&msg);
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Disconnecting Timer\n");
      if (dbg) fflush(stdout);
      disconnect(pNickUpdateTimer, SIGNAL(timeout()), this, SLOT(nickTime()));
      disconnect(pNickPurgeTimer, SIGNAL(timeout()), this, SLOT(nickPurgeTime()));
      if (dbg) fprintf(stdout, "xIrcmessageFrame::xIrcMessageFrame():Timer Disconnected\n");
      if (dbg) fflush(stdout);
      pNickUpdateTimer->stop();
      pNickPurgeTimer->stop();
   }
   
   if (pNicks)
   {
      pNicks->hide();
      delete pNicks;
      pNicks = NULL;
   }
   emit ircMsgFrameClosing(this);
   delete this;
};

bool xIrcMessageFrame::is(const char *pName)
{
   QString tmpNick, tmpName;
   const char *cp;
   bool rv;
   
   if (dbg) fprintf(stdout, "xIrcMessageFrame::is():Enter\n");
   for (cp = pName, tmpNick = ""; *cp; cp++)
      tmpNick += toupper(*cp);
   for (cp = (const char *)name(), tmpName = ""; *cp; cp++)
      tmpName += toupper(*cp);
   if (dbg) fprintf(stdout, "xIrcMessageFrame::is():Testing Name:|%s| to Nick:|%s|\n",
                            (const char *)tmpName, (const char *)tmpNick);
   rv = (tmpName == tmpNick) ? TRUE : FALSE;
   if (dbg) fprintf(stdout, "xIrcMessageFrame::is():Exit- Names %s\n", rv == TRUE ?
                            "Matched!!" : "Didnot Match");
   return(rv);
}

void xIrcMessageFrame::doPing() 
{
   char buf[20], buf1[80];
   xIrcMessage msg;

   sprintf(buf, "%ld", time(NULL));
   msg.rspCode = ircResponses.code("PRIVMSG");
   msg.dstStr = name();
   msg.msgStr = "\x01";
   msg.msgStr += "PING ";
   msg.msgStr += buf;
   msg.msgStr += "\x01";
   sprintf(buf1, "*** Ping command sent to %s\n", (const char *)msg.dstStr);
   pMsgFrame->pWin->putString(buf1);
   Dispatcher.dispatchMsg(this, SLOT(ircRespMessageIn(xIrcMessage*)), &msg);
//   emit ircMessageOut(&msg);
}

void xIrcMessageFrame::clearLine() 
{
   pEdit->setText("");
}

void xIrcMessageFrame::nickTime()
{
   xIrcMessage msg;

   if (pNicks && pNicks->isVisible())
   {
      if (dbg) fprintf(stdout, "xIrcmessageFrame::nickTime():Enter\n");
      if (dbg) fflush(stdout);
      if (dbg) fprintf(stdout, "xIrcmessageFrame::nickTime():Requesting Name List\n");
      if (dbg) fflush(stdout);
      msg.rspCode = ircResponses.code("NAMES");
      msg.dstStr = name();
      msg.msgStr = "";
      Dispatcher.dispatchMsg(this, SLOT(ircRespMessageIn(xIrcMessage*)), &msg);
//      emit ircMessageOut(&msg);
      if (dbg) fprintf(stdout, "xIrcmessageFrame::nickTime():Exit\n");
      if (dbg) fflush(stdout);
   }
}

void xIrcMessageFrame::nickPurgeTime()
{
   xIrcMessage msg;

   if (pNicks && pNicks->isVisible())
   {
      pNicks->clear();
      if (dbg) fprintf(stdout, "xIrcmessageFrame::nickTime():Enter\n");
      if (dbg) fflush(stdout);
      msg.rspCode = ircResponses.code("NAMES");
      msg.dstStr = name();
      msg.msgStr = "";
      Dispatcher.dispatchMsg(this, SLOT(ircRespMessageIn(xIrcMessage*)), &msg);
//      emit ircMessageOut(&msg);
      if (dbg) fprintf(stdout, "xIrcmessageFrame::nickTime():Exit\n");
      if (dbg) fflush(stdout);
   }
}

void xIrcMessageFrame::gotKeyboardInput()
{
   xIrcMessage msg;
   char buf[512], *cp;

   if (dbg) fprintf(stdout, "xIrcMessageFrame::gotKeyboardInput():Got input!\n");
   if (dbg) fflush(stdout);
   if (!isVisible())
   {
      show();
      if (pNicks->isVisible())
         pNicks->show();
   }

   strcpy(buf, pEdit->text());
   for (cp = buf; *cp && isspace(*cp); cp++);
   if (*cp == '/')
      procCommand(++cp);
   else
   {
      if (strlen(buf) > 0)
      {
         msg.rspCode = ircResponses.code("PRIVMSG");
         msg.dstStr = name();
         msg.msgStr = buf;
         if (dbg) fprintf(stdout, "xIrcMessageFrame::gotKeyboardInput():Sending input\n");
         if (dbg) fflush(stdout);
         Dispatcher.dispatchMsg(this, SLOT(ircRespMessageIn(xIrcMessage*)), &msg);
//         emit ircMessageOut(&msg);
         if (dbg) fprintf(stdout, "xIrcMessageFrame::gotKeyboardInput():Putting it on the screen!\n");
         if (dbg) fflush(stdout);
         sprintf(buf, "-> %s\n", pEdit->text());
         pMsgFrame->pWin->putString(buf);
      }
   }
   if (dbg) fprintf(stdout, "xIrcMessageFrame::gotKeyboardInput():Clearing the edit field!\n");
   if (dbg) fflush(stdout);
   pEdit->setText("");
   if (dbg) fprintf(stdout, "xIrcMessageFrame::gotKeyboardInput():Exit\n");
   if (dbg) fflush(stdout);
}

bool xIrcMessageFrame::procServerMsg(xIrcMessage *pMsg)
{
   QString tmpDst, tmpSrc, tmpNick, tmpName;
   const char *cp;
   bool rv = FALSE, b = FALSE;
   
   if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg(%s):Enter\n", name());
   if (dbg) fflush(stdout);
   
   for (cp = NickQuery->text(), tmpNick = ""; *cp; cp++)
      tmpNick += toupper(*cp);
   for (cp = pMsg->srcNick, tmpSrc = ""; *cp; cp++)
      tmpSrc += toupper(*cp);
   for (cp = pMsg->dstStr, tmpDst = ""; *cp; cp++)
      tmpDst += toupper(*cp);
   for (cp = (char *)name(), tmpName = ""; *cp; cp++)
      tmpName += toupper(*cp);
   
   if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Comparing |%s| & |%s| to |%s|\n", 
                             (const char *)tmpSrc, (const char *)tmpDst, 
                             (const char *)tmpName);
   if (dbg) fflush(stdout);
      
   if (
         (tmpNick == tmpDst && tmpSrc == tmpName) || 
         tmpDst == tmpName || 
         (
            pNicks && ((b = pNicks->is(tmpSrc)) && tmpDst == tmpName)
         ) || (
            pNicks && (b = pNicks->is(tmpDst)) && 
            (
               (pMsg->rspCode >= 311 && pMsg->rspCode <= 319) ||
               pMsg->rspCode == 301
            )
         ) || (
            pNicks && (b = pNicks->is(tmpSrc)) && 
            (
               pMsg->rspCode == 27 ||
               pMsg->rspCode == 33
            )
         )
      )
   {
      if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Found Match!!!!! b = %d\n", b);
      if (dbg) fflush(stdout);
      rv = TRUE;

      if (pMsg->rspCode == 353)
      {
         if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Adding new nicks to Box\n");
         if (dbg) fflush(stdout);
         if (pNicks && pNicks->isVisible())
            pNicks->setNicks(pMsg->msgStr);
         else
            ircRespMessageIn(pMsg);
      }
      else if ((pMsg->rspCode >= 300 && pMsg->rspCode <= 369) ||
         (!isMsg(pMsg->rspCode, "PRIVMSG") && !isMsg(pMsg->rspCode, "NOTICE")))
      {
         if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Sending Response message to Message frame\n");
         if (dbg) fflush(stdout);
         ircRespMessageIn(pMsg);
         if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Done\n");
         if (dbg) fflush(stdout);
      }
      else if (isMsg(pMsg->rspCode, "PRIVMSG") ||
               isMsg(pMsg->rspCode, "NOTICE"))
      {
         if (pMsg->pmsgTyp == ipmDCC ||
             pMsg->pmsgTyp == ipmDCCChat ||
             pMsg->pmsgTyp == ipmDCCSend ||
             (isMsg(pMsg->rspCode, "PRIVMSG") &&
              (pMsg->pmsgTyp == ipmVersion ||
               pMsg->pmsgTyp == ipmUserInfo ||
               pMsg->pmsgTyp == ipmFinger ||
               pMsg->pmsgTyp == ipmClientInfo ||
               pMsg->pmsgTyp == ipmErrMsg ||
               pMsg->pmsgTyp == ipmSource)))
            rv = FALSE;
         else
            ircPrivMessageIn(pMsg);
      }
   }
   
   if (dbg) fprintf(stdout, "xIrcMessageFrame::ProcServerMsg():Exit\n");
   if (dbg) fflush(stdout);
   return(rv);
}

void xIrcMessageFrame::gotNickAction(int action)
{
   action++;
}

void xIrcMessageFrame::haveTextSelection(xMultiLineTextSelection msg)
{
   if (dbg) fprintf(stdout, "xIrcMessageFrame::havetextSelection():Enter\n");
   if (dbg) fflush(stdout);
   if (dbg) fprintf(stdout, "xIrcMessageFrame::havetextSelection():winName = |%s|, text = |%s|\n",
                             (const char *)msg.winName, (const char *)msg.text);
   if (dbg) fflush(stdout);
   emit textSelected(msg);
}

void xIrcMessageFrame::resizeEvent(QResizeEvent *pEvt)
{
//   pEvt++;
   QSize sizeFrame, sizeNewFrame, sizeTerm;
   QSize s;

   if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Enter - %d\n", resizeCnt);
   if (dbg) fflush(stdout);
   if (resizeCnt >= 0)
      resizeCnt++;
//   if (resizeCnt < 2 && resizeCnt >= 0)
   {
      if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Resizing Frame - %d\n", resizeCnt);
      if (dbg) fflush(stdout);
      sizeFrame = pEvt->size();
      sizeTerm = sizeFrame;
      if (resizeCnt >= 0)
      {
         if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Resizing Terminal Frame - %d\n", resizeCnt);
         if (dbg) fflush(stdout);
         sizeTerm.setHeight(sizeFrame.height() - (pButtons->size().height() +
                                                  pEdit->size().height()));
         pMsgFrame->resize(sizeTerm);
      }

      s = pButtons->size();
      s.setWidth(sizeTerm.width());
      pButtons->resize(&s);

      s = pEdit->size();
      s.setWidth(sizeTerm.width());
      pEdit->resize(s);

      sizeNewFrame = pMsgFrame->size();
      sizeNewFrame.setHeight(sizeNewFrame.height() + pEdit->size().height() +
                          pButtons->size().height());
      if (sizeNewFrame != sizeFrame)
      {
         if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Fittinging Frame - %d\n", resizeCnt);
         if (dbg) fflush(stdout);
         resize(&sizeNewFrame);
         initFrame(&sizeNewFrame);
      }
      if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Fittinging Frame - %d\n", resizeCnt);
      if (dbg) fflush(stdout);
      if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Done -  %d\n", resizeCnt);
      if (dbg) fflush(stdout);
   }
//   else if (resizeCnt < 0)
   if (resizeCnt < 0)
      resizeCnt++;
   if (resizeCnt > 0)
      resizeCnt--;
      
   if (dbg) fprintf(stdout, "xIrcMessageFrame::resizeEvent():Exit-  %d\n", resizeCnt);
   if (dbg) fflush(stdout);
}

#include "xIrcMsgFrame.moc"
