/***************************************************************************
**    xIrcError.h  $Revision: 1.6 $ - $Name: V2-0 $ 
**    Dialog box to display error messages
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xERRORBOX_H
#define _xERRORBOX_H

#include <qlabel.h>
#include <xPshBtnFrame.h>
#include <xDialog.h>
#include <xResources.h>
#include "xIrcSocket.h"

class xIrcErrorBox : public xDialog
{
   Q_OBJECT
   
public:
   xIrcErrorBox(xWidgetResInfo *pPRes, QWidget *pParent, 
                const char *pName, QObject *pReceiver, 
                char *pSlot, xIrcMessage *pMsg);
   ~xIrcErrorBox()
   {
      disconnect(pButton, SIGNAL(clicked(int)), this, SLOT(buttonClicked()));
      disconnect(this);
      if (pLabel)
         delete pLabel;
      if (pButton)
         delete pButton;
   };
   
signals:
   void acknowledged(int rspCode);
   
protected slots:
   void buttonClicked();

private:
   QLabel         *pLabel;
   xPshBtnFrame  *pButton;
   int            rspCode;
   xWidgetResInfo *wdtRes;
};

#endif
