// pppload - A PPP Load Monitor
// Copyright (C) 1996  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef _PPPStats_H_
#define _PPPStats_H_

#include <qobject.h>

//: Periodically broadcast updated PPP link statistics.
//. When this object is created, it is passed a statistics interval in
//. seconds.  Once per interval, the object will query the PPP driver
//. for its statistics.  The stats are broadcast using the changeStats()
//. signal.  The number of bytes transmitted and received during the
//. interval are reported, as well as the total number of bytes transmitted
//. and received.
class PPPStats : public QObject {
	Q_OBJECT;
	//: The socket used to query the PPP stats.
	int _s;
	//: Most recent total number of bytes read.
	unsigned int _rxTotal;
	//: Most recent total number of bytes sent.
	unsigned int _txTotal;
	//: True if the PPP link is up.
	bool _isUp;
	//: Link retry timer id.
	int  _retryId;
 protected:
	//: Poll the PPP driver for its stats.
	virtual void timerEvent( QTimerEvent* e );
 public:
	//: Create a PPPStats object that polls for PPP statistics.
	PPPStats();
 signals:
	//: Emitted each time after the PPP driver stats are collected.
	//. This signal carries the number of bytes transmitted and received
	//. during the last interval, and the total number of bytes transmitted
	//. and received.
	void changeStats( unsigned int rxDelta, unsigned int txDelta, unsigned int rxTotal, unsigned int txTotal );
	
	//: Emitted when it is detected that the PPP link has gone down.
	void linkDown();
};

#endif
