// KPPPLoad - a PPP load monitor
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _Graph_h_
#define _Graph_h_

#include <qpixmap.h>
#include <qwidget.h>

class Graph : public QWidget {
    Q_OBJECT
    int     _historySize;
    int*    _txHistory;
    int*    _rxHistory;
    int     _dataSize;
    int*    _txData;
    int*    _rxData;
    int     _txAverage;
    int     _rxAverage;
    int     _max;
    QPixmap _pixmap;

    void updateGraph();
protected:
    virtual void resizeEvent( QResizeEvent* e );
    virtual void paintEvent( QPaintEvent* e );
    virtual void mousePressEvent( QMouseEvent* e );
public:
    Graph( QWidget* parent = 0, const char* name = 0 );
    ~Graph();
public slots:
    void updateStats( uint rxDelta, uint txDelta, uint rxTotal, uint txTotal );
    void linkDown();
    void redrawGraph();
signals:
    void popupMenu( const QPoint& pos );
};

#endif
