//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "netinmeter.h"
#include "xosview.h"


NetInMeter::NetInMeter( XOSView *parent, int x, int y, 
		       int width, int height, float max )
: FieldMeter( parent, x, y, width, height, 2, "IN", "PACKETS/SEC" ){
  maxpackets_ = max;
  parent_->addResource( "netInColor", NULL, "lightblue" );
  parent_->addResource( "netInBackground", NULL, "green2" );
  priority_ = 2;
}

NetInMeter::~NetInMeter( void ){
}

void NetInMeter::checkResources( void ){
  FieldMeter::checkResources();

  setfieldcolor( 0, parent_->getResource( "netInColor" ) );
  setfieldcolor( 1, parent_->getResource( "netInBackground" ) );
}

void NetInMeter::checkevent( void ){
  NetMeter::checkevent();
  total_ = maxpackets_;
  fields_[0] = incoming();
  if ( fields_[0] < 0 ) fields_[0] = 0;
  if ( fields_[0] > total_ ) fields_[0] = total_;
  fields_[1] = total_ - fields_[0];

  used( (int)((100 * fields_[0]) / total_) );

  drawfields();
}
