//  
//  Copyright (c) 1994 by Mike Romberg (  romberg@md.fsl.noaa.gov )
//
//  This file may be distributed under terms of the GPL
//

#include "memmeter.h"
#include "xosview.h"
#include <fstream.h>

#ifdef USESYSCALLS
#include <syscall.h>
#include <linux/kernel.h>
#endif

static const char MEMFILENAME[] = "/proc/meminfo";


MemMeter::MemMeter( XOSView *parent, int x, int y, int width, int height )
: FieldMeter( parent, x, y, width, height, 4, "MEM", "USED/SHAR/BUFF/FREE" ){
  parent_->addResource( "memUsedColor", NULL, "blue" );
  parent_->addResource( "memSharedColor", NULL, "yellow" );
  parent_->addResource( "memBufferColor", NULL, "red" );
  parent_->addResource( "memFreeColor", NULL, "green2" );

  priority_ = 10;
}

MemMeter::~MemMeter( void ){
}

void MemMeter::checkResources( void ){
  FieldMeter::checkResources();

  setfieldcolor( 0, parent_->getResource( "memUsedColor" ) );
  setfieldcolor( 1, parent_->getResource( "memSharedColor" ) );
  setfieldcolor( 2, parent_->getResource( "memBufferColor" ) );
  setfieldcolor( 3, parent_->getResource( "memFreeColor" ) );
}

void MemMeter::checkevent( void ){
  getmeminfo();
  drawfields();
}

#ifdef USESYSCALLS
void MemMeter::getmeminfo( void ){
  struct sysinfo sinfo;

  syscall( SYS_sysinfo, &sinfo );

  total_ = sinfo.totalram;
  fields_[3] = sinfo.freeram;
  fields_[1] = sinfo.sharedram;
  fields_[2] = sinfo.bufferram;

  fields_[0] = total_ - fields_[3] - fields_[2] - fields_[1];
  if ( fields_[0] < 0 ){
    // Fixing up the user field
    fields_[0] = 0;

    // Fixing up the buffers field
    fields_[2] = total_ - fields_[3] - fields_[1];
  }

  FieldMeter::used( (int)((100 * (total_ - fields_[3])) / total_) );
}
#else
void MemMeter::getmeminfo( void ){
  float used;
  char buf[256];  

  ifstream meminfo( MEMFILENAME );

  if ( !meminfo ){
    cerr <<"Con not open file : " <<MEMFILENAME <<endl;
    exit( 1 );
  }

  meminfo.getline( buf, 256 );

  meminfo >>buf >>total_ >>used >>fields_[3] >>fields_[1] >>fields_[2];

  fields_[0] = total_ - fields_[3] - fields_[2] - fields_[1];
  if ( fields_[0] < 0 ){
    // Fixing up the user field
    fields_[0] = 0;

    // Fixing up the buffers field
    fields_[2] = total_ - fields_[3] - fields_[1];
  }

  FieldMeter::used( (int)((100 * (total_ - fields_[3])) / total_) );
}
#endif

