/*--------------------------------*-C-*---------------------------------*
 * Copyright 1992 John Bovey, University of Kent at Canterbury.
 *
 * You can do what you like with this source code as long as
 * you don't try to make money out of it and you include an
 * unaltered copy of this message (including the copyright).
 *
 * This module has heavily modified by R. Nation
 * (nation@rocket.sanders.lockheed.com).
 * No additional restrictions are applied
 *
 * Additional modifications by Garrett D'Amore (garrett@netcom.com).
 * No additional restrictions are applied.
 *
 * Additional modifications by mj olesen <olesen@me.queensu.ca>
 * No additional restrictions are applied.
 *
 * As usual, the author accepts no responsibility for anything, nor does
 * he guarantee anything whatsoever.
 *----------------------------------------------------------------------*/
#include "rxvt.h"

#include <stdarg.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>

#include "command.h"
#include "xsetup.h"
#include "screen.h"
#include "debug.h"
#include "graphics.h"
#include "grkelot.h"
#include "defaults.h"

/* change here to suit compiled-in value */
#define HOTKEY_KEYSYM	"Alt-keysym"
/*#define HOTKEY_KEYSYM	"Ctrl-keysym"*/
/*#define HOTKEY_KEYSYM	"Shift-keysym"*/

/*----------------------------------------------------------------------*
 * extern variables referenced
 */

/*----------------------------------------------------------------------*
 * extern variables declared here
 */
Display		*Xdisplay;	/* display */
XFontStruct	*Xfont;		/* main font structure */
GC 		Xgc, Xrvgc;	/* GC for drawing text: plain, reverse video */
int		Xdepth;		/* default depth for current screen */

char *rs_color [NCOLORS];
unsigned long pixel_colors [NCOLORS];

#ifndef SCROLLBAR_NONE
sbar_type sbar;
#endif

unsigned char console = 0;
unsigned char iconic = 0;
#ifndef ALWAYS_META_ESCAPE
unsigned char MetaHandling = DEF_META;
#endif
unsigned char login_shell = DEF_LOGINSHELL;
#ifdef MAPALERT
unsigned char map_alert = DEF_MAPALERT;
KeySym ks_alert = DEF_KS_ALERT;
#endif
#ifdef VISUAL_BELL
unsigned char visual_bell = DEF_VISUALBELL;
#endif

char *rs_name = NULL;		/* the name the program is run under */
char *rs_title = NULL;		/* window name for titles etc. */
char *rs_iconName = NULL;	/* name to display in the icon */
char *rs_geometry = NULL;
char *display_name = NULL;

char *rs_font [NFONTS];
#ifndef SINGLE_FONT
KeySym ks_bigfont = DEF_KS_BIGFONT;
KeySym ks_smallfont = DEF_KS_SMALLFONT;
#endif

#ifdef PRINT_PIPE
char *rs_print_pipe = NULL;
KeySym ks_printscreen = DEF_KS_PRINTSCREEN;
#endif

KeySym ks_pageup   = DEF_KS_PAGEUP;
KeySym ks_pagedown = DEF_KS_PAGEDOWN;
#ifdef GREEK_SUPPORT
KeySym ks_greektoggle = DEF_KS_GREEKTOGGLE;
#endif
#ifdef SECURE_KBD
KeySym ks_secure = DEF_KS_SECURE;
#endif

#ifdef MULTIPLE_CLICKS
char *rs_cutchars = NULL;
#endif

/*----------------------------------------------------------------------*
 * local variables
 */
static int Xscreen;		/* the X screen number */

static XSizeHints sizehint = {
   PMinSize | PResizeInc | PBaseSize | PWinGravity,
   0, 0, 80, 24,	/* x, y, width and height */
   1, 1,		/* Min width and height */
   0, 0,		/* Max width and height */
   1, 1,		/* Width and height increments */
   {0, 0}, {0, 0},	/* Aspect ratio - not used */
   2 * MARGIN, 2 * MARGIN,		/* base size */
   NorthWestGravity                /* gravity */
};

/*----------------------------------------------------------------------*
 * extern functions referenced
 */
extern void extract_resources (void);

/*----------------------------------------------------------------------*
 * local functions
 */
static void create_window (int argc, char *argv[]);

/*----------------------------------------------------------------------*/
static void
usage (void)
{
   fprintf(stderr,\
"v"RXVT_VERSION" usage:\n"\
"\trxvt [options ...] [-e command args]\n\n"\
"where options include:\n"\
"  -display displayname  X server to contact\n"\
"  -geometry geom        size (in characters) and position\n"\
"  -bg color             background color\n"\
"  -fg color             foreground color\n");
#ifdef COLOR
   fprintf(stderr,\
"  -color<n> color       color <n>, where <n> = [0-7]"
#ifndef USE_FAKE_BOLD
	   ", 1[0-7]"
#endif
	   "\n");
#endif
   fprintf(stderr,\
"  -fn fontname          normal font\n");
#ifndef SINGLE_FONT
   fprintf(stderr,\
"  -font<n> fontname     alternative font <n>, where <n> is 1 to %d\n",NFONTS);
#endif
   fprintf(stderr,\
"  -name string          client instance, icon, and title strings\n"\
"  -title string         title name for window\n"\
"  -T string             title name for window\n"\
"  -n string             icon and title name for window\n"\
"  -/+ls                 turn on/off login shell\n");
#ifdef UTMP_SUPPORT
   fprintf(stderr,\
"  -/+ut                 turn on/off utmp inhibit\n");
#endif
#ifdef MAPALERT
   fprintf(stderr,\
"  -/+ma                 turn on/off deiconify (map) on audio alert\n");
#endif
#ifdef VISUAL_BELL
   fprintf(stderr,\
"  -/+vb                 turn on/off visual bell\n");
#endif
#ifdef SCROLLBAR_ANY
   fprintf(stderr,\
"  -/+sb                 turn on/off scrollbar\n"\
"  -/+arrows             turn on/off scrollbar arrows\n");
#endif	/* ANY */
   fprintf(stderr,\
"  -ic                   start iconic\n");
#ifndef ALWAYS_META_ESCAPE
   fprintf(stderr,\
"  -/+meta               Meta key as Escape prefix on/off\n"\
"  -meta8                Meta key as 8bit set\n");
#endif
   fprintf(stderr,\
"  -sl number            number of scrolled lines to save\n");
#ifndef NO_REFRESH_RESOURCE
   fprintf(stderr,\
"  -refresh number       maximum number of buffered screenfuls\n");
#endif
#ifdef GREEK_KBD
   fprintf(stderr,\
"  -grk9                 greek kbd - ELOT 928 (default)\n"\
"  -grk4                 greek kbd - IBM 437\n");
#endif
#ifdef PRINT_PIPE
   fprintf(stderr,\
"  -print-pipe name      specify pipe for vt100 printer\n");
#endif
#ifndef NO_7BIT_MODE
   fprintf(stderr,\
"  -/+7                  turn on/off 7 bit mode\n");
#endif

#ifdef NO_RESOURCES
   /* only do these options if there is no resource way */
#ifdef SECURE_KBD
   fprintf(stderr,\
"  -secure keysym        "HOTKEY_KEYSYM" to enter secure mode\n");
#endif
   fprintf(stderr,\
"  -pageup keysym        "HOTKEY_KEYSYM" to scroll up\n"\
"  -pagedown keysym      "HOTKEY_KEYSYM" to scroll down\n");
#ifndef SINGLE_FONT
   fprintf(stderr,\
"  -bigfont keysym       "HOTKEY_KEYSYM" to switch to a bigger font\n"\
"  -smallfont keysym     "HOTKEY_KEYSYM" to switch to a smaller font\n");
#endif
#ifdef PRINT_PIPE
   fprintf(stderr,\
"  -prkey keysym         keysym to print screen\n");
#endif
#endif	/* NO_RESOURCES */

   fprintf(stderr,\
"  -C                    intercept console messages\n"\
"  -e command arg ...    command to execute\n");
}

char *
basename (char *string)
{
   char *base;
   return ((base = strrchr (string, '/')) == NULL) ? string : base + 1;
}

void
String2Keysym (KeySym *keysym, char *string)
{
   KeySym ks;
   if (string != NULL && ((ks = XStringToKeysym (string)) != 0))
     *keysym = ks;
}

static XErrorHandler
RxvtErrorHandler (Display *dpy, XErrorEvent *event)
{
   exit (EXIT_FAILURE);
   return 0;
}

/* Open the display, initialise the rdb resources database and create the
 * window.  If title is non null then it is used as the window and icon title.
 * iargc and iargv are the original argc, argv so the can be written to a
 * COMMAND resource.
 */
void
init_display (int argc, char *argv[], char *cmd)
{
   static char id_string [29], *display_string;
   char *opt, *val;
   XGCValues gcv;
   int i, n, bad_option = 0;

   rs_name = basename (argv [0]);

   if (cmd != NULL)
     rs_title = basename (cmd);

   if ((display_name = getenv ("DISPLAY")) == NULL)
     display_name = ":0";

   /* first pass (before getting resources),
    * MUST find -display & -name (if they exist)
    *
    * also find other options that take a string type of options
    * so as to avoid allocating space twice
    */
   for (i = 1; i < argc; i++)
     {
	opt = argv [i];
	val = argv [i+1];

	if (*opt != '-' || val == NULL) continue;
	opt++;

	if (!strcmp(opt, "display"))	{ display_name = val; }
	else if (!strcmp(opt, "name"))	{ rs_name = val; }
	else if (!strcmp(opt, "title") || !strcmp(opt, "T"))
	  { rs_title = val; }
	else if (!strcmp(opt, "n"))
	  {
	     rs_iconName = val;
	     if (rs_title == NULL)
	       rs_title = val;
	  }
	else if (!strcmp(opt, "geometry"))	{ rs_geometry = val; }
	else if (!strcmp(opt, "fn") && val)	{ rs_font [0] = val; }
	else if (!strncmp(opt, "font", 4))
	  {
	     opt += 4;
	     n = (*opt ? atoi (opt) : 0);
	     if (n >= 0 && n < NFONTS)
	       rs_font [n] = val;
	  }
	else if (!strcmp(opt, "fg"))	{ rs_color [FG_COLOR] = val; }
	else if (!strcmp(opt, "bg"))	{ rs_color [BG_COLOR] = val; }
	else if (!strncmp(opt, "color", 5))
	  {
	     opt += 5;
#ifdef COLOR
	     n = (*opt ? atoi (opt) : -1);
	     if (n >= 0 && n <= 7)		/* normal colors */
	       rs_color [n + ANSI_COLOR0] = val;
#ifndef USE_FAKE_BOLD
	     else if (n >= 10 && n <= 17)	/* bold colors */
	       rs_color [n-10 + BOLD_COLOR0] = val;
#endif
#endif
	  }
#ifdef PRINT_PIPE
	else if (!strcmp(opt, "print-pipe"))	{ rs_print_pipe = val; }
#endif
	else continue;		/* not a string option, skip */

	argv [i] = NULL;
	i++;
	argv [i] = NULL;
     }

   if (!(Xdisplay = XOpenDisplay (display_name)))
     {
	print_error ("can't open display %s", display_name);
	exit (EXIT_FAILURE);
     }

   Xscreen = DefaultScreen (Xdisplay);
   Xdepth  = DefaultDepth (Xdisplay, Xscreen);

   /* set some fallback values */
   RxvtWin.scrollback = DEF_SCROLLBACK;
#ifdef SCROLLBAR_ANY
   sbar.type = DEF_SCROLLBAR;
#endif

   extract_resources ();

   /* now get all the options */
   for (i = 1; i < argc; i++)
     {
	opt = argv [i];
	if (opt == NULL) continue;	/* already processed */
	val = argv [i+1];

	if (!strcmp(opt, "-C"))	{ console = 1; }
#ifndef NO_7BIT_MODE
	else if (!strcmp(opt, "-7"))	{ hibit_mask = 0x7F; }
	else if (!strcmp(opt, "+7"))	{ hibit_mask = 0xFF; }
#endif
	else if (!strcmp(opt, "-ls"))	{ login_shell = 1; }
	else if (!strcmp(opt, "+ls"))	{ login_shell = 0; }
#ifdef UTMP_SUPPORT
	else if (!strcmp(opt, "-ut"))	{ utmp_inhibit = 1; }
	else if (!strcmp(opt, "+ut"))	{ utmp_inhibit = 0; }
#endif
#ifdef SCROLLBAR_ANY
	else if (!strcmp(opt, "-sb"))
	  { if (sbar.type == SBAR_IGNORE) sbar.type = SBAR_NOARROWS; }
	else if (!strcmp(opt, "+sb"))	{ sbar.type = SBAR_IGNORE; }
	else if (!strncmp(opt, "-arrow", 6))
	  { sbar.type = SBAR_ARROWS; }
	else if (!strncmp(opt, "+arrow", 6))
	  { if (sbar.type == SBAR_ARROWS) sbar.type = SBAR_NOARROWS; }
#endif	/* ANY */
#ifdef MAPALERT
	else if (!strcmp(opt, "-ma"))	{ map_alert = 1; }
	else if (!strcmp(opt, "+ma"))	{ map_alert = 0; }
#endif
#ifdef VISUAL_BELL
	else if (!strcmp(opt, "-vb"))	{ visual_bell = 1; }
	else if (!strcmp(opt, "+vb"))	{ visual_bell = 0; }
#endif
	else if (!strncmp(opt, "-ic", 3))	{ iconic = 1; }
#ifndef ALWAYS_META_ESCAPE
	else if (!strcmp(opt, "-meta8"))	{ MetaHandling = 0x80; }
	else if (!strcmp(opt, "-meta"))		{ MetaHandling = 033; }
	else if (!strcmp(opt, "+meta"))		{ MetaHandling = 0; }
#endif
#ifdef GREEK_KBD
	else if (!strcmp(opt, "-grk9"))	{ GreekMode = GREEK_ELOT928; }
	else if (!strcmp(opt, "-grk4"))	{ GreekMode = GREEK_IBM437; }
#endif

#ifdef NO_RESOURCES
   /* only bother with these command-line options if there is no resource
    * way to do it
    */

#ifdef PRINT_PIPE
	else if (!strcmp(opt, "-prkey") && val)
	  { i++; String2Keysym (&ks_printscreen, val); }
#endif
#ifdef SECURE_KBD
	else if ( !strcmp(opt, "-secure") && val)
	  { i++; String2Keysym (&ks_secure, val); }
#endif
#ifndef SINGLE_FONT
	else if ( !strcmp(opt, "-bigfont") && val)
	  { i++; String2Keysym (&ks_bigfont, val); }
	else if ( !strcmp(opt, "-smallfont") && val)
	  { i++; String2Keysym (&ks_smallfont, val); }
#endif
	else if ( !strcmp(opt, "-pageup") && val)
	  { i++; String2Keysym (&ks_pageup, val); }
	else if ( !strcmp(opt, "-pagedown") && val)
	  { i++; String2Keysym (&ks_pagedown, val); }

#endif	/* NO_RESOURCES */

	else if ( !strcmp(opt, "-sl") && val)
	  {
	     i++;
	     RxvtWin.scrollback = atoi (val);
	     if (RxvtWin.scrollback < 0)
	       RxvtWin.scrollback = 0;
	  }
#ifndef NO_REFRESH_RESOURCE
	else if (!strcmp(opt, "-refresh") && val)
	  { i++; refresh_period = atoi(val); }
#endif
	else if (!strcmp(opt, "-help"))
	  {
	     usage ();
	     exit (EXIT_FAILURE);
	  }
	else
	  {
	     bad_option = 1;
	     print_error ("Bad option %s", opt);
	  }
     }
   if (bad_option)
     {
	print_error ("for usage use -help");
	exit (EXIT_FAILURE);
     }

   /* set any defaults not already set */

   if (rs_title == NULL) rs_title = rs_name;
   if (rs_iconName == NULL) rs_iconName = rs_name;

   if (rs_geometry == NULL) rs_geometry = DEF_GEOMETRY;
   if (rs_font [0] == NULL) rs_font [0] = DEF_FONT0;
#ifndef SINGLE_FONT
   if (rs_font [1] == NULL) rs_font [1] = DEF_FONT1;
   if (rs_font [2] == NULL) rs_font [2] = DEF_FONT2;
   if (rs_font [3] == NULL) rs_font [3] = DEF_FONT3;
   if (rs_font [4] == NULL) rs_font [4] = DEF_FONT4;
#endif
#ifdef PRINT_PIPE
   if (rs_print_pipe == NULL) rs_print_pipe = DEF_PRINTPIPE;
#endif
#ifdef MULTIPLE_CLICKS
   if (rs_cutchars == NULL) rs_cutchars = DEF_CUTCHARS;
#endif

   if (rs_color [FG_COLOR] == NULL) rs_color [FG_COLOR] = DEF_FGNAME;
   if (rs_color [BG_COLOR] == NULL) rs_color [BG_COLOR] = DEF_BGNAME;
#ifdef COLOR
   if (rs_color [ANSI_COLOR0] == NULL) rs_color [ANSI_COLOR0] = DEF_COLOR0;
   if (rs_color [ANSI_COLOR1] == NULL) rs_color [ANSI_COLOR1] = DEF_COLOR1;
   if (rs_color [ANSI_COLOR2] == NULL) rs_color [ANSI_COLOR2] = DEF_COLOR2;
   if (rs_color [ANSI_COLOR3] == NULL) rs_color [ANSI_COLOR3] = DEF_COLOR3;
   if (rs_color [ANSI_COLOR4] == NULL) rs_color [ANSI_COLOR4] = DEF_COLOR4;
   if (rs_color [ANSI_COLOR5] == NULL) rs_color [ANSI_COLOR5] = DEF_COLOR5;
   if (rs_color [ANSI_COLOR6] == NULL) rs_color [ANSI_COLOR6] = DEF_COLOR6;
   if (rs_color [ANSI_COLOR7] == NULL) rs_color [ANSI_COLOR7] = DEF_COLOR7;
#ifndef USE_FAKE_BOLD
   if (rs_color [BOLD_COLOR0] == NULL) rs_color [BOLD_COLOR0] = DEF_COLOR10;
   if (rs_color [BOLD_COLOR1] == NULL) rs_color [BOLD_COLOR1] = DEF_COLOR11;
   if (rs_color [BOLD_COLOR2] == NULL) rs_color [BOLD_COLOR2] = DEF_COLOR12;
   if (rs_color [BOLD_COLOR3] == NULL) rs_color [BOLD_COLOR3] = DEF_COLOR13;
   if (rs_color [BOLD_COLOR4] == NULL) rs_color [BOLD_COLOR4] = DEF_COLOR14;
   if (rs_color [BOLD_COLOR5] == NULL) rs_color [BOLD_COLOR5] = DEF_COLOR15;
   if (rs_color [BOLD_COLOR6] == NULL) rs_color [BOLD_COLOR6] = DEF_COLOR16;
   if (rs_color [BOLD_COLOR7] == NULL) rs_color [BOLD_COLOR7] = DEF_COLOR17;
#endif	/* USE_FAKE_BOLD */
#endif	/* COLOR */

   if (argc)
     {
	argc = 1;
	argv[1] = NULL;
     }
   create_window (argc, argv);

   /* Add a DISPLAY entry to the environment, in case we started with
    * rxvt -display name */

    /* Add a DISPLAY entry to the environment, in case we started with
     * rxvt -display name. */

#ifdef DISPLAY_ENV_AND_ANSWER_IS_IP
   /* Fixup display_name for export over pty to any interested terminal clients
    * via "Esc-[7n" (e.g. shells).
    * Note that we use the pure IP number
    * (for the first non-loopback interface)
    * that we get from network_display.  This is
    * more "name-resolution-portable", if you will, and probably allows for
    * faster x-client startup if your name server is beyond a slow link or
    * overloaded at client startup.  Of course that only helps the shell's
    * child processes, not us.
    */
     {
	extern char * network_display (char* actual_display);
	display_name = val = network_display (display_name);
     }
#else /* use old, broken DISPLAY of :0 even through a remote login... */
   val = XDisplayString (Xdisplay);
#endif
   i = strlen (val);

   display_string = MALLOC (i+10,"display_string");
     sprintf (display_string, "DISPLAY=%s", val);

   val = XDisplayString (Xdisplay);
   i = strlen (val);
   display_string = MALLOC (i+10,"display_string");
   sprintf (display_string, "DISPLAY=%s", val);
   sprintf (id_string,"WINDOWID=%u",(unsigned int)RxvtWin.parent);

   putenv (display_string);
   putenv (id_string);

   scr_init ();			/* initialise the screen data structures */

   /* Create the graphics contexts */
   gcv.font = Xfont->fid;
   gcv.foreground = pixel_colors [BG_COLOR];
   gcv.background = pixel_colors [FG_COLOR];
   Xrvgc = XCreateGC (Xdisplay, RxvtWin.parent,
		      GCForeground|GCBackground|GCFont, &gcv);
   gcv.foreground = pixel_colors [FG_COLOR];
   gcv.background = pixel_colors [BG_COLOR];
   Xgc = XCreateGC (Xdisplay, RxvtWin.parent,
		    GCForeground|GCBackground|GCFont, &gcv);

   sbar_init (&gcv);		/* initialise the scrollbar */

#ifdef DEBUG_X
   XSynchronize (Xdisplay, True);
   XSetErrorHandler ((XErrorHandler)abort);
#else
    XSetErrorHandler((XErrorHandler)RxvtErrorHandler);
#endif
}

/* Open and map the window */
static void
create_window (int argc, char *argv[])
{
   Colormap cmap;		/* colormap */
   XColor   xcolor_bg, xcolor_fg, xcolor_black, xcolor_white;
   XClassHint xcls;
   XWMHints wmhint;
   Cursor cursor;
   int i, flags, x, y;
   int width, height;

   /* First get the font since we need it to set the size */
   Xfont = XLoadQueryFont (Xdisplay, rs_font [0]);
   if (!Xfont)
     {
	print_error ("can't access font %s\ntrying fixed font\n", rs_font [0]);
	rs_font[0] = "fixed";	/* everyone should have `fixed' */
	Xfont = XLoadQueryFont (Xdisplay, rs_font [0]);
	if (!Xfont)
	  {
	     print_error ("can't access font %s\ngiving up", rs_font [0]);
	     exit (EXIT_FAILURE);
	  }
     }

#ifndef SCROLLBAR_NONE
   sizehint.base_width += SBAR_WIDTH;
#endif	/* SCROLLBAR_NONE */

   sizehint.width_inc = XTextWidth (Xfont, "MMMMMMMMMM",10) / 10;
   sizehint.height_inc = Xfont->ascent + Xfont->descent;
   flags = XParseGeometry (rs_geometry, &x, &y, &width, &height);
   if (flags & WidthValue)
     {
	sizehint.width = width;
	sizehint.flags |= USSize;
     }
   if (flags & HeightValue)
     {
	sizehint.height = height;
	sizehint.flags |= USSize;
     }

   RxvtWin.cols = sizehint.width;
   RxvtWin.rows = sizehint.height;
   RxvtWin.fheight = sizehint.height_inc;
   RxvtWin.fwidth  = sizehint.width_inc;
   RxvtWin.pwidth  = RxvtWin.cols * RxvtWin.fwidth;
   RxvtWin.pheight = RxvtWin.rows * RxvtWin.fheight;

   sizehint.width  = (sizehint.width * sizehint.width_inc
		      + sizehint.base_width);
   sizehint.height = (sizehint.height * sizehint.height_inc
		      + sizehint.base_height);
   sizehint.min_width  = sizehint.width_inc  + sizehint.base_width;
   sizehint.min_height = sizehint.height_inc + sizehint.base_height;
   if (flags & XValue)
     {
	if (flags & XNegative)
	  {
	     x += DisplayWidth (Xdisplay, Xscreen) - sizehint.width - MARGIN;
	     sizehint.win_gravity = NorthEastGravity;
	  }
	sizehint.x = x;
	sizehint.flags |= USPosition;
     }
   if (flags & YValue)
     {
	if (flags & YNegative)
	  {
	     y += DisplayHeight (Xdisplay, Xscreen) - sizehint.height - MARGIN;
	     if ((flags&XValue) && (flags&XNegative))
	       sizehint.win_gravity = SouthEastGravity;
	     else
	       sizehint.win_gravity = SouthWestGravity;
	  }
	sizehint.y = y;
	sizehint.flags |= USPosition;
     }

   cmap = DefaultColormap (Xdisplay, Xscreen);

   /* get black and white */
   if (!XParseColor (Xdisplay, cmap, "black", &xcolor_black) ||
       !XAllocColor (Xdisplay, cmap, &xcolor_black))
     {
	print_error ("couldn't allocate black");
	exit (EXIT_FAILURE);	/* really can't go on */
     }

   if (!XParseColor (Xdisplay, cmap, "white", &xcolor_white) ||
       !XAllocColor (Xdisplay, cmap, &xcolor_white))
     {
	print_error ("couldn't allocate white");
	exit (EXIT_FAILURE);	/* really can't go on */
     }

   /* done with `flags', reuse in case of allocation errors */

   i = 0;			/* no error so far */
   /* Do the foreground, and background colors */
   if (!XParseColor (Xdisplay, cmap, rs_color [FG_COLOR], &xcolor_fg) ||
       !XAllocColor (Xdisplay, cmap, &xcolor_fg))
     {
	print_error ("bad color name or couldn't allocate %s",
		     rs_color [FG_COLOR]);
	i = 1;
     }
   else
     pixel_colors [FG_COLOR] = xcolor_fg.pixel;

   if (!XParseColor (Xdisplay, cmap, rs_color [BG_COLOR], &xcolor_bg) ||
       !XAllocColor (Xdisplay, cmap, &xcolor_bg))
     {
	print_error ("couldn't allocate color %s", rs_color [BG_COLOR]);
	i = 1;
     }
   else
     pixel_colors [BG_COLOR] = xcolor_bg.pixel;

   if (i)
     {
	pixel_colors [FG_COLOR] = xcolor_black.pixel;
	pixel_colors [BG_COLOR] = xcolor_white.pixel;
	xcolor_bg = xcolor_white;
	xcolor_fg = xcolor_black;
     }
   /*
    * allocate all the colors here, before netscape gets them :)
    * already did foreground/background
    */
#ifdef COLOR
   for (i = 2; i < NCOLORS; i++)
     {
	XColor xcol;

	if (!XParseColor (Xdisplay, cmap, rs_color [i], &xcol) ||
	    !XAllocColor (Xdisplay, cmap, &xcol))
	  {
	     print_error ("couldn't allocate color %s", rs_color [i]);
	     pixel_colors [i] = xcolor_black.pixel;	/* assign black */
	  }
	else
	  pixel_colors [i] = xcol.pixel;
     }
#endif

   /* create the window */
   RxvtWin.parent = XCreateSimpleWindow (Xdisplay,
					 DefaultRootWindow (Xdisplay),
					 sizehint.x, sizehint.y,
					 sizehint.width, sizehint.height,
					 1,
					 pixel_colors [FG_COLOR],
					 pixel_colors [BG_COLOR]);

   change_xterm_name (NEW_TITLE_NAME, rs_title);
   change_xterm_name (NEW_ICON_NAME, rs_iconName);
   xcls.res_name = rs_name;
   xcls.res_class = RXVT_CLASS;
   wmhint.input = True;
   if (iconic)
     wmhint.initial_state = IconicState;
   else
     wmhint.initial_state = NormalState;
   wmhint.flags = InputHint | StateHint;
   XSetWMProperties (Xdisplay, RxvtWin.parent, NULL, NULL, argv, argc,
		     &sizehint, &wmhint, &xcls);

   XSelectInput (Xdisplay, RxvtWin.parent,
		 (KeyPressMask|FocusChangeMask|
		  StructureNotifyMask|VisibilityChangeMask)
		 );

#ifndef SCROLLBAR_NONE
   sbar.w = 0;
#ifdef SCROLLBAR_ANY
   if (sbar.type != SBAR_IGNORE)
#endif
     {
	sbar.w = SBAR_WIDTH - 1;
	sbar.h = sizehint.height;

	sbar.sb.win = XCreateSimpleWindow (Xdisplay, RxvtWin.parent,
					   -1, -1,
					   sbar.w, sbar.h,
					   1,
					   pixel_colors [FG_COLOR],
					   pixel_colors [BG_COLOR]);
	cursor = XCreateFontCursor (Xdisplay, XC_sb_v_double_arrow);
	/* black on white cursor */
	XRecolorCursor (Xdisplay, cursor, &xcolor_black, &xcolor_white);
	XDefineCursor (Xdisplay, sbar.sb.win, cursor);

	XSelectInput (Xdisplay, sbar.sb.win,
		      (ExposureMask|ButtonPressMask|ButtonReleaseMask|
		       Button1MotionMask|Button2MotionMask|Button3MotionMask)
		      );
#ifndef SCROLLBAR_NOARROWS
#ifdef SCROLLBAR_ANY
	if (sbar.type == SBAR_ARROWS)
#endif	/* ANY */
	  {
	     sbar.up.win = XCreateSimpleWindow (Xdisplay, sbar.sb.win,
						-1, -1,
						sbar.w, SBAR_WIDTH,
						1,
						pixel_colors [FG_COLOR],
						pixel_colors [BG_COLOR]);

	     sbar.dn.win = XCreateSimpleWindow (Xdisplay, sbar.sb.win,
						-1, sbar.h - (SBAR_WIDTH+1),
						sbar.w, SBAR_WIDTH,
						1,
						pixel_colors [FG_COLOR],
						pixel_colors [BG_COLOR]);

	     cursor = XCreateFontCursor (Xdisplay, XC_sb_left_arrow);
	     /* black on white cursor */
	     XRecolorCursor (Xdisplay, cursor, &xcolor_black, &xcolor_white);
	     XDefineCursor (Xdisplay, sbar.up.win, cursor);
	     XDefineCursor (Xdisplay, sbar.dn.win, cursor);

	     XSelectInput (Xdisplay, sbar.up.win,
			   (ExposureMask|EnterWindowMask|
			    LeaveWindowMask|ButtonPressMask));
	     XSelectInput (Xdisplay, sbar.dn.win,
			   (ExposureMask|EnterWindowMask |
			    LeaveWindowMask|ButtonPressMask));

	     XMapWindow (Xdisplay, sbar.up.win);
	     XMapWindow (Xdisplay, sbar.dn.win);

	     sbar.h -= 2 * SBAR_WIDTH;	/* account for arrows */
	  }
#endif	/* ! SCROLLBAR_NOARROWS */
	XMapWindow (Xdisplay, sbar.sb.win);
     }
#endif	/* ! SCROLLBAR_NONE */

   RxvtWin.vt = XCreateSimpleWindow (Xdisplay, RxvtWin.parent,
#ifndef SCROLLBAR_NONE
				     sbar.w+1, 0, sizehint.width-(sbar.w+1),
#else
				     1, 0, sizehint.width-1,
#endif
				     sizehint.height,
				     0,
				     pixel_colors [FG_COLOR],
				     pixel_colors [BG_COLOR]);
   cursor = XCreateFontCursor (Xdisplay, XC_xterm);

   /* black on white cursor, but this is more popular */
   XRecolorCursor (Xdisplay, cursor, &xcolor_fg, &xcolor_bg);

   XDefineCursor (Xdisplay, RxvtWin.vt, cursor);
   XSelectInput (Xdisplay, RxvtWin.vt,
		 (ExposureMask|ButtonPressMask|ButtonReleaseMask|
		  Button1MotionMask|Button3MotionMask));

   XMapWindow (Xdisplay, RxvtWin.vt);
   XMapWindow (Xdisplay, RxvtWin.parent);
}

/* Redraw the whole window after an exposure or size change.
 */
void
resize_window (int width, int height)
{
   static int last_width = -1, last_height = -1;
   int new_w, new_h, curr_w, curr_h, curr_screen;

   if (width == 0)
     {
	int x, y, bwidth, depth;
	Window root;
	XEvent dummy;

	while (XCheckTypedWindowEvent (Xdisplay, RxvtWin.parent,
				       ConfigureNotify, &dummy));
	XGetGeometry (Xdisplay, RxvtWin.parent,
		      &root, &x, &y, &width, &height, &bwidth, &depth);
     }
#ifndef SCROLLBAR_NONE
   new_w = (width - sbar.w - 2*MARGIN) / RxvtWin.fwidth;
#else
   new_w = (width - 2*MARGIN) / RxvtWin.fwidth;
#endif
   new_h = (height - 2*MARGIN) / RxvtWin.fheight;
   if ((last_width != width) || (last_height != height) ||
       (new_w != RxvtWin.cols) || (new_h != RxvtWin.rows)
       )
     {
	curr_screen = -1;
	curr_w = RxvtWin.pwidth;
	curr_h = RxvtWin.pheight;

	/* scr_reset will only work on the primary screen! */
	if (last_width >= 0)	/* not first time thru */
	  {
	     scr_selection_clear ();
	     curr_screen = scr_change_screen (PRIMARY);
	  }

	last_width  = width;
	last_height = height;

	RxvtWin.rows = new_h;
	RxvtWin.cols = new_w;

	RxvtWin.pwidth  = RxvtWin.cols * RxvtWin.fwidth;
	RxvtWin.pheight = RxvtWin.rows * RxvtWin.fheight;

#ifndef SCROLLBAR_NONE
#ifdef SCROLLBAR_ANY
	if (sbar.type != SBAR_IGNORE)
#endif
	  {
	     XResizeWindow (Xdisplay, sbar.sb.win, sbar.w, height);
	     width -= sbar.w;
	  }
	sbar.h = height;
#ifndef SCROLLBAR_NOARROWS
#ifdef SCROLLBAR_ANY
	if (sbar.type == SBAR_ARROWS)
#endif
	  {
	     sbar.h -= 2 * sbar.w;
	     XMoveWindow (Xdisplay, sbar.dn.win, -1, height-(SBAR_WIDTH+1));
	  }
#endif	/* ! NOARROWS */

#endif	/* SCROLLBAR_NONE */

	XResizeWindow (Xdisplay, RxvtWin.vt, width, height+1);
	Gr_Resize (curr_w, curr_h);
	XClearWindow (Xdisplay, RxvtWin.vt);
	XSync (Xdisplay, 0);
	scr_reset ();

	if (curr_screen >= 0)	/* not first time thru */
	  scr_change_screen (curr_screen);
     }
}

/* good for toggling 80/132 column mode */
void
set_width (int cols)
{
   int w, h;

   if (cols <= 0 || cols == RxvtWin.cols)
     return;

   w = cols * RxvtWin.fwidth + sizehint.base_width;
   h = RxvtWin.rows * RxvtWin.fheight + sizehint.base_height;

   sizehint.width = w;
   sizehint.height = h;
   sizehint.flags = PMinSize | PResizeInc | PBaseSize | PWinGravity;

   XSetWMNormalHints (Xdisplay, RxvtWin.parent, &sizehint);
   XResizeWindow (Xdisplay, RxvtWin.parent, w, h);
   XClearWindow (Xdisplay, RxvtWin.vt);
   XSync (Xdisplay, 0);
   resize_window (w, h);
}

/*
 * Print an error message.
 */
void
print_error (char *fmt, ...)
{
   va_list arg_ptr;

   va_start (arg_ptr, fmt);
   fprintf (stderr,"%s: ", rs_name);
   vfprintf (stderr, fmt, arg_ptr);
   fprintf (stderr,"\n");
   va_end (arg_ptr);
}

/*
 * change title/icon name
 */
void
change_xterm_name (int op, char *string)
{
   XTextProperty name;

   if (!XStringListToTextProperty (&string, 1, &name))
     {
	print_error ("can't allocate title/icon name");
	return;
     }

   switch (op) {
    case NEW_NAMES:
      XSetWMName (Xdisplay, RxvtWin.parent, &name);	/* drop */
    case NEW_ICON_NAME:
      XSetWMIconName (Xdisplay, RxvtWin.parent, &name);	break;
    case NEW_TITLE_NAME:
      XSetWMName (Xdisplay, RxvtWin.parent, &name);	break;
   }
   XFree (name.value);
}

#ifndef SINGLE_FONT
/*
 * Switch to a new font
 */
void
new_font (int direction)
{
   static int font_num = NORM_FONT;
   char *this_font;
   int w, h;

   if (direction == UP)
     {
	font_num++;
	if (font_num >= NFONTS)
	  {
	     font_num = NFONTS-1;
	     return;
	  }
     }
   else if (direction == DOWN)
     {
	font_num--;
	if (font_num < 0)
	  {
	     font_num = 0;
	     return;
	  }
     }
   else
     return;

   /* take case of shuffling font_numbers */

   if (font_num == NORM_FONT)	/* Normal font */
     this_font = rs_font [0];
   else if (font_num > NORM_FONT)
     this_font = rs_font [font_num];
   else
     this_font = rs_font [font_num +1];

   XFreeFont (Xdisplay, Xfont);
   Xfont = XLoadQueryFont (Xdisplay, this_font);
   if (!Xfont)
     {
	print_error ("can't access font %d: %s\n", font_num, this_font);
	Xfont = XLoadQueryFont (Xdisplay, rs_font [0]);
     }
   XSetFont (Xdisplay, Xgc, Xfont->fid);
   XSetFont (Xdisplay, Xrvgc, Xfont->fid);

   w = XTextWidth (Xfont, "MMMMMMMMMM",10) / 10;
   h = Xfont->ascent + Xfont->descent;
   if ((RxvtWin.fwidth == w) && (RxvtWin.fheight == h))
     return;

   RxvtWin.fwidth  = w;
   RxvtWin.fheight = h;
   RxvtWin.pwidth  = w * RxvtWin.cols;
   RxvtWin.pheight = h * RxvtWin.rows;

   sizehint.width_inc  = w;
   sizehint.height_inc = h;
   sizehint.min_width  = w + sizehint.base_width;
   sizehint.min_height = h + sizehint.base_height;

   w = w * RxvtWin.cols + sizehint.base_width;
   h = h * RxvtWin.rows + sizehint.base_height;
   sizehint.width  = w;
   sizehint.height = h;

   sizehint.flags = PMinSize | PResizeInc | PBaseSize | PWinGravity;
   XSetWMNormalHints (Xdisplay, RxvtWin.parent, &sizehint);
   XResizeWindow (Xdisplay, RxvtWin.parent, w, h);
   XClearWindow (Xdisplay, RxvtWin.vt);
   XSync (Xdisplay, 0);
}
#endif
/*----------------------- end-of-file (C source) -----------------------*/
