#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <signal.h>
#include "graphics_lib.h"

static void
axis_round (float *min, float *max,float *grid_spacing)
{
   float diff;
   int logspacing;

   diff = *max  - *min;

   logspacing = (int)(log10((diff)/10.0)+0.5);
   *grid_spacing = pow((double)10,(double)logspacing);
   *min = (float)((int)(*min/(*grid_spacing)))* (*grid_spacing);
   *max = (float)((int)(*max/(*grid_spacing))+1)* (*grid_spacing);
}

static int 
nice_end (int junk)
{
   CloseGraphics ();
   putchar ('\n');
   exit (EXIT_SUCCESS);
   return 0;
}

int
main (int argc, char **argv)
{
   char line[256], *file = NULL;
   long id,winclick;
   int Do_Start = 1,tmp;
   float x[1000000], y[1000000];
   float nls[1000];
   int m,p,i,j,n,nchars,theight,twidth,xclick,yclick;
   int downx=1000,downy=1000,upx,upy;
   float xmax,xmin,ymax,ymin,xdiff,ydiff,xgrid_spacing, ygrid_spacing;
   FILE *fd;
   char axis[100];

   LineFunction linetype = StartLine;

   ymax = xmax = -HUGE_VAL;
   ymin = xmin = HUGE_VAL;

   for (i = 1; i < argc; i++)
     {
	if (strcasecmp(argv[i],"-nl") == 0)
	  linetype = StartPoint;
	else if(argv[i][0] != '-')
	  file = argv[i];
     }

   if (file == NULL)
     {
	fd = stdin;
	file = "Rob's QuickPlot";
     }
   else
     {
	fd = fopen (file, "r");
	if (fd == NULL)
	  {
	     fprintf (stderr, "%s: Can't open file %s\n",argv[0], file);
	     return EXIT_FAILURE;
	  }
     }
   m = 0;
   p = 0;
   while (fgets(line, sizeof(line),fd) != NULL)
     {
	if (sscanf(line,"%f %f",&x[m], &y[m]) == 2)
	  {
	     if (x[m] > xmax) xmax = x[m]; else if (x[m] < xmin) xmin = x[m];
	     if (y[m] > ymax) ymax = y[m]; else if (y[m] < ymin) ymin = y[m];
	     m++;
	  }
	else
	  {
	     nls[p] = m;
	     p++;
	  }
     }
   nls[p++] = m;

   if (m == 0)
     return;

   signal(SIGTERM, nice_end);
   signal(SIGSTOP, nice_end);
   signal(SIGTSTP, nice_end);
   signal(SIGINT,  nice_end);
   signal(SIGQUIT, nice_end);
   if (!InitializeGraphics (1))
     return EXIT_FAILURE;

   n = 1;
   while (n != 0)
     {
	axis_round(&xmin, &xmax,&xgrid_spacing);
	axis_round(&ymin, &ymax,&ygrid_spacing);

	id = CreateWin (0, 0, 10000, 10000);
	if (id == 0)
	  {
	     fprintf (stderr,"Help id = 0\n");
	     return EXIT_FAILURE;
	  }
	/* Fill the window in black for real eye-catching graphics! */
	ForeColor (0);
	StartFill (id);
	FillArea (0, 0, 10000, 10000);
	Done ();

	/* draw outline box in white */
	ForeColor (7);

	/* Draw outline box */
	StartLine(id);
	Extend (1000, 1000);
	Extend (1000, 9000);
	Extend (9000, 9000);
	Extend (9000, 1000);
	Extend (1000, 1000);
	Done();

	/* Draw the data - either lines or dots */
	i = 0;
	j = 0;
	xdiff = 8000 / (xmax-xmin);
	ydiff = 8000 / (ymax-ymin);

	n = 0;
	while (j < p)
	  {
	     ForeColor (j%6+1);
	     while (((x[i] < xmin)||(x[i] > xmax)||
		     (y[i] < ymin)||(y[i] > ymax))&&(i<nls[j]))
	       i++;

	     while (i < nls[j])
	       {
		  if (n == 0)
		    linetype (id);
		  Extend (1000+(x[i]-xmin)*xdiff,9000-(y[i]-ymin)*ydiff);
		  n++;
		  if (n > 450)
		    {
		       Done ();
		       linetype (id);
		       Extend (1000+(x[i]-xmin)*xdiff,9000-(y[i]-ymin)*ydiff);
		       n = 1;
		    }
		  i++;
		  while (((x[i] < xmin)||(x[i] > xmax)||
			  (y[i] < ymin)||(y[i] > ymax))&&(i<nls[j]))
		    i++;
	       }
	     if (n > 0)
	       Done ();
	     j++;
	     n = 0;
	  }

	/* Do axis labels in black */
	ForeColor (7);
	QueryWin (id, &twidth,&theight);
	PlaceText (id,5000,0000,HCENTER_TEXT|TOP_TEXT, file);
	PlaceText (id,5000,10000,HCENTER_TEXT|BOTTOM_TEXT, "X");
	PlaceText (id,0000,5000,LEFT_TEXT|VCENTER_TEXT, "Y");
	sprintf (axis, "%f", ymax);
	nchars = 1000/twidth;

	axis[nchars] = 0;
	PlaceText (id, 1000, 1000, RIGHT_TEXT|TOP_TEXT, axis);
	sprintf (axis, "%f", ymin);
	axis[nchars] = 0;
	PlaceText (id, 1000, 9000, RIGHT_TEXT|BOTTOM_TEXT,axis);
	sprintf (axis, "%f",xmax);
	PlaceText (id,9000,9000,HCENTER_TEXT|TOP_TEXT,axis);
	sprintf (axis,"%f",xmin);
	PlaceText (id,1000,9000,HCENTER_TEXT|TOP_TEXT,axis);
	fflush (stdout);
	n = 1;
	while ((n != 0)&&(n != 2))
	  {
	     n = WaitForCarriageReturn (&winclick, &xclick, &yclick);
	     if (n==1)
	       {
		  downx = xclick;
		  downy = yclick;
	       }
	     if (n==2)
	       {
		  upx = xclick;
		  upy = yclick;
		  if(upx < downx)
		    {
		       tmp = downx ;
		       downx = upx;
		       upx = tmp;
		    }
		  if(upy < downy)
		    {
		       tmp = downy ;
		       downy = upy;
		       upy = tmp;
		    }
		  xmin = (xmax-xmin)*(downx - 1000)/(8000)+xmin;
		  xmax = (xmax-xmin)*(upx - 1000)/(8000)+xmin;
		  ymax = ymax - (ymax-ymin)*(downy - 1000)/(8000);
		  ymin = ymax - (ymax-ymin)*(upy - 1000)/(8000);
	       }
	  }
     }
   nice_end (EXIT_SUCCESS);
   return EXIT_SUCCESS;
}
/*----------------------- end-of-file (C source) -----------------------*/
