// -*- C++ -*-
/*
 *  File:        formula.h
 *  Purpose:     Declaration of formula inset
 *  Author:      Alejandro Aguilar Sierra <asierra@servidor.unam.mx> 
 *  Created:     January 1996
 *  Description: Allows the edition of math paragraphs inside Lyx. 
 *
 *  Copyright: (c) 1996, Alejandro Aguilar Sierra
 *
 *  Version: 0.4, Lyx project.
 *
 *   You are free to use and modify this code under the terms of
 *   the GNU General Public Licence version 2 or later.
 */

#ifndef _INSET_FORMULA_H 
#define _INSET_FORMULA_H

#include "definitions.h"
#include "lyxinset.h"


class MathParInset;

class InsetFormula: public UpdatableInset {
 public:
   InsetFormula(bool display=false);
   InsetFormula(MathParInset*);
   ~InsetFormula();  
   int Ascent(LyXFont font);
   int Descent(LyXFont font);
   int Width(LyXFont font);
   void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
   void Write(FILE *file);
   void Read(FILE *file);
   int Latex(FILE *file);
   
   Inset* Clone(); 
   char LyxCode() { return LYX_MATH_CODE; }
   LyXFont ConvertFont(LyXFont font) {
      // this is necessary because otherwise (if font.latex is for
      // example LYX_FORMULA_LATEX) LyX would insert \( ... \).
      // Since this is ALWAYS done by write_math this would cause
      // a LaTeX error. 
      // I would prefer the LyX Text module to insert these LaTeX 
      // switches. 
      // We should discuss this soon. Matthias 
     font.latex = LYX_NO_LATEX;
     return font;
   }
   void Edit(int x, int y); 
   char Display() { return (disp_flag) ? 1: 0; }
   void SetDisplay(bool);

   void ToggleInsetCursor(); 
   void ShowInsetCursor(); 
   void HideInsetCursor(); 
   
   void InsetButtonPress(int x, int y, int button);
  void InsetButtonRelease(int x, int y, int button);
   void InsetKeyPress(XKeyEvent *ev);
//   void InsetMotionNotify(int x, int y, int state);
   void InsetUnlock();
   
   //  To allow transparent use of math editing functions
   char *LocalDispatch(int, char*);
   
   void InsertSymbol(const char*);
   bool SetNumber(bool);
 protected:
   void UpdateLocal(void);
 private:
   class MathParInset* par;
   int height;
   int width;
   bool disp_flag;
   char *label;
};


// If a mathinset exist at cursor pos, just lock it.
// Otherwise create a new one, and lock it.
bool OpenMathInset();

#endif
