# include <stdio.h>
# include <unistd.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "glob.h"
# include "hattrib.h"

extern char *optarg;
extern int optind;

/*
 * NAME:	usage()
 * DESCRIPTION:	display usage message
 */
static
int usage(char *argv[])
{
  fprintf(stderr,
	  "Usage: %s [-t TYPE] [-c CREA] [-|+i] [-|+l] hfs-path [...]\n",
	  argv[0]);

  return 1;
}

/*
 * NAME:	hattrib->main()
 * DESCRIPTION:	implement hattrib command
 */
int hattrib_main(int argc, char *argv[])
{
  char *type = 0, *creator = 0;

  while (1)
    {
      int opt;

      opt = getopt(argc, argv, "t:c:il");
      if (opt == EOF)
	break;

      switch (opt)
	{
	case '?':
	  return usage(argv);

	case 't':
	  type = optarg;
	  break;

	case 'c':
	  creator = optarg;
	  break;

	case 'i':
	  break;

	case 'l':
	  break;
	}
    }

  fprintf(stderr, "%s: not yet implemented\n", argv[0]);
  return 1;

# if 0
  if (argc < 2)
    {
      return 1;
    }

  vol = hfs_remount(argv[0], ent = hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  for (i = 1; i < argc; ++i)
    {
      if (hfs_delete(vol, argv[i]) < 0)
	{
	  hfs_perror(argv[i]);
	  result = 1;
	}
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  return result;
# endif
}
